/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.mv.gui.SurfaceHover;
import pyrosim.mv.tools.APyroTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.FaceCache;
import pyrosim.mv.tools.PyroToolHooks;
import pyrosim.mv.tools.SurfaceUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.MenuBuilder;
import thunderheadeng.gui.colorscheme.ColorHistory;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.tools.AdvancedTool;
import thunderheadeng.scene3d.tools.IAdvancedTool;
import thunderheadeng.scene3d.tools.IToggleListener;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.util.Pair;

public class SurfacePickerTool
extends APyroTool {
    private final DrawProps[] d_setProps;
    private Pair<ISurfObj, Integer> d_selection;
    private final FaceCache d_faceCache;
    private SurfaceHover d_popup;

    public SurfacePickerTool(PyroMod domain, IToolController mv, DrawProps pickerProps, DrawProps ... setProps) {
        super(mv, pickerProps, (IToolFunction)new ToolFunc());
        this.d_setProps = setProps;
        this.d_faceCache = new FaceCache(domain);
        this.addToggleListener(new IToggleListener(){

            @Override
            public void toolToggled(IAdvancedTool tool) {
                SurfaceUtil.chooseNextSurfaceSpecs(SurfacePickerTool.this.getProps());
                SurfacePickerTool.this.updatePopup();
            }
        });
        this.setMenuBuilder(PyroToolHooks.Menu.TOOL_ACTIONS.key, (IAdvancedTool tool, MenuBuilder builder) -> builder.addMutuallyExclusive(new PickPropAction(true, false), new PickPropAction(false, true), new PickPropAction(true, true)));
    }

    @Override
    public Point3d getAngledSnapBasis() {
        return null;
    }

    @Override
    public void pointAdded(MouseHistory history, MouseHistory.Point p) {
    }

    private boolean getPickPropState(boolean surface, boolean color) {
        return this.getProps().get(DrawProps.SPECIFY_SURFACE) == surface && this.getProps().get(DrawProps.SPECIFY_COLOR) == color;
    }

    private static String getPickPropDesc(boolean surface, boolean color) {
        if (surface && color) {
            return Intl.intl("Pick Surface + Color");
        }
        if (surface) {
            return Intl.intl("Pick Surface only");
        }
        return Intl.intl("Pick Color only");
    }

    protected SurfaceHover getPopup() {
        if (this.d_popup == null) {
            this.d_popup = new SurfaceHover(this.getModelView().getRenderComp());
        }
        return this.d_popup;
    }

    @Override
    protected String getStatusMessage() {
        Surface surf = this.getSelectedSurf();
        return surf == null ? "" : String.format(Intl.intl("Surface: %s"), surf.getName());
    }

    @Override
    protected Pair<SnapMode, IIsectFilter> getSnapInfo() {
        return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_ONE_PASS, new DefaultFilter(ISurfObj.class, GeomType.FACE));
    }

    @Override
    public ISnapConstraint getSnapConstraint() {
        return null;
    }

    protected void updatePickFace() {
        Pair<ISurfObj, Integer> newSel = null;
        Collection<IsectInfo> ii = this.getP1().snaps;
        if (!ii.isEmpty()) {
            IsectInfo info = ii.iterator().next();
            assert (info.obj instanceof ISurfObj);
            ISurfObj obst = (ISurfObj)info.obj;
            IFace[] faces = this.d_faceCache.getFaces((ISurfObj)obst).faces;
            for (int m = 0; m < faces.length; ++m) {
                IFace iface = faces[m];
                Point3d projp = iface.project(info.isectPoint);
                if (!projp.epsilonEquals(info.isectPoint, 1.0E-6) || !iface.classify((Point3d)projp, (double)1.0E-6).positive) continue;
                newSel = new Pair<ISurfObj, Integer>(obst, m);
                break;
            }
        }
        this.d_selection = newSel;
        this.repaintSurface();
    }

    protected void updatePopup() {
        if (this.d_selection == null) {
            this.getPopup().setVisible(false);
            return;
        }
        boolean pickSurf = this.getProps().get(DrawProps.SPECIFY_SURFACE);
        boolean pickColor = this.getProps().get(DrawProps.SPECIFY_COLOR);
        Surface surf = this.getSelectedSurf();
        Color color = this.getSelectedColor();
        this.getPopup().update(Intl.intl("Pick"), pickSurf, surf, pickColor, color);
    }

    @Override
    public void finish() {
        this.reset();
        super.finish();
    }

    @Override
    public boolean cancel() {
        this.reset();
        return super.cancel();
    }

    @Override
    public void reset() {
        this.getPopup().setVisible(false);
        this.d_selection = null;
        this.d_faceCache.clear();
    }

    @Override
    public void activate() {
        super.activate();
        this.getPopup().attach();
    }

    @Override
    public void deactivate() {
        this.getPopup().detach();
        super.deactivate();
    }

    protected Surface getSelectedSurf() {
        if (this.d_selection == null) {
            return null;
        }
        Surface[] surfs = ((ISurfObj)this.d_selection.v1).getSurfaces();
        return surfs.length == 1 ? surfs[0] : surfs[(Integer)this.d_selection.v2];
    }

    protected Color getSelectedColor() {
        if (this.d_selection == null) {
            return null;
        }
        Color[] colors = ((ISurfObj)this.d_selection.v1).getColors();
        return colors.length == 1 ? colors[0] : colors[(Integer)this.d_selection.v2];
    }

    protected static class ToolFunc
    extends AdvancedTool.ToolFunc<SurfacePickerTool> {
        protected ToolFunc() {
        }

        @Override
        public void mouseMoved(SurfacePickerTool tool, MouseEvent e) {
            super.mouseMoved(tool, e);
            tool.updatePickFace();
            tool.updatePopup();
        }

        @Override
        public void mouseDragged(SurfacePickerTool tool, MouseEvent e) {
            super.mouseDragged(tool, e);
            tool.updatePickFace();
            tool.updatePopup();
        }

        @Override
        public void mouseReleased(SurfacePickerTool tool, MouseEvent e) {
            super.mouseReleased(tool, e);
            tool.updatePickFace();
            if (e.getButton() == 1 && tool.d_selection != null) {
                if (tool.getProps().get(DrawProps.SPECIFY_SURFACE).booleanValue()) {
                    Surface surf = tool.getSelectedSurf();
                    for (DrawProps props : tool.d_setProps) {
                        props.set(DrawProps.SURFACE, surf);
                    }
                }
                if (tool.getProps().get(DrawProps.SPECIFY_COLOR).booleanValue()) {
                    Color color = tool.getSelectedColor();
                    for (DrawProps props : tool.d_setProps) {
                        props.set(DrawProps.COLOR, color);
                    }
                    if (color != null) {
                        ColorHistory.add(color);
                    }
                }
                tool.finish();
            }
        }
    }

    protected class PickPropAction
    extends BooleanAction {
        private static final long serialVersionUID = 3002203575155581285L;
        private final boolean d_surface;
        private final boolean d_color;

        public PickPropAction(boolean surface, boolean color) {
            super(SurfacePickerTool.getPickPropDesc(surface, color), SurfacePickerTool.this.getPickPropState(surface, color));
            this.d_surface = surface;
            this.d_color = color;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                SurfacePickerTool.this.getProps().set(DrawProps.SPECIFY_SURFACE, this.d_surface);
                SurfacePickerTool.this.getProps().set(DrawProps.SPECIFY_COLOR, this.d_color);
                SurfacePickerTool.this.updatePopup();
            }
        }
    }
}

