/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.snappers;

import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.mv.snappers.IGridSnapper;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.GridSnapperDisp;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.Pair;

public class SnapToGrid
extends GridSnapperDisp
implements IGridSnapper,
Modifiable {
    private static final long serialVersionUID = 208355739999371334L;
    private View d_view;
    private boolean d_modified = false;

    public SnapToGrid(View view, double spacing) {
        super(spacing);
        this.d_view = view;
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
    }

    @Override
    public AABox getBounds() {
        return new AABox(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return DisplayGeom.EMPTY;
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull box) {
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
        if (!filter.acceptPickObject(this)) {
            return;
        }
        boolean edges = filter.acceptGeomType(this, GeomType.EDGE);
        boolean verts = filter.acceptGeomType(this, GeomType.VERTEX);
        if (!edges && !verts) {
            return;
        }
        int axis = Util3D.getClosestAxis(rayDirN);
        if (edges) {
            this.getClosestPoints(isects, GeomType.EDGE, axis, rayBegin, rayDirN);
        }
        if (verts) {
            this.getClosestPoints(isects, GeomType.VERTEX, axis, rayBegin, rayDirN);
        }
    }

    private void getClosestPoints(IIsectCollector isects, GeomType type, int axis, Point3d rayBegin, Vector3d rayDirN) {
        switch (axis) {
            case 0: {
                isects.addInfinite(this, this.getXPlaneSnapPoint(type, rayBegin, rayDirN), type, null);
                break;
            }
            case 1: {
                isects.addInfinite(this, this.getYPlaneSnapPoint(type, rayBegin, rayDirN), type, null);
                break;
            }
            case 2: {
                isects.addInfinite(this, this.getZPlaneSnapPoint(type, rayBegin, rayDirN), type, null);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Point3d getXPlaneSnapPoint(GeomType snapType, Point3d rayBegin, Vector3d rayDirN) {
        Point3d isect = new Point3d();
        if (!Inter3D.lineXPlaneIntersection(isect, rayBegin, rayDirN, 0.0, 0.0)) {
            return null;
        }
        Point2d localSnap = this.getPlaneSnapPoint(snapType, isect.y, isect.z);
        return localSnap == null ? null : new Point3d(isect.x, localSnap.x, localSnap.y);
    }

    public Point3d getYPlaneSnapPoint(GeomType snapType, Point3d rayBegin, Vector3d rayDirN) {
        Point3d isect = new Point3d();
        if (!Inter3D.lineYPlaneIntersection(isect, rayBegin, rayDirN, 0.0, 0.0)) {
            return null;
        }
        Point2d localSnap = this.getPlaneSnapPoint(snapType, isect.x, isect.z);
        return localSnap == null ? null : new Point3d(localSnap.x, isect.y, localSnap.y);
    }

    public Point3d getZPlaneSnapPoint(GeomType snapType, Point3d rayBegin, Vector3d rayDirN) {
        Point3d isect = new Point3d();
        if (!Inter3D.lineZPlaneIntersection(isect, rayBegin, rayDirN, 0.0, 0.0)) {
            return null;
        }
        Point2d localSnap = this.getPlaneSnapPoint(snapType, isect.x, isect.y);
        return localSnap == null ? null : new Point3d(localSnap.x, localSnap.y, isect.z);
    }

    private Point2d getPlaneSnapPoint(GeomType snapType, double x, double y) {
        double spacing = this.getSpacing();
        double x2 = (double)Math.round(x / spacing) * spacing;
        double y2 = (double)Math.round(y / spacing) * spacing;
        if (snapType == GeomType.VERTEX) {
            return new Point2d(x2, y2);
        }
        double dx = x - x2;
        double xDistSq = dx * dx;
        double dy = y - y2;
        double yDistSq = dy * dy;
        if (xDistSq <= yDistSq) {
            return new Point2d(x2, y);
        }
        return new Point2d(x, y2);
    }

    @Override
    public void pickCells(IIsectCollector isects, Point3d rayBegin, Vector3d rayDir, ITest<AABox> tester) {
        Point3d isect = null;
        Pair bestPlane = null;
        if (this.d_view.getCamera() instanceof OrthoCamera) {
            Pair[] planes;
            for (Pair plane : planes = new Pair[]{new Pair<Plane3d, Byte>(new Plane3d(0.0, 0.0, 1.0, 0.0), (byte)2), new Pair<Plane3d, Byte>(new Plane3d(0.0, 1.0, 0.0, 0.0), (byte)1), new Pair<Plane3d, Byte>(new Plane3d(1.0, 0.0, 0.0, 0.0), (byte)0)}) {
                Point3d pisect = Inter3D.linePlaneIntersection(rayBegin, rayDir, (Plane3d)plane.v1, 1.0E-6);
                if (pisect == null) continue;
                isect = pisect;
                bestPlane = plane;
                break;
            }
        }
        if (isect == null) {
            return;
        }
        double spacing = this.getSpacing();
        double invSpacing = 1.0 / spacing;
        double x = isect.x * invSpacing;
        double y = isect.y * invSpacing;
        double z = isect.z * invSpacing;
        double xMin = Math.floor(x) * spacing;
        double yMin = Math.floor(y) * spacing;
        double zMin = Math.floor(z) * spacing;
        double xMax = Math.ceil(x) * spacing;
        double yMax = Math.ceil(y) * spacing;
        double zMax = Math.ceil(z) * spacing;
        if (xMin == xMax) {
            xMax += 1.0;
        }
        if (yMin == yMax) {
            yMax += 1.0;
        }
        if (zMin == zMax) {
            zMax += 1.0;
        }
        AARectangle poly = null;
        switch ((Byte)bestPlane.v2) {
            case 0: {
                poly = new AARectangle(0, 0.0, yMin, zMin, yMax, zMax, false);
                break;
            }
            case 1: {
                poly = new AARectangle(1, 0.0, xMin, zMin, xMax, zMax, false);
                break;
            }
            case 2: {
                poly = new AARectangle(2, 0.0, xMin, yMin, xMax, yMax, false);
            }
        }
        if (poly == null) {
            return;
        }
        AARectangle fpoly = poly;
        isects.addFace(this, isect, () -> fpoly, () -> fpoly.getNormal(true), IPrimProps.DEF);
    }
}

