/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.IPyroDisplayMgr;
import pyrosim.mv.snappers.IGridSnapper;
import pyrosim.mv.snappers.ISnapper;
import pyrosim.mv.snappers.OriginSnapper;
import pyrosim.mv.snappers.SnapToGrid;
import pyrosim.mv.tools.IPyroFunc;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxf;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.RTreef;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.MultiFunc;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickConfig;
import thunderheadeng.scene3d.picking.IPickRoot;
import thunderheadeng.scene3d.picking.IPickSession;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.tools.IAdvancedTool;
import thunderheadeng.util.Predicates;

public class PyroPickRoot
implements IPickRoot {
    private final PyroMod d_domain;
    private final ModelView d_mv;

    public PyroPickRoot(PyroMod domain, ModelView mv) {
        this.d_domain = domain;
        this.d_mv = mv;
    }

    @Override
    public IPickSession beginPicking() {
        return new Session();
    }

    private static Point3d getAngleSnapBasis(Tool currTool) {
        IPyroFunc pfunc;
        if (currTool instanceof IAdvancedTool) {
            return ((IAdvancedTool)currTool).getAngledSnapBasis();
        }
        if (currTool instanceof CursorTool && (pfunc = PyroPickRoot.getPyroFunc((CursorTool)currTool)) != null) {
            return pfunc.getAngledSnapBasis((CursorTool)currTool);
        }
        return null;
    }

    private static IPyroFunc getPyroFunc(CursorTool tool) {
        MultiFunc mf;
        IToolFunction<CursorTool> func = tool.getFunction();
        if (func instanceof IPyroFunc) {
            return (IPyroFunc)func;
        }
        if (func instanceof MultiFunc && (func = (mf = (MultiFunc)func).getActiveFunc(tool)) instanceof IPyroFunc) {
            return (IPyroFunc)func;
        }
        return null;
    }

    private static int getClassPreference(Object obj) {
        if (obj instanceof IHandle) {
            return 0;
        }
        if (obj instanceof HvacNode) {
            return 1;
        }
        if (obj instanceof FlowMeasurer) {
            return 2;
        }
        if (obj instanceof Vent) {
            return 3;
        }
        if (obj instanceof IHole) {
            return 4;
        }
        return 5;
    }

    private class Session
    implements IPickSession {
        private final Camera d_camera;
        private int d_active;
        private PyroMod.Lock d_lock;

        private Session() {
            this.d_camera = PyroPickRoot.this.d_mv.getMainView().getCamera();
            this.d_active = 0;
        }

        @Override
        public boolean isActive() {
            return this.d_active > 0;
        }

        @Override
        public void begin() {
            ++this.d_active;
            this.d_lock = PyroPickRoot.this.d_domain.beginRead();
        }

        @Override
        public void end() {
            this.d_lock.close();
            --this.d_active;
            assert (this.d_active >= 0);
        }

        @Override
        public boolean isVisible(IPickConfig config, Object o) {
            assert (this.isActive());
            if (PyroPickRoot.this.d_mv.getManipMgr().isManipulating() && (o instanceof IHandle || PyroPickRoot.this.d_mv.getManipMgr().isManipulating(o))) {
                return false;
            }
            if (o instanceof IDisplayableGeomSrc) {
                boolean enabled = !(o instanceof IPyroObject) || ((IPyroObject)o).isEnabled();
                IDisplayableGeomSrc src = (IDisplayableGeomSrc)o;
                return src.isVisible() && enabled && !((PyroPickRoot)PyroPickRoot.this).d_mv.getDisplayManager().d_dispFilter.filter(o) || PyroPickRoot.this.d_domain.getSelectionModel().isSelected(src);
            }
            if (o instanceof ISnapConstraint) {
                return true;
            }
            return true;
        }

        @Override
        public IPickConfig[] getPickConfigs() {
            assert (this.isActive());
            return new IPickConfig[]{new GeomConfig(), new InfiniteConfig()};
        }

        private void findInDomain(ITest<AABox> test, IResult<? super IDisplayableGeomSrc> result, boolean quick) {
            PyroPickRoot.this.d_domain.getGeomLocator().find(test, result, true, !quick);
        }

        private Predicate<Object> getFiniteSnapperFilter() {
            return o -> o instanceof ISnapper && !this.isInfiniteSnapper((ISnapper)o);
        }

        private boolean isInfiniteSnapper(ISnapper obj) {
            return obj instanceof SnapToGrid || obj instanceof OriginSnapper;
        }

        private void findAdditionalSnaps(ITest<AABox> test, IResult<IPickable> result) {
            IPickSession.findAdditionalSnaps(test, result, this.d_camera, PyroPickRoot.this.d_mv.getManipMgr().isManipulating(), () -> {
                Tool tool = PyroPickRoot.this.d_mv.getToolManager().getCurrentTool();
                return PyroPickRoot.getAngleSnapBasis(tool);
            });
        }

        @Override
        public void pickPoints(IPickable obj, IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
            assert (this.isActive());
            obj.pickPoints(isects, filter, rayBegin, rayDirN, maxDist, tester, PyroPickRoot.this.d_mv.getDrawProps());
        }

        @Override
        public void pickBox(IPickable obj, IBoxCollector result, IIsectFilter filter, ConvexHull region) {
            assert (this.isActive());
            obj.pickBox(result, filter, region, PyroPickRoot.this.d_mv.getDrawProps());
        }

        @Override
        public boolean isWireframe(IPickConfig config, Object o) {
            assert (this.isActive());
            return PyroPickRoot.this.d_mv.isWireframe(o);
        }

        @Override
        public int compare(Object o1, Object o2) {
            assert (this.isActive());
            return PyroPickRoot.getClassPreference(o1) - PyroPickRoot.getClassPreference(o2);
        }

        @Override
        public boolean isOcclusionTarget(Object o, boolean occludeGuides) {
            assert (this.isActive());
            if (o instanceof IGridSnapper) {
                return this.d_camera instanceof PerspectiveCamera;
            }
            return !(o instanceof ISnapper) && !(o instanceof ISnapConstraint);
        }

        @Override
        public boolean isOcclusionSource(Object o) {
            assert (this.isActive());
            return (!PyroPickRoot.this.d_mv.getManipMgr().isManipulating() || PyroPickRoot.this.d_mv.getManipMgr().getCurrentManipObj() != o) && !PyroPickRoot.this.d_mv.getTransformMgr().isTransforming(o) && !(o instanceof IHandle) && this.isOccluder(o);
        }

        private boolean isOccluder(Object o) {
            return TVEntryPoints.ep(o).isOccluder(PyroPickRoot.this.d_domain, o);
        }

        private class InfiniteConfig
        implements IPickConfig {
            private InfiniteConfig() {
            }

            @Override
            public ConvexHull getClippingRegion() {
                return new ConvexHull(new Plane3d[0]);
            }

            @Override
            public void find(ITest<AABox> test, IResult<IPickable> result, boolean quick) {
                assert (Session.this.isActive());
                Session.this.findAdditionalSnaps(test, result);
                Predicate clipFilter = Predicates.alwaysFalse();
                for (IPyroDisplayMgr<?> mgr : PyroPickRoot.this.d_mv.getClipManager().getClippedDisplayMgrs()) {
                    clipFilter = Predicates.or(clipFilter, mgr.getObjFilter().toArbitraryPredicate());
                }
                Predicate fclipFilter = Predicates.or(clipFilter, Session.this.getFiniteSnapperFilter());
                IResult<IPickable> baseResult = result;
                IResult<IDisplayableGeomSrc> fresult = (obj, ctmt) -> {
                    if (obj instanceof IPickable && !fclipFilter.test(obj)) {
                        baseResult.mark((IPickable)((Object)obj), ctmt);
                    }
                };
                Session.this.findInDomain(test, fresult, quick);
            }
        }

        private class GeomConfig
        implements IPickConfig {
            private GeomConfig() {
            }

            @Override
            public ConvexHull getClippingRegion() {
                assert (Session.this.isActive());
                return PyroPickRoot.this.d_mv.getClipManager().getClipRegion();
            }

            @Override
            public void find(ITest<AABox> test, IResult<IPickable> baseResult, boolean quick) {
                assert (Session.this.isActive());
                BiFunction<Predicate, IPyroDisplayMgr, IResult> filterResult = (filter, dmgr) -> (obj, ctmt) -> {
                    if (obj instanceof ISnapper && !Session.this.isInfiniteSnapper((ISnapper)obj)) {
                        baseResult.mark((ISnapper)obj, ctmt);
                        return;
                    }
                    if (!filter.test(obj)) {
                        return;
                    }
                    IPickable picker = dmgr.getPicker(obj);
                    if (picker == null) {
                        return;
                    }
                    baseResult.mark(picker, ctmt);
                };
                ITest<AABoxf> dispTest = AABox.toAABoxfTest(test);
                Predicate domainFilter = Predicates.alwaysFalse();
                for (IPyroDisplayMgr<?> mgr : PyroPickRoot.this.d_mv.getClipManager().getClippedDisplayMgrs()) {
                    Optional<RTreef<?>> search = mgr.getSearchTree();
                    if (!search.isPresent()) {
                        domainFilter = Predicates.or(domainFilter, mgr.getObjFilter().toArbitraryPredicate());
                        continue;
                    }
                    if (quick) continue;
                    IResult dispResult = filterResult.apply(Predicates.alwaysTrue(), mgr);
                    search.get().find(dispTest, (IResult<?>)dispResult);
                }
                Session.this.findInDomain(test, filterResult.apply(domainFilter, PyroPickRoot.this.d_mv.getDisplayManager()), quick);
            }
        }
    }
}

