/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.HashMap;
import java.util.Map;
import pyrosim.legacy_2012_1.thunderheadeng.util.Keyable;

public final class Sizeof {
    public static final int BYTE = 1;
    public static final int SHORT = 2;
    public static final int LONG = 8;
    public static final int BOOLEAN = 1;
    public static final int CHAR = 2;
    public static final int INT = 4;
    public static final int FLOAT = 4;
    public static final int DOUBLE = 8;
    public static final int PNATIVE = 4;
    private static final Map<Class, Integer> s_objectSizeMap = new HashMap<Class, Integer>();

    public static final int String(String str) {
        if (str == null) {
            return 4;
        }
        return 4 + 2 * str.length();
    }

    public static final int Object(Object obj) {
        if (obj == null) {
            return 4;
        }
        Integer size = s_objectSizeMap.get(obj.getClass());
        if (size != null) {
            return size;
        }
        if (obj instanceof Keyable) {
            return 4;
        }
        if (obj instanceof String) {
            return Sizeof.String((String)obj);
        }
        if (obj instanceof byte[]) {
            return 1 * ((byte[])obj).length;
        }
        if (obj instanceof short[]) {
            return 2 * ((short[])obj).length;
        }
        if (obj instanceof long[]) {
            return 8 * ((long[])obj).length;
        }
        if (obj instanceof boolean[]) {
            return 1 * ((boolean[])obj).length;
        }
        if (obj instanceof char[]) {
            return 2 * ((char[])obj).length;
        }
        if (obj instanceof int[]) {
            return 4 * ((int[])obj).length;
        }
        if (obj instanceof float[]) {
            return 4 * ((float[])obj).length;
        }
        if (obj instanceof double[]) {
            return 8 * ((double[])obj).length;
        }
        if (obj instanceof Object[]) {
            int objsSize = 0;
            Object[] objs = (Object[])obj;
            for (int m = 0; m < objs.length; ++m) {
                objsSize += Sizeof.Object(objs[m]);
            }
            return objsSize;
        }
        return 0;
    }

    static {
        s_objectSizeMap.put(Byte.class, 1);
        s_objectSizeMap.put(Short.class, 2);
        s_objectSizeMap.put(Long.class, 8);
        s_objectSizeMap.put(Boolean.class, 1);
        s_objectSizeMap.put(Character.class, 2);
        s_objectSizeMap.put(Integer.class, 4);
        s_objectSizeMap.put(Float.class, 4);
        s_objectSizeMap.put(Double.class, 8);
    }
}

