/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import pyrosim.legacy_2012_1.thunderheadeng.util.AcceptAllFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredIterator;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;

public class FilteredCollection<T>
extends AbstractCollection<T> {
    private final Map<T, Boolean> d_filterCache;
    private int d_size = -1;
    private final Class<T> d_type;
    private final Collection<?> d_objs;
    private IObjectFilter<T> d_filter;
    private Boolean d_cachedEmpty = null;
    private Boolean d_cachedExclusive = null;

    public FilteredCollection(Collection<?> objs, Class<T> type) {
        this(objs, type, false);
    }

    public FilteredCollection(Collection<?> objs, Class<T> type, boolean cacheFilter) {
        this(objs, type, new AcceptAllFilter(), cacheFilter);
    }

    public FilteredCollection(Collection<?> objs, Class<T> type, IObjectFilter<T> filter) {
        this(objs, type, filter, false);
    }

    public FilteredCollection(Collection<?> objs, Class<T> type, IObjectFilter<T> filter, boolean cacheFilter) {
        this.d_objs = objs;
        this.d_filter = filter;
        this.d_type = type;
        this.d_filterCache = cacheFilter ? new IdentityHashMap() : null;
    }

    public boolean isExclusive() {
        if (this.d_cachedExclusive == null) {
            Iterator it = this.iterator();
            while (((FilteredIterator)it).hasNext() && ((FilteredIterator)it).getSkippedCount() <= 0) {
                ((FilteredIterator)it).next();
            }
            this.d_cachedExclusive = ((FilteredIterator)it).getSkippedCount() == 0;
        }
        return this.d_cachedExclusive;
    }

    @Override
    public boolean contains(Object o) {
        return this.d_type.isInstance(o) && !this.d_filter.shouldFilter(this.d_type.cast(o)) && super.contains(o);
    }

    @Override
    public FilteredIterator<T> iterator() {
        return new FilteredIterator<T>(this.d_objs, this.d_type, this.d_filter, this.d_filterCache);
    }

    @Override
    public int size() {
        if (this.d_size == -1) {
            this.d_size = 0;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                ++this.d_size;
                it.next();
            }
        }
        return this.d_size;
    }

    @Override
    public boolean isEmpty() {
        if (this.d_cachedEmpty == null) {
            Iterator it;
            this.d_cachedEmpty = this.d_size == -1 ? Boolean.valueOf(!(it = this.iterator()).hasNext()) : Boolean.valueOf(this.d_size == 0);
        }
        return this.d_cachedEmpty;
    }
}

