/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Mediator;
import pyrosim.legacy_2012_1.thunderheadeng.util.EmptyTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.Sets;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;

public class CompositeTask<T extends Mediator>
implements Task {
    private static final int STATE_PREDETERMINEDTASKS = 0;
    private static final int STATE_FIRSTRUNTIMETASKS = 1;
    private static final int STATE_LASTRUNTIMETASKS = 2;
    private static final int STATE_TASKADDINGCOMPLETE = 3;
    private int d_state = 0;
    private List<Task> d_currentAddTasks;
    private List<Task> d_predeterminedTasks;
    private List<Task> d_firstRuntimeTasks;
    private List<Task> d_lastRuntimeTasks;
    private final Set<T> d_mediators;

    protected void queueBeginRuntimeTasks() {
    }

    protected void queueEndRuntimeTasks() {
    }

    public CompositeTask(T mediator) {
        this(mediator != null ? Sets.fromArrayIHS(mediator) : new IdentityHashSet());
    }

    public CompositeTask(Set<T> mediators) {
        this.d_mediators = new IdentityHashSet<T>(mediators);
    }

    public final Set<T> getDomains() {
        return this.d_mediators;
    }

    public void addTask(Task t) {
        if (t == EmptyTask.INSTANCE) {
            return;
        }
        assert (this.d_predeterminedTasks == null || this.d_firstRuntimeTasks == null || this.d_lastRuntimeTasks == null);
        if (t == null) {
            return;
        }
        List<Task> tasks = this.getCurrentTasks();
        tasks.add(t);
    }

    private List<Task> getCurrentTasks() {
        switch (this.d_state) {
            case 0: {
                if (this.d_predeterminedTasks == null) {
                    this.d_predeterminedTasks = new ArrayList<Task>();
                }
                return this.d_predeterminedTasks;
            }
            case 1: {
                if (this.d_firstRuntimeTasks == null) {
                    this.d_firstRuntimeTasks = new ArrayList<Task>();
                }
                return this.d_firstRuntimeTasks;
            }
            case 2: {
                if (this.d_lastRuntimeTasks == null) {
                    this.d_lastRuntimeTasks = new ArrayList<Task>();
                }
                return this.d_lastRuntimeTasks;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public boolean canUndo() {
        return this.canUndoList(this.d_predeterminedTasks) && this.canUndoList(this.d_firstRuntimeTasks) && this.canUndoList(this.d_lastRuntimeTasks);
    }

    private boolean canUndoList(List<Task> list) {
        if (list == null) {
            return true;
        }
        for (Task t : list) {
            if (t.canUndo()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getEst() {
        int est = 0;
        int predetEst = this.getListEst(this.d_predeterminedTasks);
        int firstEst = this.getListEst(this.d_firstRuntimeTasks);
        int lastEst = this.getListEst(this.d_lastRuntimeTasks);
        if (predetEst > est) {
            est = predetEst;
        }
        if (firstEst > est) {
            est = firstEst;
        }
        if (lastEst > est) {
            est = lastEst;
        }
        return est;
    }

    public int getListEst(List<Task> list) {
        int est = 0;
        if (list == null) {
            return est;
        }
        for (Task t : list) {
            if (t.getEst() <= est) continue;
            est = t.getEst();
        }
        return est;
    }

    @Override
    public void undo() {
        this.pauseUpdates();
        this.undoList(this.d_lastRuntimeTasks);
        this.undoList(this.d_predeterminedTasks);
        this.undoList(this.d_firstRuntimeTasks);
        this.resumeUpdates();
    }

    private void undoList(List<Task> list) {
        if (list == null) {
            return;
        }
        ListIterator<Task> revIt = list.listIterator(list.size());
        while (revIt.hasPrevious()) {
            revIt.previous().undo();
        }
    }

    @Override
    public void run() {
        this.pauseUpdates();
        if (this.d_state != 3) {
            this.d_state = 1;
            this.queueBeginRuntimeTasks();
            this.d_state = 2;
            this.queueEndRuntimeTasks();
            this.d_state = 3;
        }
        this.runList(this.d_firstRuntimeTasks);
        this.runList(this.d_predeterminedTasks);
        this.runList(this.d_lastRuntimeTasks);
        this.resumeUpdates();
    }

    private void runList(List<Task> list) {
        if (list == null) {
            return;
        }
        for (Task t : list) {
            t.run();
        }
    }

    protected void pauseUpdates(boolean listenToEvents) {
        for (Mediator med : this.d_mediators) {
            med.pauseUpdates(listenToEvents);
        }
    }

    protected void pauseUpdates() {
        for (Mediator med : this.d_mediators) {
            med.pauseUpdates();
        }
    }

    protected void resumeUpdates() {
        for (Mediator med : this.d_mediators) {
            med.resumeUpdates();
        }
    }
}

