/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.license3;

import com.reprisesoftware.rlm.RlmAvailableProduct;
import com.reprisesoftware.rlm.RlmException;
import com.reprisesoftware.rlm.RlmHandle;
import com.reprisesoftware.rlm.RlmLicense;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.util.TeciProps;

public class LicenseManager {
    private final String d_productName;
    private final String d_license;
    private final String d_lmVersion;
    private RlmHandle d_rlm = null;
    private RlmLicense d_product = null;
    private Map<String, RlmLicense> d_options = new HashMap<String, RlmLicense>();
    private String d_licLoc = ".";
    private String d_lastError = "";
    private Timer d_timer;
    private int d_strikes = 0;

    public LicenseManager(String productName, String license, String lmVersion) {
        this.d_productName = productName;
        this.d_lmVersion = lmVersion;
        this.d_license = license;
    }

    public synchronized boolean startLM(String licenseLoc) {
        RlmAvailableProduct prod;
        if (licenseLoc == null) {
            licenseLoc = "";
        }
        try {
            System.out.println("*** Using " + licenseLoc);
            this.d_rlm = new RlmHandle(licenseLoc, ".", this.d_license);
        }
        catch (RlmException e) {
            System.out.println("RLM Handle Exception...");
            System.out.println(e.getMessage());
            this.d_lastError = e.getMessage();
            return false;
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("RLM Handle Exception...");
            System.out.println(e.getMessage());
            this.d_lastError = e.getMessage();
            return false;
        }
        try {
            this.d_product = new RlmLicense(this.d_rlm, this.d_productName, this.d_lmVersion, 1);
        }
        catch (RlmException e) {
            System.out.println("RLM License Exception...");
            System.out.println(e.getMessage());
            this.d_lastError = e.getMessage();
            return false;
        }
        try {
            prod = this.getProduct();
        }
        catch (NoAvailableProductsException e) {
            prod = null;
        }
        double maxver = Double.parseDouble(this.d_product.getVersion());
        double curver = Double.parseDouble(this.d_lmVersion);
        if ((this.d_product.getHostID().equals("") && (this.d_product.getHostID().equalsIgnoreCase("ANY") || this.d_product.getShare() != 3 || prod != null && prod.getCount() == 0) || maxver - curver > 5.0 || this.d_product.getIssuer().toLowerCase().contains("lz0")) && Application.getApp() != null) {
            TeciProps props = Application.getApp().getPrefs();
            boolean logged = props.getBoolean("runlog", false);
            if (!logged) {
                LicenseManager.reportAbuse(this.d_productName, this.d_lmVersion, "firstrun");
                props.set("runlog", (Object)true);
            } else {
                LicenseManager.reportAbuse(this.d_productName, this.d_lmVersion, "run");
            }
        }
        if (this.d_product.getHostID().equals("")) {
            System.out.println("Starting timer");
            this.d_strikes = 0;
            this.d_timer = new Timer(true);
            this.d_timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    LicenseManager.this.checkServerStatus();
                }
            }, 60000L, 60000L);
        }
        return true;
    }

    private synchronized void checkServerStatus() {
        block9: {
            int status = -1;
            if (this.d_product != null) {
                try {
                    status = this.d_product.getAttrHealth();
                }
                catch (RlmException ex) {
                    System.out.println("RLM License Exception...");
                    System.out.println(ex.getMessage());
                }
            }
            if (status != 0 && status != -25) {
                System.out.println("License Server Down -- status: " + status);
                ++this.d_strikes;
                if (this.d_strikes >= 3) {
                    this.checkin();
                    try {
                        this.d_product = new RlmLicense(this.d_rlm, this.d_productName, this.d_lmVersion, 1);
                    }
                    catch (RlmException e) {
                        System.out.println("RLM License Exception...");
                        System.out.println(e.getMessage());
                        this.d_lastError = e.getMessage();
                        JOptionPane.showMessageDialog(null, Intl.intl("Lost floating license -- closing program."), String.format(Intl.intl("%s (Unlicensed)"), this.d_productName), 0);
                        System.out.println("Licensing failure. Shutting down.");
                        if (Application.getApp() != null) {
                            Application.getApp().quit(false);
                            break block9;
                        }
                        System.exit(0);
                    }
                }
            } else {
                System.out.println("License Server OK");
                this.d_strikes = 0;
            }
        }
    }

    private static void reportAbuse(final String prod, final String vers, final String event) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String strUrl = "http://www.pyrosim.legacy_2012_1.thunderheadeng.com/runlog.php?prod=" + prod + "&vers=" + vers + "&event=" + event;
                    URL url = new URL(strUrl);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.getResponseCode();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        t.start();
    }

    public String getHostID() {
        return this.d_rlm.getHostID(1).trim();
    }

    public String getHostIDs() {
        if (this.d_rlm == null) {
            return Intl.intl("unavailable");
        }
        String[] ethers = this.d_rlm.getAllHostIDs(3);
        String ether = "";
        for (int i = 0; i < ethers.length; ++i) {
            if (i > 0) {
                ether = ether + " ";
            }
            ether = ether + ethers[i].trim();
        }
        return "hostid=" + this.d_rlm.getHostID(1).trim() + "\n" + "ether=" + ether + "\n" + this.d_rlm.getHostID(6).trim();
    }

    public String getEth0(String def) {
        String[] ether = this.d_rlm.getAllHostIDs(3);
        if (ether != null && 0 < ether.length) {
            return ether[0];
        }
        return def;
    }

    public String getLicenseLocation() {
        return this.d_product == null ? "" : this.d_product.getLFPath();
    }

    public boolean isAuthorized() {
        return this.d_product != null && this.d_product.goodOnce();
    }

    public boolean isRoaming() {
        return this.d_product != null && this.d_product.isRoaming();
    }

    public boolean inQueue() {
        if (this.d_product != null) {
            try {
                if (this.d_product.status() == -25) {
                    return true;
                }
            }
            catch (RlmException e) {
                System.out.println("RLM License Exception...");
                System.out.println(e.getMessage());
                return false;
            }
        }
        return false;
    }

    public int getDaysRemaining() {
        return this.d_product.daysToExpiration();
    }

    private RlmAvailableProduct getProduct() throws NoAvailableProductsException {
        Vector prod = this.d_rlm.getAvailableProducts(this.d_productName, this.d_lmVersion);
        if (prod == null) {
            throw new NoAvailableProductsException();
        }
        return (RlmAvailableProduct)prod.get(0);
    }

    public String getDescription() {
        String desc = Intl.intl("unknown error");
        if (this.d_rlm == null || this.d_product == null) {
            return this.d_lastError;
        }
        if (this.isAuthorized() || this.inQueue()) {
            try {
                RlmAvailableProduct psProd = this.getProduct();
                desc = "";
                int maxcount = psProd.getCount();
                System.out.println("Host ID: " + this.d_product.getHostID());
                String type = this.d_product.getHostID().equals("") ? Intl.intl("Floating") : Intl.intl("Node-Locked");
                String usageCount = "";
                usageCount = this.d_product.isRoaming() ? Intl.intl("Roaming") : (maxcount == 0 ? Intl.intl("Unlimited") : String.format(Intl.intl("%1$d of %2$d"), psProd.getCurrentInUse(), maxcount));
                desc = desc + String.format(Intl.intl("Usage: %1$s, %2$s\n"), type, usageCount);
                int days = this.d_product.daysToExpiration();
                String daysText = days == 0 ? Intl.intl("Unlimited") : Integer.toString(days);
                desc = desc + String.format(Intl.intl("Days Remaining: %s\n"), daysText);
                desc = desc + this.getAdditionalDesc();
                System.out.println("ROAM: " + this.d_product.isRoaming());
            }
            catch (NoAvailableProductsException e) {
                desc = Intl.intl("Unable to communicate with license server.");
            }
        }
        return desc;
    }

    protected String getAdditionalDesc() {
        return "";
    }

    public String getLastError() {
        return this.d_lastError;
    }

    private synchronized void checkin() {
        if (this.d_product != null) {
            this.d_product.checkin();
            this.d_product = null;
        }
        Set<String> options = this.d_options.keySet();
        for (String opt : options) {
            this.d_options.get(opt).checkin();
            this.d_options.remove(opt);
        }
    }

    public synchronized void closeLM() {
        if (this.d_timer != null) {
            this.d_timer.cancel();
        }
        this.checkin();
        if (this.d_rlm != null) {
            this.d_rlm.close();
            this.d_rlm = null;
        }
    }

    public boolean isOptionAvailable(String option) {
        if (this.d_rlm == null || !this.isAuthorized()) {
            return false;
        }
        if (this.d_options.get(option) == null) {
            try {
                this.d_options.put(option, new RlmLicense(this.d_rlm, option, this.d_lmVersion, 1));
                int status = this.d_options.get(option).status();
                if (status != 0) {
                    return false;
                }
            }
            catch (RlmException e) {
                System.out.println("RLM License Exception...");
                System.out.println(e.getMessage());
                return false;
            }
        }
        return this.d_options.get(option).goodOnce();
    }

    public class NoAvailableProductsException
    extends Exception {
        private static final long serialVersionUID = 1205309955521637375L;
    }
}

