/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.license;

import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.AbstractCommand;
import pyrosim.legacy_2012_1.thunderheadeng.gui.CmdButton;
import pyrosim.legacy_2012_1.thunderheadeng.gui.MultiLineLabel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiDialog;
import pyrosim.legacy_2012_1.thunderheadeng.license.LicenseManager;
import pyrosim.legacy_2012_1.thunderheadeng.license.RegisterDlg;

public class AuthFailedDlg
extends guiDialog {
    private static final long serialVersionUID = -6547469819430291668L;
    public static final int QUIT = 10;
    private LicenseManager d_ck;
    private CmdButton d_registerBtn;
    private CmdButton d_quitBtn;
    private int d_status;

    public AuthFailedDlg(JFrame parent, LicenseManager mgr) {
        super((Window)parent, "Access Denied");
        this.d_ck = mgr;
        this.d_status = 10;
        this.setHelpIDString("site_key");
        this.d_registerBtn = new CmdButton(new RegisterCmd());
        this.d_quitBtn = new CmdButton(new QuitCmd());
        JComponent[] btns = new JComponent[]{this.d_registerBtn, new CmdButton(new DetailsCmd()), this.d_quitBtn};
        this.setButtons(btns);
        MultiLineLabel l = new MultiLineLabel("To continue using PetraSim you must register your Site Code with Thunderhead.  Click 'Register' to register now.");
        l.setPreferredSize(new Dimension(200, 50));
        this.getDialogPane().add(l);
    }

    @Override
    public int doModal() {
        super.doModal();
        return this.d_status;
    }

    class QuitCmd
    extends AbstractCommand {
        public QuitCmd() {
            super("Quit", "");
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void execute() {
            AuthFailedDlg.this.d_status = 10;
            AuthFailedDlg.this.setVisible(false);
        }
    }

    class DetailsCmd
    extends AbstractCommand {
        public DetailsCmd() {
            super("Details", "");
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void execute() {
            int err = AuthFailedDlg.this.d_ck.getAuthorization(0);
            int trialErr = 0;
            if (err != 0) {
                trialErr = AuthFailedDlg.this.d_ck.readyToTryDays(-125829120, (short)5, (short)2, (short)1);
            }
            int version = AuthFailedDlg.this.d_ck.getVersion();
            int level = AuthFailedDlg.this.d_ck.getLevel();
            String authMsg = "Unknown Software Licensing Error.";
            if (trialErr == 0 && version <= 1 && version >= 0 && (level == 0 || level == 3)) {
                authMsg = AuthFailedDlg.this.d_ck.getLicenseDesc();
            } else if (err != 0) {
                String errMsg = AuthFailedDlg.this.d_ck.explainErr(1, err);
                String trialMsg = AuthFailedDlg.this.d_ck.explainErr(9, trialErr);
                authMsg = "Software Licensing Error (" + err + ").\n" + errMsg + "\n\nCouldn't establish trial license (" + trialErr + ")\n" + trialMsg;
            } else if (level == 1 || level == 2) {
                authMsg = "Software Licensing Error.\n\nThis license is for an Educational or Research version of PetraSim.\nPlease install the correct version and run again.";
            } else if (version > 1) {
                authMsg = "Software Licensing Error.\n\nThis license is for a newer version of PetraSim.\nPlease install the latest version and run again.";
            } else if (version < 0) {
                authMsg = "Software Licensing Error.\n\nThis license is for an older version of PetraSim. Please contact\nThunderhead Engineering for a new Site Key and run again.";
            }
            JOptionPane.showMessageDialog(null, authMsg, "License Details", 1);
        }
    }

    class RegisterCmd
    extends AbstractCommand {
        public RegisterCmd() {
            super(Intl.intl("Register"), "");
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void execute() {
            RegisterDlg dlg = new RegisterDlg(AuthFailedDlg.this.d_ck);
            int res = dlg.doModal();
            if (res == 1) {
                AuthFailedDlg.this.d_status = 1;
                AuthFailedDlg.this.setVisible(false);
            }
        }
    }
}

