/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.ImageIO;
import pyrosim.legacy_2012_1.ILegacy_2012_1;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.util.ImageInfo;
import thunderheadeng.image.IImage;
import thunderheadeng.image.ImageManager;
import thunderheadeng.io.FileSystem;
import thunderheadeng.io.IFileSystem;
import thunderheadeng.io.streamsrc.ByteBufferStreamSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;

public class Image
implements Serializable,
ILegacy_2012_1 {
    static final long serialVersionUID = 1L;
    private static final Integer CURR_VERSION = 2;
    private Integer d_version = CURR_VERSION;
    private transient ByteBuffer d_buffer;
    private int d_width;
    private int d_height;
    private String d_filename;

    protected Image(String filename, ByteBuffer buffer, int width, int height) {
        this.d_buffer = buffer;
        this.d_width = width;
        this.d_height = height;
        this.d_filename = filename;
    }

    @Override
    public thunderheadeng.image.Image fromLegacy(LegacyDictionary_2012_1 dict) {
        IImage result;
        IStreamSrc src;
        IImage fileImage = null;
        if (this.d_filename != null && new File(this.d_filename).exists()) {
            IFileSystem fs = FileSystem.INSTANCE;
            IStreamSrc src2 = fs.getStreamSrc(this.d_filename, 3);
            fileImage = thunderheadeng.image.Image.loadUnchecked(this.d_filename, src2);
        }
        if (this.isCached()) {
            ByteBuffer buffer = this.getBuffer();
            src = new ByteBufferStreamSrc(buffer);
            result = thunderheadeng.image.Image.loadUnchecked(this.d_filename, src);
        } else {
            result = fileImage;
        }
        if (fileImage != null && (result == fileImage || result.makeHashable().equals(fileImage))) {
            ImageManager.registerImage(this.d_filename, (thunderheadeng.image.Image)result);
        }
        if (result == null) {
            String fn = this.d_filename == null ? "" : this.d_filename;
            src = FileSystem.INSTANCE.getStreamSrc(fn, 3);
            result = thunderheadeng.image.Image.loadUnchecked(fn, src);
        }
        return result;
    }

    public boolean pseudoEquals(Image i2) {
        if (this.getFileSize() != i2.getFileSize()) {
            return false;
        }
        return this.getFileSize() == i2.getFileSize() && this.getWidth() == i2.getWidth() && this.getHeight() == i2.getHeight();
    }

    public int pseudoHashCode() {
        return (int)this.getFileSize() + this.getWidth() + this.getHeight();
    }

    private long getFileSize() {
        if (this.isCached()) {
            return this.getBuffer().limit();
        }
        File file = new File(this.getFilename());
        return file.length();
    }

    public boolean isCached() {
        return this.d_buffer != null;
    }

    public boolean isValid() {
        return this.isCached() || new File(this.d_filename).exists();
    }

    public Image toCachedImage() {
        if (this.isCached()) {
            return this;
        }
        return Image.load(this.d_filename);
    }

    public BufferedImage toBufferedImage() {
        try {
            if (!this.isCached()) {
                return ImageIO.read(new File(this.d_filename));
            }
            return ImageIO.read(new ByteBufferInputStream(this.d_buffer));
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean save(String name) {
        Image timg;
        ByteBuffer buffer = this.d_buffer;
        if (buffer == null && (timg = Image.load(this.d_filename)) != null) {
            buffer = timg.d_buffer;
        }
        if (buffer != null) {
            byte[] fullBuffer = new byte[buffer.limit()];
            buffer.get(fullBuffer, 0, buffer.limit());
            buffer.position(0);
            try {
                FileOutputStream os = new FileOutputStream(name);
                os.write(fullBuffer);
                os.close();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public String getFilename() {
        return this.d_filename;
    }

    public int getHeight() {
        return this.d_height;
    }

    public int getWidth() {
        return this.d_width;
    }

    public ByteBuffer getBuffer() {
        if (this.d_buffer == null) {
            return null;
        }
        return this.d_buffer.duplicate();
    }

    public static Image loadUncached(String filename) {
        int[] ii = Image.retrieveImageInfo(filename, null);
        return new Image(filename, null, ii[0], ii[1]);
    }

    public static Image load(String filename) {
        FileInputStream stream;
        try {
            stream = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        Image result = Image.loadFromStream(filename, stream);
        try {
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Image load(String filename, BufferedImage img) {
        return Image.loadFromImage(filename, img);
    }

    public static Image load(String filename, InputStream stream) {
        return Image.loadFromStream(filename, stream);
    }

    public static Image load(String filename, byte[] data) {
        return Image.loadFromBuffer(filename, data, 0, data.length);
    }

    public static Image load(String filename, byte[] data, int width, int height, int pitch, int ro, int bo, int go) {
        return Image.loadFromLegacy(filename, data, width, height, pitch, ro, go, bo);
    }

    public static Image legacySetName(String filename, Image img) {
        return new Image(filename, img.d_buffer, img.d_width, img.d_height);
    }

    private static Image loadFromImage(String filename, BufferedImage img) {
        CustomByteArrayOutputStream baos = new CustomByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "PNG", baos);
        }
        catch (IOException e) {
            return null;
        }
        return Image.loadFromBuffer(filename, baos.getBuffer(), 0, baos.size());
    }

    private static Image loadFromStream(String filename, InputStream stream) {
        try {
            if (stream instanceof FileInputStream) {
                return Image.loadFromFile(filename, (FileInputStream)stream);
            }
            return Image.loadFromUnknown(filename, stream);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static Image loadFromFile(String filename, FileInputStream fis) throws IOException {
        long fileSize = fis.getChannel().size();
        if (fileSize > Integer.MAX_VALUE) {
            return null;
        }
        return Image.loadFromStream(filename, fis, (int)fileSize);
    }

    private static Image loadFromStream(String filename, InputStream stream, int totalSize) throws IOException {
        ByteBuffer bbuffer = Image.allocate(totalSize);
        if (bbuffer == null) {
            return null;
        }
        byte[] buffer = new byte[8192];
        while (bbuffer.hasRemaining()) {
            int toRead = Math.min(bbuffer.remaining(), buffer.length);
            int numRead = stream.read(buffer, 0, toRead);
            if (numRead == -1) {
                return null;
            }
            bbuffer.put(buffer, 0, numRead);
        }
        bbuffer.position(0);
        int[] ii = Image.retrieveImageInfo(filename, bbuffer);
        return new Image(filename, bbuffer, ii[0], ii[1]);
    }

    private static Image loadFromUnknown(String filename, InputStream stream) throws IOException {
        try (CustomByteArrayOutputStream baos = new CustomByteArrayOutputStream();){
            int read;
            byte[] buffer = new byte[8192];
            while (stream.available() > 0 && (read = stream.read(buffer)) != -1) {
                baos.write(buffer, 0, read);
            }
            Image image = Image.loadFromBuffer(filename, baos.getBuffer(), 0, baos.size());
            return image;
        }
    }

    private static Image loadFromLegacy(String filename, byte[] data, int width, int height, int pitch, int ro, int go, int bo) {
        assert (data.length >= pitch * height);
        BufferedImage bi = new BufferedImage(width, height, 5);
        int boffset = 0;
        for (int r = 0; r < height; ++r) {
            int y = height - r - 1;
            for (int x = 0; x < width; ++x) {
                int coffset = boffset + x * 3;
                int red = data[coffset + ro] & 0xFF;
                int green = data[coffset + go] & 0xFF;
                int blue = data[coffset + bo] & 0xFF;
                int color = 0xFF000000 | red << 16 | green << 8 | blue << 0;
                bi.setRGB(x, y, color);
            }
            boffset += pitch;
        }
        return Image.loadFromImage(filename, bi);
    }

    private static Image loadFromBuffer(String filename, byte[] data, int offset, int numBytes) {
        ByteBuffer bbuffer = Image.allocate(data.length);
        if (bbuffer == null) {
            return null;
        }
        bbuffer.put(data, offset, numBytes);
        bbuffer.position(0);
        int[] ii = Image.retrieveImageInfo(filename, bbuffer);
        return new Image(filename, bbuffer, ii[0], ii[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] retrieveImageInfo(String filename, ByteBuffer buffer) {
        InputStream is = null;
        if (buffer != null) {
            is = new ByteBufferInputStream(buffer);
        } else if (filename != null) {
            try {
                is = new FileInputStream(filename);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (is == null) {
            return new int[]{0, 0};
        }
        try {
            ImageInfo ii = new ImageInfo();
            ii.setInput(is);
            if (!ii.check()) {
                int[] nArray = new int[]{0, 0};
                return nArray;
            }
            int[] nArray = new int[]{ii.getWidth(), ii.getHeight()};
            return nArray;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.d_buffer == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            if (this.d_buffer.hasArray()) {
                byte[] buffer = this.d_buffer.array();
                out.writeInt(buffer.length);
                out.write(buffer, 0, buffer.length);
            } else {
                out.writeInt(this.d_buffer.limit());
                byte[] buffer = new byte[8192];
                while (this.d_buffer.hasRemaining()) {
                    int toRead = Math.min(this.d_buffer.remaining(), buffer.length);
                    this.d_buffer.get(buffer, 0, toRead);
                    out.write(buffer, 0, toRead);
                }
                this.d_buffer.position(0);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        boolean bufferSpecified = in.readBoolean();
        if (!bufferSpecified) {
            this.d_buffer = null;
        } else {
            Image timage;
            int length = in.readInt();
            if (this.d_version == null) {
                this.d_version = CURR_VERSION;
                byte[] buffer = new byte[length];
                in.readFully(buffer);
                int ro = 2;
                int go = 1;
                int bo = 0;
                int byteWidth = this.d_width * 3;
                int pitch = byteWidth % 4 == 0 ? byteWidth : (byteWidth >> 2) + 1 << 2;
                timage = Image.loadFromLegacy(this.d_filename, buffer, this.d_width, this.d_height, pitch, ro, go, bo);
            } else {
                timage = Image.loadFromStream(this.d_filename, in, length);
            }
            this.d_filename = timage.d_filename;
            this.d_width = timage.d_width;
            this.d_height = timage.d_height;
            this.d_buffer = timage.d_buffer;
        }
    }

    public static ByteBuffer allocate(int numBytes) {
        if (numBytes == 0) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(numBytes);
        buffer.order(ByteOrder.nativeOrder());
        return buffer;
    }

    private static class ByteBufferInputStream
    extends InputStream {
        private final ByteBuffer d_buffer;

        public ByteBufferInputStream(ByteBuffer buffer) {
            this.d_buffer = buffer.duplicate();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.d_buffer.mark();
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.d_buffer.reset();
        }

        @Override
        public int available() throws IOException {
            return this.d_buffer.remaining();
        }

        @Override
        public int read() throws IOException {
            if (this.d_buffer.remaining() == 0) {
                return -1;
            }
            return this.d_buffer.get();
        }

        @Override
        public int read(byte[] b) throws IOException {
            int remaining = this.d_buffer.remaining();
            if (remaining == 0) {
                return -1;
            }
            int toRead = Math.min(remaining, b.length);
            this.d_buffer.get(b, 0, toRead);
            return toRead;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int remaining = this.d_buffer.remaining();
            if (remaining == 0) {
                return -1;
            }
            int toRead = Math.min(remaining, len);
            this.d_buffer.get(b, off, toRead);
            return toRead;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n < 0L) {
                return 0L;
            }
            int remaining = this.d_buffer.remaining();
            int toSkip = Math.min(remaining, (int)Math.min(Integer.MAX_VALUE, n));
            this.d_buffer.position(this.d_buffer.position() + toSkip);
            return toSkip;
        }
    }

    private static class CustomByteArrayOutputStream
    extends ByteArrayOutputStream {
        private CustomByteArrayOutputStream() {
        }

        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

