/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.AModelObj;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Edge;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Face;

public class Vertex
extends AModelObj {
    static final long serialVersionUID = 1L;
    public Point3d loc;
    public transient List<Edge> edges = new ArrayList<Edge>(2);
    public transient Face face = null;

    public Vertex(Point3d loc) {
        this.loc = loc;
    }

    @Override
    public AABox getBounds() {
        return new AABox(this.loc);
    }

    public String toString() {
        return String.format("[Vertex] %s", this.loc.toString());
    }

    @Override
    public Object clone() {
        Vertex clone = (Vertex)super.clone();
        clone.edges = new ArrayList<Edge>(this.edges.size());
        clone.face = null;
        return clone;
    }

    public boolean isConnected() {
        return this.face != null || !this.edges.isEmpty();
    }

    public void addEdge(Edge edge) {
        if (!this.edges.contains(edge)) {
            this.edges.add(edge);
        }
    }

    @Override
    public void writeTopology(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.edges);
        stream.writeObject(this.face);
    }

    @Override
    public void readTopology(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.edges = (List)stream.readObject();
        this.face = (Face)stream.readObject();
    }
}

