/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.BoundingSphere;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class ConvexHull
implements ITest<AABox> {
    public static final ConvexHull ACCEPT_NONE = new ConvexHull(new Plane3d(0.0, 0.0, -1.0, Double.MAX_VALUE));
    private final Plane3d[] d_planes;
    private final Tuple3d[][] d_planeEdges;

    public ConvexHull(Plane3d ... planes) {
        this(Arrays.asList(planes));
    }

    public ConvexHull(Collection<? extends Plane3d> planes) {
        this.d_planes = planes.toArray(new Plane3d[planes.size()]);
        ArrayList<Tuple3d[]> edges = new ArrayList<Tuple3d[]>();
        for (int m = 0; m < this.d_planes.length; ++m) {
            Plane3d plane1 = this.d_planes[m];
            for (int n = 1; n < this.d_planes.length; ++n) {
                Plane3d plane2 = this.d_planes[n];
                Tuple3d[] isect = Inter3D.planePlaneIsect(plane1, plane2, 1.0E-9);
                if (isect == null) continue;
                edges.add(isect);
            }
        }
        this.d_planeEdges = (Tuple3d[][])edges.toArray((T[])new Tuple3d[edges.size()][]);
    }

    public Plane3d[] getPlanes() {
        return this.d_planes;
    }

    public int contains(Point3d ... points) {
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.Containment.convert(this.test(points));
    }

    @Override
    public Containment test(Point3d ... points) {
        int totalIn = 0;
        for (Point3d p : points) {
            if (!this.contains(p)) continue;
            ++totalIn;
        }
        if (totalIn == 0) {
            return Containment.OUTSIDE;
        }
        if (totalIn == points.length) {
            return Containment.INSIDE;
        }
        return Containment.INTERSECTS;
    }

    public boolean containsAtLeastPart(Point3d ... points) {
        return this.test(points) != Containment.OUTSIDE;
    }

    public boolean contains(Point3d p) {
        for (int m = 0; m < this.d_planes.length; ++m) {
            double dot = this.d_planes[m].dot(p);
            if (!(dot >= 0.0)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Point3d p, double tol) {
        for (int m = 0; m < this.d_planes.length; ++m) {
            double dot = this.d_planes[m].dot(p);
            if (!theUtil.gt0(dot, tol)) continue;
            return false;
        }
        return true;
    }

    public int contains(AABox bb) {
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.Containment.convert(this.test(bb));
    }

    @Override
    public Containment test(AABox bb) {
        return this.test(bb, 0.0);
    }

    public Containment test(AABox bb, double tol) {
        if (bb.getMin().epsilonEquals(bb.getMax(), tol)) {
            return this.contains(bb.getMin(), tol) ? Containment.INSIDE : Containment.OUTSIDE;
        }
        Point3d min = bb.getMin();
        Point3d max = bb.getMax();
        int totalIn = 0;
        for (int m = 0; m < this.d_planes.length; ++m) {
            int inCount = 8;
            int ptIn = 1;
            Plane3d plane = this.d_planes[m];
            if (theUtil.gt0(plane.dot(min.x, min.y, min.z), 1.0E-9)) {
                ptIn = 0;
                --inCount;
            }
            if (theUtil.gt0(plane.dot(min.x, min.y, max.z), 1.0E-9)) {
                ptIn = 0;
                --inCount;
            }
            if (theUtil.gt0(plane.dot(min.x, max.y, min.z), 1.0E-9)) {
                ptIn = 0;
                --inCount;
            }
            if (theUtil.gt0(plane.dot(min.x, max.y, max.z), 1.0E-9)) {
                ptIn = 0;
                --inCount;
            }
            if (theUtil.gt0(plane.dot(max.x, min.y, min.z), 1.0E-9)) {
                ptIn = 0;
                --inCount;
            }
            if (theUtil.gt0(plane.dot(max.x, min.y, max.z), 1.0E-9)) {
                ptIn = 0;
                --inCount;
            }
            if (theUtil.gt0(plane.dot(max.x, max.y, min.z), 1.0E-9)) {
                ptIn = 0;
                --inCount;
            }
            if (theUtil.gt0(plane.dot(max.x, max.y, max.z), 1.0E-9)) {
                ptIn = 0;
                --inCount;
            }
            if (inCount == 0) {
                return Containment.OUTSIDE;
            }
            totalIn += ptIn;
        }
        return totalIn == this.d_planes.length ? Containment.INSIDE : Containment.INTERSECTS;
    }

    public boolean containsAtLeastPart(AABox bb) {
        return this.test((AABox)bb).positive;
    }

    public int contains(BoundingSphere bs) {
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.Containment.convert(this.test(bs));
    }

    @Override
    public Containment test(BoundingSphere bs) {
        int partialIn = 0;
        for (int m = 0; m < this.d_planes.length; ++m) {
            Plane3d plane = this.d_planes[m];
            double dist = plane.dot(bs.center);
            if (dist < bs.radius) {
                ++partialIn;
                continue;
            }
            if (!(dist >= 0.0)) continue;
            return Containment.OUTSIDE;
        }
        return partialIn == 0 ? Containment.INSIDE : Containment.INTERSECTS;
    }

    public boolean containsAtLeastPart(BoundingSphere bs) {
        return this.test((BoundingSphere)bs).positive;
    }

    public ConvexHull transform(Matrix4d mat) {
        Plane3d[] newPlanes = new Plane3d[this.d_planes.length];
        for (int m = 0; m < this.d_planes.length; ++m) {
            Plane3d plane = this.d_planes[m];
            newPlanes[m] = plane.transformBy(mat);
        }
        return new ConvexHull(newPlanes);
    }

    public ConvexHull intersect(ConvexHull ch, boolean optimize) {
        if (ch.acceptsAll() || this.acceptsNone()) {
            return this;
        }
        if (this.acceptsAll() || ch.acceptsNone()) {
            return ch;
        }
        ArrayList<Plane3d> planes = new ArrayList<Plane3d>(this.d_planes.length + ch.d_planes.length);
        for (Plane3d plane : this.d_planes) {
            if (planes.contains(plane)) continue;
            planes.add(plane);
        }
        for (Plane3d plane : ch.d_planes) {
            if (planes.contains(plane)) continue;
            planes.add(plane);
        }
        ConvexHull result = new ConvexHull(planes.toArray(new Plane3d[planes.size()]));
        if (optimize) {
            result = result.optimize();
        }
        return result;
    }

    public boolean acceptsAll() {
        return this.d_planes.length == 0;
    }

    public boolean acceptsNone() {
        return this == ACCEPT_NONE || this.d_planes.length == 1 && this.d_planes[0].equals(ConvexHull.ACCEPT_NONE.d_planes[0]);
    }

    public ConvexHull mergeIfTouching(ConvexHull ch) {
        int cancelCount1 = 0;
        int cancelCount2 = 0;
        ArrayList<Plane3d> keepPlanes = new ArrayList<Plane3d>();
        for (Plane3d plane1 : this.d_planes) {
            if (!ConvexHull.isPlaneRedundant(ch.d_planes, plane1) && !keepPlanes.contains(plane1)) {
                keepPlanes.add(plane1);
                continue;
            }
            ++cancelCount1;
        }
        for (Plane3d plane2 : ch.d_planes) {
            if (!ConvexHull.isPlaneRedundant(this.d_planes, plane2) && !keepPlanes.contains(plane2)) {
                keepPlanes.add(plane2);
                continue;
            }
            ++cancelCount2;
        }
        if (cancelCount1 == 0 && cancelCount2 == 0) {
            return null;
        }
        return new ConvexHull(keepPlanes).optimize();
    }

    public ConvexHull optimize() {
        ArrayList<Plane3d> newPlanes = new ArrayList<Plane3d>(Arrays.asList(this.d_planes));
        List<List<Plane3d>> parSets = ConvexHull.getParallelSets(this.d_planes);
        for (List<Plane3d> list : parSets) {
            ArrayList<Plane3d> invalidPlanes = new ArrayList<Plane3d>();
            for (Plane3d plane : list) {
                if (ConvexHull.isValidPlane(list, plane)) continue;
                invalidPlanes.add(plane);
            }
            if (invalidPlanes.size() == list.size()) {
                return ACCEPT_NONE;
            }
            for (Plane3d invalidPlane : invalidPlanes) {
                newPlanes.remove(invalidPlane);
            }
        }
        if (ConvexHull.areAllParallel(newPlanes)) {
            return new ConvexHull(newPlanes);
        }
        ArrayList<Plane3d> tempList = new ArrayList<Plane3d>();
        block3: for (Plane3d plane1 : newPlanes) {
            for (Plane3d plane2 : newPlanes) {
                boolean isPart;
                if (plane1 == plane2 || !(isPart = ConvexHull.partOfMinHullOutline(newPlanes, plane1, plane2))) continue;
                tempList.add(plane1);
                continue block3;
            }
        }
        newPlanes = tempList;
        if (newPlanes.isEmpty()) {
            return ACCEPT_NONE;
        }
        return new ConvexHull(newPlanes.toArray(new Plane3d[newPlanes.size()]));
    }

    private static boolean partOfMinHullOutline(List<Plane3d> planes, Plane3d plane1, Plane3d plane2) {
        Tuple3d[] lineIsect = Inter3D.planePlaneIsect(plane1, plane2, 1.0E-9);
        if (lineIsect == null) {
            return false;
        }
        double[] clipped = ConvexHull.clipToMinHull(planes, (Point3d)lineIsect[0], (Vector3d)lineIsect[1], plane1, plane2);
        return clipped != null;
    }

    private static double[] clipToMinHull(List<Plane3d> planes, Point3d l1, Vector3d ldir, Plane3d plane1, Plane3d plane2) {
        double t1 = -1.7976931348623157E308;
        double t2 = Double.MAX_VALUE;
        for (Plane3d plane3 : planes) {
            Point3d p;
            if (plane3 == plane1 || plane3 == plane2) continue;
            double isect = Inter3D.linePlaneIntersectionT(l1, ldir, plane3, 1.0E-9);
            if (Double.isNaN(isect)) {
                if (!(plane3.dot(l1) > 0.0)) continue;
                return null;
            }
            if (isect <= t1) {
                p = Util3D.linePoint(l1, ldir, t1);
                if (!(plane3.dot(p) > 0.0)) continue;
                return null;
            }
            if (isect >= t2) {
                p = Util3D.linePoint(l1, ldir, t2);
                if (!(plane3.dot(p) > 0.0)) continue;
                return null;
            }
            if (ldir.dot(plane3.getNormal()) >= 0.0) {
                t2 = isect;
            } else {
                t1 = isect;
            }
            if (!(t1 >= t2)) continue;
            return null;
        }
        return new double[]{t1, t2};
    }

    private static boolean areAllParallel(List<Plane3d> list) {
        if (list.isEmpty()) {
            return true;
        }
        Plane3d first = list.get(0);
        for (int m = 1; m < list.size(); ++m) {
            if (first.isParallel(list.get(m), 1.0E-9)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidPlane(List<Plane3d> list, Plane3d plane) {
        for (Plane3d plane2 : list) {
            double dot;
            if (plane2.equals(plane) || !plane2.isParallel(plane, 1.0E-9) || !theUtil.ge0(dot = ConvexHull.parallelPlaneDot(plane2, plane), 1.0E-9)) continue;
            return false;
        }
        return true;
    }

    private static List<List<Plane3d>> getParallelSets(Plane3d[] list) {
        ArrayList<List<Plane3d>> sets = new ArrayList<List<Plane3d>>();
        for (Plane3d plane : list) {
            List<Plane3d> parset = null;
            for (List list2 : sets) {
                if (!((Plane3d)list2.get(0)).isParallel(plane, 1.0E-9)) continue;
                parset = list2;
                break;
            }
            if (parset == null) {
                parset = new ArrayList<Plane3d>();
                sets.add(parset);
            }
            parset.add(plane);
        }
        return sets;
    }

    private static boolean isPlaneRedundant(Plane3d[] list, Plane3d plane) {
        int parCount = 0;
        for (Plane3d plane2 : list) {
            boolean par = plane.isParallel(plane2, 1.0E-9);
            if (!par) continue;
            ++parCount;
            double dot = ConvexHull.parallelPlaneDot(plane2, plane);
            if (!theUtil.gt(dot, 0.0, 1.0E-9)) continue;
            return false;
        }
        return parCount > 0;
    }

    private static double parallelPlaneDot(Plane3d plane1, Plane3d plane2) {
        Point3d testPoint = plane2.getPointOnPlane();
        return plane1.dot(testPoint);
    }

    public boolean intersectsLineSeg(Point3d p1, Point3d p2, double tol) {
        if (this.contains(p1, tol) || this.contains(p2, tol)) {
            return true;
        }
        Vector3d ldir = Util3D.vector(p1, p2);
        for (Plane3d plane : this.d_planes) {
            double t = Inter3D.linePlaneIntersectionT(p1, ldir, plane, 1.0E-9);
            if (Double.isNaN(t) || !theUtil.ge0(t, tol) || !theUtil.le(t, 1.0, tol) || !this.contains(Util3D.linePoint(p1, ldir, t), tol)) continue;
            return true;
        }
        return false;
    }

    public boolean intersectsConvexPoly(double tol, Point3d ... poly) {
        Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(poly));
        if (plane == null) {
            return false;
        }
        return this.intersectsConvexPoly(tol, plane, poly);
    }

    public boolean intersectsConvexPoly(double tol, Plane3d polyPlane, Point3d ... poly) {
        for (Point3d point3d : poly) {
            if (!this.contains(point3d, tol)) continue;
            return true;
        }
        for (int m = 0; m < poly.length; ++m) {
            Point3d p1 = poly[m];
            Point3d p2 = poly[(m + 1) % poly.length];
            for (Plane3d plane : this.d_planes) {
                Point3d isect = Inter3D.lineSegPlaneIntersection(p1, p2, plane, tol);
                if (isect == null || !this.contains(isect, tol)) continue;
                return true;
            }
        }
        for (Tuple3d[] tuple3dArray : this.d_planeEdges) {
            Point3d p = (Point3d)tuple3dArray[0];
            Vector3d v = (Vector3d)tuple3dArray[1];
            Point3d isect = Inter3D.linePolyIntersection(p, v, polyPlane, tol, poly);
            if (isect == null || !this.contains(isect, tol)) continue;
            return true;
        }
        return false;
    }
}

