/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABoxf;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ISearchVol;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class AABox
implements Serializable,
Cloneable,
ISearchVol,
ITest<AABox> {
    static final long serialVersionUID = 1L;
    public static final double VOL_EPS = 2.220446049250313E-16;
    private double d_minx;
    private double d_miny;
    private double d_minz;
    private double d_maxx;
    private double d_maxy;
    private double d_maxz;

    public AABox() {
        this(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
    }

    public AABox(AABox box) {
        this(box.d_minx, box.d_miny, box.d_minz, box.d_maxx, box.d_maxy, box.d_maxz);
    }

    public AABox(Point3d min, Point3d max) {
        this.set(min, max);
    }

    public AABox(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        this.d_minx = minx;
        this.d_miny = miny;
        this.d_minz = minz;
        this.d_maxx = maxx;
        this.d_maxy = maxy;
        this.d_maxz = maxz;
    }

    public AABox(Point3d ... points) {
        this();
        this.add(points);
    }

    public double getWidth() {
        return this.d_maxx - this.d_minx;
    }

    public double getDepth() {
        return this.d_maxy - this.d_miny;
    }

    public double getHeight() {
        return this.d_maxz - this.d_minz;
    }

    public static AABox infinite() {
        return new AABox(new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY), new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.d_minx) || Double.isInfinite(this.d_miny) || Double.isInfinite(this.d_minz) || Double.isInfinite(this.d_maxx) || Double.isInfinite(this.d_maxy) || Double.isInfinite(this.d_maxz);
    }

    public void reset() {
        this.d_minz = Double.MAX_VALUE;
        this.d_miny = Double.MAX_VALUE;
        this.d_minx = Double.MAX_VALUE;
        this.d_maxz = -1.7976931348623157E308;
        this.d_maxy = -1.7976931348623157E308;
        this.d_maxx = -1.7976931348623157E308;
    }

    @Override
    public boolean isValid() {
        return this.d_minx <= this.d_maxx && this.d_miny <= this.d_maxy && this.d_minz <= this.d_maxz;
    }

    public void set(Point3d min, Point3d max) {
        this.d_minx = min.x;
        this.d_miny = min.y;
        this.d_minz = min.z;
        this.d_maxx = max.x;
        this.d_maxy = max.y;
        this.d_maxz = max.z;
    }

    public void set(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        this.d_minx = minx;
        this.d_miny = miny;
        this.d_minz = minz;
        this.d_maxx = maxx;
        this.d_maxy = maxy;
        this.d_maxz = maxz;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AABox{");
        sb.append(this.getMin().toString() + " --> ");
        sb.append(this.getMax().toString() + "}");
        return sb.toString();
    }

    public Point3d getCenter() {
        return new Point3d((this.d_minx + this.d_maxx) * 0.5, (this.d_miny + this.d_maxy) * 0.5, (this.d_minz + this.d_maxz) * 0.5);
    }

    public Point3d getMin() {
        return new Point3d(this.d_minx, this.d_miny, this.d_minz);
    }

    public Point3d getMax() {
        return new Point3d(this.d_maxx, this.d_maxy, this.d_maxz);
    }

    public Point3d[] getVerts() {
        Point3d[] verts = new Point3d[]{this.mmm(), this.mmM(), this.mMm(), this.mMM(), this.Mmm(), this.MmM(), this.MMm(), this.MMM()};
        return verts;
    }

    public double getMinX() {
        return this.d_minx;
    }

    public double getMinY() {
        return this.d_miny;
    }

    public double getMinZ() {
        return this.d_minz;
    }

    public double getMaxX() {
        return this.d_maxx;
    }

    public double getMaxY() {
        return this.d_maxy;
    }

    public double getMaxZ() {
        return this.d_maxz;
    }

    @Override
    public void add(ISearchVol vol) {
        if (vol instanceof AABox) {
            this.add((AABox)vol);
        }
    }

    public void add(AABox box) {
        if (box.d_minx < this.d_minx) {
            this.d_minx = box.d_minx;
        }
        if (box.d_maxx > this.d_maxx) {
            this.d_maxx = box.d_maxx;
        }
        if (box.d_miny < this.d_miny) {
            this.d_miny = box.d_miny;
        }
        if (box.d_maxy > this.d_maxy) {
            this.d_maxy = box.d_maxy;
        }
        if (box.d_minz < this.d_minz) {
            this.d_minz = box.d_minz;
        }
        if (box.d_maxz > this.d_maxz) {
            this.d_maxz = box.d_maxz;
        }
    }

    public void add(Point3d ... points) {
        for (Point3d p : points) {
            this.add(p);
        }
    }

    public void add(Point3d p) {
        this.addPoint(p.x, p.y, p.z);
    }

    public void addPoint(double x, double y, double z) {
        if (x < this.d_minx) {
            this.d_minx = x;
        }
        if (x > this.d_maxx) {
            this.d_maxx = x;
        }
        if (y < this.d_miny) {
            this.d_miny = y;
        }
        if (y > this.d_maxy) {
            this.d_maxy = y;
        }
        if (z < this.d_minz) {
            this.d_minz = z;
        }
        if (z > this.d_maxz) {
            this.d_maxz = z;
        }
    }

    public double volume() {
        return (this.d_maxx - this.d_minx) * (this.d_maxy - this.d_miny) * (this.d_maxz - this.d_minz);
    }

    public double volume(double epsilon) {
        double dx = this.d_maxx - this.d_minx + epsilon;
        double dy = this.d_maxy - this.d_miny + epsilon;
        double dz = this.d_maxz - this.d_minz + epsilon;
        return dx * dy * dz;
    }

    @Override
    public double volumeEps() {
        return this.volume(2.220446049250313E-16);
    }

    public AABox ensureValidSize(double unsetVal, double offsetVal) {
        Point3d min = this.getMin();
        Point3d max = this.getMax();
        if (!this.isValid()) {
            this.set(new Point3d(-unsetVal, -unsetVal, -unsetVal), new Point3d(unsetVal, unsetVal, unsetVal));
            return this;
        }
        if (min.equals(max)) {
            this.set(new Point3d(min.x - unsetVal, min.y - unsetVal, min.z - unsetVal), new Point3d(max.x + unsetVal, max.y + unsetVal, max.z + unsetVal));
            return this;
        }
        if (min.x == max.x) {
            min.x -= offsetVal;
            max.x += offsetVal;
        }
        if (min.y == max.y) {
            min.y -= offsetVal;
            max.y += offsetVal;
        }
        if (min.z == max.z) {
            min.z -= offsetVal;
            max.z += offsetVal;
        }
        this.set(min, max);
        return this;
    }

    public boolean cull(Point3d point) {
        return !(point.x <= this.d_minx || point.x >= this.d_maxx || point.y <= this.d_miny || point.y >= this.d_maxy || point.z <= this.d_minz) && !(point.z >= this.d_maxz);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AABox)) {
            return false;
        }
        AABox box = (AABox)obj;
        return this.d_minx == box.d_minx && this.d_miny == box.d_miny && this.d_minz == box.d_minz && this.d_maxx == box.d_maxx && this.d_maxy == box.d_maxy && this.d_maxz == box.d_maxz;
    }

    public int hashCode() {
        return theUtil.hashCode(this.d_minx + this.d_miny + this.d_minz + this.d_maxx + this.d_maxy + this.d_maxz);
    }

    @Override
    public Object clone() {
        return new AABox(this);
    }

    public boolean contains(Point3d p) {
        return this.d_minx <= p.x && p.x <= this.d_maxx && this.d_miny <= p.y && p.y <= this.d_maxy && this.d_minz <= p.z && p.z <= this.d_maxz;
    }

    public boolean containsOneOf(Point3d ... points) {
        for (Point3d p : points) {
            if (!this.contains(p)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Point3d p, double tolerance) {
        return this.d_minx - tolerance <= p.x && p.x <= this.d_maxx + tolerance && this.d_miny - tolerance <= p.y && p.y <= this.d_maxy + tolerance && this.d_minz - tolerance <= p.z && p.z <= this.d_maxz + tolerance;
    }

    public boolean innerPt(Point3d pt) {
        return this.d_minx < pt.x && pt.x < this.d_maxx && this.d_miny < pt.y && pt.y < this.d_maxy && this.d_minz < pt.z && pt.z < this.d_maxz;
    }

    @Override
    public Containment test(AABox bb) {
        return AABox.contains(this.d_minx, this.d_miny, this.d_minz, this.d_maxx, this.d_maxy, this.d_maxz, bb.d_minx, bb.d_miny, bb.d_minz, bb.d_maxx, bb.d_maxy, bb.d_maxz);
    }

    public Containment test(AABox bb, double tol) {
        return AABox.contains(this.d_minx - tol, this.d_miny - tol, this.d_minz - tol, this.d_maxx + tol, this.d_maxy + tol, this.d_maxz + tol, bb.d_minx - tol, bb.d_miny - tol, bb.d_minz - tol, bb.d_maxx + tol, bb.d_maxy + tol, bb.d_maxz + tol);
    }

    private static final Containment contains(double minx1, double miny1, double minz1, double maxx1, double maxy1, double maxz1, double minx2, double miny2, double minz2, double maxx2, double maxy2, double maxz2) {
        if (minx1 <= maxx2 && minx2 <= maxx1 && miny1 <= maxy2 && miny2 <= maxy1 && minz1 <= maxz2 && minz2 <= maxz1) {
            if (minx1 <= minx2 && maxx2 <= maxx1 && miny1 <= miny2 && maxy2 <= maxy1 && minz1 <= minz2 && maxz2 <= maxz1) {
                return Containment.INSIDE;
            }
            return Containment.INTERSECTS;
        }
        return Containment.OUTSIDE;
    }

    public int contains(AABox bb) {
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.Containment.convert(this.test(bb));
    }

    public int contains(AABox bb, double tol) {
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.Containment.convert(this.test(bb, tol));
    }

    public boolean intersects(AABox bb) {
        Point3d p1Min = this.getMin();
        Point3d p1Max = this.getMax();
        Point3d p2Min = bb.getMin();
        Point3d p2Max = bb.getMax();
        return p1Min.x <= p2Max.x && p1Max.x >= p2Min.x && p1Min.y <= p2Max.y && p1Max.y >= p2Min.y && p1Min.z <= p2Max.z && p1Max.z >= p2Min.z;
    }

    public boolean intersects(AABox bb, double tol) {
        double minx1 = this.d_minx - tol;
        double miny1 = this.d_miny - tol;
        double minz1 = this.d_minz - tol;
        double minx2 = bb.d_minx - tol;
        double miny2 = bb.d_miny - tol;
        double minz2 = bb.d_minz - tol;
        double maxx1 = this.d_maxx + tol;
        double maxy1 = this.d_maxy + tol;
        double maxz1 = this.d_maxz + tol;
        double maxx2 = bb.d_maxx + tol;
        double maxy2 = bb.d_maxy + tol;
        double maxz2 = bb.d_maxz + tol;
        return minx2 <= maxx1 && maxx2 >= minx1 && miny2 <= maxy1 && maxy2 >= miny1 && minz2 <= maxz1 && maxz2 >= minz1;
    }

    public Point3d mmm() {
        return this.getMin();
    }

    public Point3d mmM() {
        return new Point3d(this.d_minx, this.d_miny, this.d_maxz);
    }

    public Point3d mMm() {
        return new Point3d(this.d_minx, this.d_maxy, this.d_minz);
    }

    public Point3d mMM() {
        return new Point3d(this.d_minx, this.d_maxy, this.d_maxz);
    }

    public Point3d Mmm() {
        return new Point3d(this.d_maxx, this.d_miny, this.d_minz);
    }

    public Point3d MmM() {
        return new Point3d(this.d_maxx, this.d_miny, this.d_maxz);
    }

    public Point3d MMm() {
        return new Point3d(this.d_maxx, this.d_maxy, this.d_minz);
    }

    public Point3d MMM() {
        return this.getMax();
    }

    public Point3d mmm(Point3d p) {
        p.set(this.d_minx, this.d_miny, this.d_minz);
        return p;
    }

    public Point3d mmM(Point3d p) {
        p.set(this.d_minx, this.d_miny, this.d_maxz);
        return p;
    }

    public Point3d mMm(Point3d p) {
        p.set(this.d_minx, this.d_maxy, this.d_minz);
        return p;
    }

    public Point3d mMM(Point3d p) {
        p.set(this.d_minx, this.d_maxy, this.d_maxz);
        return p;
    }

    public Point3d Mmm(Point3d p) {
        p.set(this.d_maxx, this.d_miny, this.d_minz);
        return p;
    }

    public Point3d MmM(Point3d p) {
        p.set(this.d_maxx, this.d_miny, this.d_maxz);
        return p;
    }

    public Point3d MMm(Point3d p) {
        p.set(this.d_maxx, this.d_maxy, this.d_minz);
        return p;
    }

    public Point3d MMM(Point3d p) {
        p.set(this.d_maxx, this.d_maxy, this.d_maxz);
        return p;
    }

    public Point3d[][] getFaces() {
        Point3d mmm = this.mmm();
        Point3d mmM = this.mmM();
        Point3d mMm = this.mMm();
        Point3d mMM = this.mMM();
        Point3d Mmm = this.Mmm();
        Point3d MmM = this.MmM();
        Point3d MMm = this.MMm();
        Point3d MMM = this.MMM();
        return new Point3d[][]{{mMm, mmm, mmM, mMM}, {Mmm, MMm, MMM, MmM}, {mmm, Mmm, MmM, mmM}, {MMm, mMm, mMM, MMM}, {mmm, mMm, MMm, Mmm}, {mmM, MmM, MMM, mMM}};
    }

    public AABoxf toAABoxf() {
        return new AABoxf((float)this.d_minx, (float)this.d_miny, (float)this.d_minz, (float)this.d_maxx, (float)this.d_maxy, (float)this.d_maxz);
    }

    public void transformEq(Matrix4d xform) {
        Point3d[] verts;
        for (Point3d vert : verts = this.getVerts()) {
            xform.transform(vert);
        }
        this.reset();
        this.add(verts);
    }

    public AABox transform(Matrix4d xform) {
        Point3d[] verts;
        AABox result = new AABox();
        for (Point3d vert : verts = this.getVerts()) {
            xform.transform(vert);
            result.add(vert);
        }
        return result;
    }

    public AABox scale(double s) {
        Point3d center = this.getCenter();
        double width = this.getWidth() * s * 0.5;
        double height = this.getHeight() * s * 0.5;
        double depth = this.getDepth() * s * 0.5;
        return new AABox(center.x - width, center.y - depth, center.z - height, center.x + width, center.y + depth, center.z + height);
    }
}

