/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel;
import pyrosim.legacy_2012_1.domain.particle.GenericPartDesc;
import pyrosim.legacy_2012_1.domain.particle.IParticleDesc;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.FDS5Const;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class PropParser
extends AFDS5Parser {
    private static final FDSParseRecord s_defPropRec = new FDSParseRecord(FDS5Const.getRecordSpecs().get("PROP"), true);
    private final Map<String, FDSParseRecord> d_propMap = new HashMap<String, FDSParseRecord>();
    private final Map<String, HeatLinkModel> d_heatLinkModels = new HashMap<String, HeatLinkModel>();
    private final Map<String, SmokeLinkModel> d_smokeLinkModels = new HashMap<String, SmokeLinkModel>();
    private final Map<String, SprayModel> d_sprayModels = new HashMap<String, SprayModel>();
    private final Map<String, SprinklerLinkModel> d_sprkLinkModels = new HashMap<String, SprinklerLinkModel>();

    public PropParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("PROP");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    protected void done() throws FDSRecordFormatException {
        super.done();
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String id = (String)rec.get("ID");
        if (id == null || id.trim().equals("")) {
            this.addWarning(rec, String.format(Intl.intl("%s has no ID."), "PROP"), String.format(Intl.intl("Adding %s to additional records section."), "PROP"));
            return false;
        }
        if (this.d_propMap.containsKey(id)) {
            this.addWarning(rec, String.format(Intl.intl("Duplicate %1$s ID found: %2$s"), "PROP", id), String.format(Intl.intl("Ignoring %s."), "PROP"));
            return true;
        }
        this.d_propMap.put(id, rec);
        this.processProp(id, rec);
        return true;
    }

    protected boolean processProp(String id, FDSParseRecord rec) throws FDSRecordFormatException {
        String propType;
        if (rec.contains("PART_ID")) {
            this.parseSprayModel(rec);
        }
        if ((propType = (String)rec.get("QUANTITY", false)) != null) {
            if (propType.equals("SPRINKLER LINK TEMPERATURE")) {
                this.parseSprinklerLinkModel(rec);
            } else if (propType.equals("LINK TEMPERATURE")) {
                this.parseHeatLinkModel(rec);
            } else if (propType.equals("spot obscuration") || propType.equals("CHAMBER OBSCURATION")) {
                this.parseSmokeLinkModel(rec);
            }
        }
        return true;
    }

    public FDSParseRecord getProp(String propID) {
        return this.d_propMap.get(propID);
    }

    public static FDSParseRecord getDefaultProp() {
        return s_defPropRec;
    }

    private <T extends INamed> void addModel(Composite<T> mgr, Map<String, T> models, T model) {
        mgr.add(model);
        this.flagObjectAdded(model);
        models.put(model.getName(), model);
    }

    protected HeatLinkModel parseHeatLinkModel(FDSParseRecord rec) {
        String id = (String)rec.get("ID");
        HeatLinkModel model = this.d_heatLinkModels.get(id);
        if (model != null) {
            return model;
        }
        UnitDouble initTemp = (UnitDouble)rec.get("INITIAL_TEMPERATURE", true);
        UnitDouble actTemp = (UnitDouble)rec.get("ACTIVATION_TEMPERATURE", true);
        UnitDouble rti = (UnitDouble)rec.get("RTI", true);
        model = new HeatLinkModel(id, rti, initTemp, actTemp);
        this.addModel(this.getContainer().getHeatLinkModels(), this.d_heatLinkModels, model);
        return model;
    }

    protected SmokeLinkModel parseSmokeLinkModel(FDSParseRecord rec) {
        SmokeLinkModel.ISpec spec;
        String id = (String)rec.get("ID");
        SmokeLinkModel model = this.d_smokeLinkModels.get(id);
        if (model != null) {
            return model;
        }
        UnitDouble actObsc = (UnitDouble)rec.get("ACTIVATION_OBSCURATION", true);
        ExSpec smokeSpec = null;
        String specid = (String)rec.get("SPEC_ID", false);
        if (specid != null && (smokeSpec = this.findObject(ExSpec.class, specid)) == null) {
            this.addWarning(rec, String.format(Intl.intl("Could not find custom smoke species, \"%s.\""), specid), String.format(Intl.intl("Tracking default smoke."), new Object[0]));
        }
        if (rec.contains("ALPHA_C") || rec.contains("ALPHA_E") || rec.contains("BETA_C") || rec.contains("BETA_E")) {
            spec = new SmokeLinkModel.Cleary(rec.getDouble("ALPHA_C", true), rec.getDouble("BETA_C", true), rec.getDouble("ALPHA_E", true), rec.getDouble("BETA_E", true));
        } else {
            UnitDouble len = (UnitDouble)rec.get("LENGTH", true);
            spec = new SmokeLinkModel.Heskestad(len);
        }
        model = new SmokeLinkModel(id, actObsc, smokeSpec, spec);
        this.addModel(this.getContainer().getSmokeLinkModels(), this.d_smokeLinkModels, model);
        return model;
    }

    protected SprinklerLinkModel parseSprinklerLinkModel(FDSParseRecord rec) {
        String id = (String)rec.get("ID");
        SprinklerLinkModel model = this.d_sprkLinkModels.get(id);
        if (model != null) {
            return model;
        }
        UnitDouble initTemp = (UnitDouble)rec.get("INITIAL_TEMPERATURE", true);
        UnitDouble actTemp = (UnitDouble)rec.get("ACTIVATION_TEMPERATURE", true);
        UnitDouble rti = (UnitDouble)rec.get("RTI", true);
        UnitDouble cfactor = (UnitDouble)rec.get("C_FACTOR", true);
        model = new SprinklerLinkModel(id, rti, initTemp, actTemp, cfactor);
        this.addModel(this.getContainer().getSprinklerLinkModels(), this.d_sprkLinkModels, model);
        return model;
    }

    protected SprayModel parseSprayModel(FDSParseRecord rec) throws FDSRecordFormatException {
        UnitDouble dtInsert;
        IParticleDesc pDesc;
        String id = (String)rec.get("ID");
        SprayModel model = this.d_sprayModels.get(id);
        if (model != null) {
            return model;
        }
        UnitDouble offset = (UnitDouble)rec.get("OFFSET", true);
        String partID = (String)rec.get("PART_ID", false);
        if (partID == null) {
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("%s was not specified."), "PART_ID"));
        }
        Particle part = this.getParsingInfo().findObject(Particle.class, partID);
        if (part == null) {
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("Particle %s could not be found."), partID));
        }
        List<SprayModel.Jet> jets = this.parseJets(rec, id);
        int dropsPerSecond = rec.getInteger("DROPLETS_PER_SECOND", true);
        if (!rec.contains("DROPLETS_PER_SECOND") && (pDesc = part.getDescription()) instanceof GenericPartDesc) {
            GenericPartDesc pDescGeneric = (GenericPartDesc)pDesc;
            if (pDescGeneric.d_dropsPerSec != -1) {
                dropsPerSecond = pDescGeneric.d_dropsPerSec;
            }
        }
        if ((dtInsert = rec.getUnitDouble("DT_INSERT", false)) == null) {
            dtInsert = part.getDescription().getOutput().d_dtInsert;
        }
        SprayModel.FlowRate flowRate = this.parseFlowRate(rec);
        model = new SprayModel(id, part, offset, flowRate, dropsPerSecond, dtInsert, jets);
        this.addModel(this.getContainer().getSprayModels(), this.d_sprayModels, model);
        return model;
    }

    private static <T> int countNonNull(T ... vals) {
        int count = 0;
        for (T val : vals) {
            if (val == null) continue;
            ++count;
        }
        return count;
    }

    private SprayModel.FlowRate parseFlowRate(FDSParseRecord rec) throws FDSRecordFormatException {
        SprayModel.FlowRate rate;
        TimeFunction timeFunc = this.parseTimeFunction(rec, "FLOW_TAU", "FLOW_RAMP");
        if (rec.contains("PRESSURE_RAMP")) {
            String rName = rec.getString("PRESSURE_RAMP");
            Ramp pressureRamp = this.getParsingInfo().getRamp(rName, SprayModel.VaryingFlowRate.DEF_RAMP_INPUT, 39, true);
            if (pressureRamp == null) {
                throw new FDSRecordFormatException(rec, String.format(Intl.intl("The RAMP, \"%s\", does not exist."), rName));
            }
            UnitDouble kFactor = (UnitDouble)rec.get("K_FACTOR", false);
            UnitDouble opPress = (UnitDouble)rec.get("OPERATING_PRESSURE", false);
            UnitDouble flowRate = (UnitDouble)rec.get("FLOW_RATE", false);
            int count = PropParser.countNonNull(kFactor, opPress, flowRate);
            if (count < 2) {
                throw new FDSRecordFormatException(rec, String.format(Intl.intl("Sprinklers and nozzles with varying pipe pressure must specify at least two of\nthese properties: %1$s, %2$s, and %3$s."), "K_FACTOR", "OPERATING_PRESSURE", "FLOW_RATE"));
            }
            rate = new SprayModel.VaryingFlowRate(pressureRamp, opPress, kFactor, flowRate, timeFunc);
        } else if (rec.contains("FLOW_RATE")) {
            UnitDouble flowRate = (UnitDouble)rec.get("FLOW_RATE", false);
            rate = new SprayModel.ExplicitFlowRate(flowRate, timeFunc);
        } else {
            UnitDouble kFactor = (UnitDouble)rec.get("K_FACTOR", true);
            UnitDouble opPress = (UnitDouble)rec.get("OPERATING_PRESSURE", true);
            rate = new SprayModel.PressurizedFlowRate(opPress, kFactor, timeFunc);
        }
        return rate;
    }

    private List<SprayModel.Jet> parseJets(FDSParseRecord rec, String id) throws FDSRecordFormatException {
        if (rec.contains("SPRAY_PATTERN_TABLE")) {
            String tableID = (String)rec.get("SPRAY_PATTERN_TABLE");
            List<List<Double>> table = this.getParsingInfo().getTable(tableID);
            if (table == null) {
                throw new FDSRecordFormatException(rec, String.format(Intl.intl("Table %s could not be found."), tableID));
            }
            ArrayList<SprayModel.Jet> jets = new ArrayList<SprayModel.Jet>(table.size());
            double totalFlowFrac = 0.0;
            for (List<Double> row : table) {
                if (row.size() < 6) {
                    throw new FDSRecordFormatException(rec, String.format(Intl.intl("%s must have 6 columns."), "SPRAY_PATTERN_TABLE"));
                }
                double flowFrac = row.get(5);
                if (flowFrac < 0.0 || flowFrac > 1.0) {
                    throw new FDSRecordFormatException(rec, Intl.intl("Flow fraction must be between 0 and 1 inclusive."));
                }
                SprayModel.Jet jet = new SprayModel.Jet(SIUS.newud(row.get(4), 8), null, flowFrac, SIUS.newud(row.get(2), 29), SIUS.newud(row.get(3), 29), SIUS.newud(row.get(0), 29), SIUS.newud(row.get(1), 29));
                jets.add(jet);
                totalFlowFrac += flowFrac;
            }
            if (totalFlowFrac > 1.00001) {
                throw new FDSRecordFormatException(rec, Intl.intl("Total flow fraction must be less than or equal to 1."));
            }
            return jets;
        }
        UnitDouble vel = (UnitDouble)rec.get("DROPLET_VELOCITY", true);
        UnitDouble orificeDiam = rec.getUnitDouble("ORIFICE_DIAMETER", false);
        if (orificeDiam != null && rec.contains("DROPLET_VELOCITY")) {
            this.addWarning(rec, String.format(Intl.intl("PROP %1$s specifies both %2$s and %3$s."), id, "ORIFICE_DIAMETER", "DROPLET_VELOCITY"), String.format(Intl.intl("Ignoring %s."), "ORIFICE_DIAMETER"));
            orificeDiam = null;
        } else if (orificeDiam != null) {
            vel = null;
        }
        FDSArray angles = rec.getArray("SPRAY_ANGLE", true);
        return Arrays.asList(new SprayModel.Jet(vel, orificeDiam, 1.0, (UnitDouble)angles.get(0), (UnitDouble)angles.get(1)));
    }
}

