/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.awt.Color;
import java.util.List;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.geom.Obstruction;
import pyrosim.legacy_2012_1.domain.geom.TexOrigin;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDSObjParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.SimParamsParser;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class ObstParser
extends AFDSObjParser {
    private final SimParamsParser d_spParser;
    private final PinConnParser d_pinConns;

    public ObstParser(FDS5ParsingInfo parsingInfo, PinConnParser pinConns, SimParamsParser spParser) {
        super(parsingInfo);
        this.d_pinConns = pinConns;
        this.d_spParser = spParser;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("OBST");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
        unsupportedFields.add("BNDF_FACE");
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String desc = this.generateName(rec, Intl.intl("Obstruction"));
        AABoxGeom geom = ObstParser.parseXBGeom(rec, "OBST", "XB", true);
        Surface[] surfs = this.getSurfs(rec);
        Obstruction block = new Obstruction(desc, geom, surfs);
        Color color = this.parseColor(rec, "RGB", "COLOR", "TRANSPARENCY", false);
        if (color == INVISIBLE_COLOR) {
            block.setVisible(false);
            block.setColors(new Color[]{null});
        } else {
            block.setColors(color);
        }
        block.setEvac(this.parseEvac(rec, "EVACUATION", "MESH_ID"));
        this.parseOption(rec, block, 1, "THICKEN");
        this.parseOption(rec, block, 16, "BNDF_OBST");
        block.setOptions(2, rec.getBoolean("SAWTOOTH", true) == false);
        block.setOptions(4, rec.getBoolean("PERMIT_HOLE", true));
        block.setOptions(8, rec.getBoolean("ALLOW_VENT", true));
        block.setOptions(32, rec.getBoolean("OUTLINE", true));
        block.setOptions(64, rec.getBoolean("REMOVABLE", true));
        UnitDouble dens = rec.getUnitDouble("BULK_DENSITY", true);
        if (dens.getValueNoUnit() > 0.0) {
            block.setBulkDensity(dens);
        }
        TexOrigin texOrigin = ObstParser.parseTexLoc(rec, geom.min, "OBST", "TEXTURE_ORIGIN");
        block.setTextureOrigin(texOrigin);
        ObstParser.markSingleInputForRetrieval(rec, block, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        Pair<String, List<Obstruction>> toAdd = this.applyMult(rec, "MULT_ID", block);
        this.addObjects((String)toAdd.v1, (List)toAdd.v2);
        return true;
    }

    private void parseOption(FDSParseRecord rec, IObstruction obst, int option, String key) {
        Boolean val = rec.getBoolean(key, false);
        if (val == null) {
            boolean set = (this.d_spParser.getObstDefaults() & option) == option;
            obst.setOptions(option, set);
        } else {
            obst.setOptions(option, val);
        }
    }

    private Surface[] getSurfs(FDSParseRecord rec) throws FDSRecordFormatException {
        FDSArray surfIDs;
        IObjectFilter<Surface> surfFilter = Obstruction.getSurfaceFilter();
        Surface[] surfs = null;
        if (rec.contains("SURF_ID")) {
            Surface surf = this.getSurfaceSafe(rec, rec.getString("SURF_ID", false), surfFilter);
            surfs = new Surface[]{surf};
        } else if (rec.contains("SURF_IDS")) {
            surfIDs = rec.getArray("SURF_IDS", false);
            surfs = new Surface[]{this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(2), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(0), surfFilter)};
        } else if (rec.contains("SURF_ID6")) {
            surfIDs = rec.getArray("SURF_ID6", false);
            surfs = new Surface[]{this.getSurfaceSafe(rec, (String)surfIDs.get(0), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(1), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(2), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(3), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(4), surfFilter), this.getSurfaceSafe(rec, (String)surfIDs.get(5), surfFilter)};
        } else {
            Surface defSurf = this.getDefaultMat();
            surfs = new Surface[]{defSurf};
        }
        if (surfs.length > 1 && GeomUtil.isUniform(surfs)) {
            surfs = new Surface[]{surfs[0]};
        }
        if (surfs.length == 1) {
            return surfs;
        }
        Surface[] finalSurfs = new Surface[]{surfs[0], surfs[1], surfs[2], surfs[3], surfs[4], surfs[5]};
        return finalSurfs;
    }
}

