/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds;

import pyrosim.Intl;
import pyrosim.legacy_2012_1.io.fds.FDSParseException;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordDebugInfo;

public class FDSRecordFormatException
extends FDSParseException {
    private static final long serialVersionUID = 3962159604886511887L;
    private final String d_error;

    public FDSRecordFormatException(String error) {
        super(null, 0, FDSRecordFormatException.constructErrorMessage(null, error));
        this.d_error = error;
    }

    public FDSRecordFormatException(FDSParseRecord rec) {
        super(FDSRecordFormatException.getFilename(rec), FDSRecordFormatException.getLineNum(rec), FDSRecordFormatException.constructErrorMessage(rec, null));
        this.d_error = "";
    }

    public FDSRecordFormatException(FDSParseRecord rec, String error) {
        super(FDSRecordFormatException.getFilename(rec), FDSRecordFormatException.getLineNum(rec), FDSRecordFormatException.constructErrorMessage(rec, error));
        this.d_error = error;
    }

    public String getError() {
        return this.d_error;
    }

    private static String getFilename(FDSParseRecord rec) {
        FDSRecordDebugInfo di = rec.getDebugInfo();
        return di != null ? di.getFilename() : null;
    }

    private static int getLineNum(FDSParseRecord rec) {
        FDSRecordDebugInfo di = rec.getDebugInfo();
        return di != null ? di.getBeginLineNum() : 0;
    }

    private static String constructErrorMessage(FDSParseRecord rec, String error) {
        String message = "";
        if (rec != null) {
            FDSRecordDebugInfo debugInfo = rec.getDebugInfo();
            if (debugInfo != null) {
                message = String.format(Intl.intl("Invalid %s record specified."), rec.getType());
                if (debugInfo.getOriginalText() != null) {
                    message = message + "\n\n" + debugInfo.getOriginalText() + "\n";
                }
            }
            if (error != null) {
                if (message.length() > 0) {
                    message = message + "\n";
                }
                message = message + error;
            }
        } else {
            message = Intl.intl("Invalid record specified.");
        }
        return message;
    }
}

