/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds;

import java.util.Arrays;
import java.util.Collection;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSParseResult;
import pyrosim.legacy_2012_1.io.fds.FDSParseWarning;

public class FDSParsingInfo {
    public static final int DBL_FAIL_ON_ERROR = 0;
    public static final int DBL_CONTINUE_ON_ERROR = 1;
    public static final int DEFAULT_DEBUG_LEVEL = 0;
    private final String d_parsingFile;
    private final PyroMod d_wContainer;
    private final Collection<PyroMod> d_rContainers;
    private int d_debugLevel;
    private final FDSParseResult d_parseResult = new FDSParseResult();

    public FDSParsingInfo(String parsingFile, PyroMod writeMod, PyroMod readMod) {
        this(parsingFile, writeMod, readMod, 0);
    }

    public FDSParsingInfo(String parsingFile, PyroMod writeMod, PyroMod readMod, int debugLevel) {
        this.d_parsingFile = parsingFile;
        this.d_debugLevel = debugLevel;
        this.d_wContainer = writeMod;
        this.d_rContainers = readMod == writeMod ? Arrays.asList(writeMod) : Arrays.asList(writeMod, readMod);
    }

    public String getParsingFile() {
        return this.d_parsingFile;
    }

    public int getDebugLevel() {
        return this.d_debugLevel;
    }

    public PyroMod getContainer() {
        return this.d_wContainer;
    }

    public Collection<PyroMod> getSourceContainers() {
        return this.d_rContainers;
    }

    public FDSParseResult getParseResult() {
        return this.d_parseResult;
    }

    public static <T extends IPyroObject> T findObject(Class<T> clazz, String name, PyroMod ... containers) {
        return FDSParsingInfo.findObject(clazz, name, Arrays.asList(containers));
    }

    public static <T extends IPyroObject> T findObject(Class<T> clazz, String name, Collection<PyroMod> containers) {
        for (PyroMod container : containers) {
            T result;
            Composite<? extends IPyroObject> root = FDSParsingInfo.getCategoryRoot(container, clazz);
            assert (root != null);
            if (root == null || (result = root.find(name, clazz, true)) == null) continue;
            return result;
        }
        if (ExSpec.class.isAssignableFrom(clazz)) {
            for (ExSpecList.MixFrac mf : ExSpecList.MixFrac.values()) {
                if (!mf.name.equals(name)) continue;
                return (T)mf.spec;
            }
        }
        return null;
    }

    private static Composite<? extends IPyroObject> getCategoryRoot(PyroMod container, Class type) {
        for (IPyroObject iPyroObject : container.getMembers()) {
            if (!(iPyroObject instanceof Composite) || !((Composite)iPyroObject).getType().isAssignableFrom(type)) continue;
            return (Composite)iPyroObject;
        }
        return null;
    }

    public <T extends IPyroObject> T findObject(Class<T> clazz, String name) {
        return FDSParsingInfo.findObject(clazz, name, this.d_rContainers);
    }

    public <T extends IPyroObject> T findReplacementObject(Class<T> clazz, String name) {
        return FDSParsingInfo.findObject(clazz, name, this.d_wContainer);
    }

    public void addWarning(FDSParseWarning warning) {
        this.d_parseResult.warningReport.addWarning(warning);
    }

    public void addWarning(FDSParseRecord rec, String message, String action) {
        this.d_parseResult.warningReport.addWarning(new FDSParseWarning(rec, message, action));
    }
}

