/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.zones;

import java.awt.Color;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BlockGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IBoxCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;

public class Zone
extends NamedPyroObject
implements IPyroGeomSrc {
    static final long serialVersionUID = 1L;
    public static final Color DEF_COLOR = new Color(0.8f, 0.1f, 0.1f, 0.4f);
    private UnitAABox d_box;
    private boolean d_visible;
    private Color d_color;

    public Zone(String name, UnitAABox bounds) {
        super(name);
        this.d_box = bounds;
        this.d_visible = true;
        this.d_color = DEF_COLOR;
    }

    public boolean isOuter() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Zone)) {
            return false;
        }
        Zone zone = (Zone)obj;
        return this.getName().equals(zone.getName()) && this.d_box.equals(zone.d_box) && this.d_color.equals(zone.d_color);
    }

    @Override
    public Object clone() {
        Zone clone = (Zone)super.clone();
        return clone;
    }

    public void getBounds(AABox bounds) {
        bounds.add(this.d_box.getValue(Geometry.LU));
    }

    public UnitAABox getBox() {
        return this.d_box;
    }

    public void setBox(UnitAABox box) {
        if (!this.d_box.equals(box)) {
            this.d_box = box;
            this.changedEvt(new Object[0]);
        }
    }

    public Color getColor() {
        return this.d_color;
    }

    public void setColor(Color color) {
        if (!this.d_color.equals(color)) {
            this.d_color = color;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public IGeom getGeom() {
        return new BlockGeom(this.d_box.getMin(Geometry.LU), this.d_box.getMax(Geometry.LU), 0);
    }

    @Override
    public void setGeom(IGeom geom, boolean optimizeGeom) {
        if ((geom = Geometry.finalize(geom, optimizeGeom)) instanceof AABoxGeom) {
            AABoxGeom bg = (AABoxGeom)geom;
            this.d_box = new UnitAABox(bg.min, bg.max, Geometry.LU);
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return new DisplayGeom(this.getGeom(), (IPrimProps)new IPrimProps.Face(this.d_color, null, true));
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible != visible) {
            this.d_visible = visible;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public AABox getBounds() {
        return this.getGeom().getBoundingBox(new AABox());
    }

    @Override
    public void getAll(IBoxCollector result, IIsectFilter filter) {
        if (filter.acceptPickObject(this)) {
            result.add(this);
        }
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull box) {
        if (!filter.acceptPickObject(this)) {
            return;
        }
        if (this.getGeom().intersectsBox(this, filter, box)) {
            result.add(this);
        }
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        if (!filter.acceptPickObject(this)) {
            return;
        }
        this.getGeom().pickPoints(isects, filter, this, rayBegin, rayEnd, rayDirN, tester);
    }
}

