/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.texture;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.thunderheadeng.image.Image;

public class Texture
implements Serializable {
    static final long serialVersionUID = 1L;
    private Image d_image;
    private String d_texName;

    public Texture(String texName, Image image) {
        this.d_texName = texName;
        this.d_image = image;
    }

    public String getImageID() {
        return this.d_texName;
    }

    public Image getImage() {
        return this.d_image;
    }

    public BufferedImage getBufferedImage() {
        BufferedImage img = this.d_image.toBufferedImage();
        return img;
    }

    public boolean isValid() {
        return this.d_image.isValid();
    }

    public static BufferedImage makeSafe(BufferedImage img) {
        if (img == null) {
            return null;
        }
        BufferedImage compat = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        Graphics2D g2d = compat.createGraphics();
        g2d.drawImage(img, null, 0, 0);
        g2d.dispose();
        return compat;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[[TextureInfo]");
        sb.append("filename=");
        sb.append(this.getImageID());
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof Texture) {
            return ((Texture)o).getImageID().equals(this.getImageID());
        }
        return false;
    }

    public int hashCode() {
        return this.getImageID().hashCode();
    }

    public boolean usedIn(PyroMod mod) {
        SurfaceManager surfMgr = mod.getSurfaceMgr();
        for (Surface surf : surfMgr.flatten()) {
            TextureInfo texInfo = surf.getTextureInfo();
            if (texInfo == null || !texInfo.getTexID().equals(this.getImageID())) continue;
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        boolean version = false;
        oos.writeInt(0);
        oos.writeObject(this.d_texName);
        Image img = this.d_image.toCachedImage();
        if (img == null) {
            img = this.d_image;
        }
        oos.writeObject(img);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.readInt();
        this.d_texName = (String)ois.readObject();
        this.d_image = (Image)ois.readObject();
    }
}

