/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.reaction;

import java.io.Serializable;
import pyrosim.legacy_2012_1.domain.reaction.Soot;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class Byproducts
implements Serializable {
    static final long serialVersionUID = 1L;
    public final double d_coYield;
    public final double d_h2Yield;
    public final double d_sootYield;
    public final Soot d_soot;
    public final Energy d_energy;

    public Byproducts() {
        this(0.0, 0.0, 0.01, new Soot(), new OxygenEnergy());
    }

    public Byproducts(double coYield, double h2Yield, double sootYield, Soot soot, Energy energy) {
        this.d_coYield = coYield;
        this.d_h2Yield = h2Yield;
        this.d_sootYield = sootYield;
        this.d_soot = soot;
        this.d_energy = energy;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Byproducts)) {
            return false;
        }
        Byproducts bp = (Byproducts)obj;
        return this.d_coYield == bp.d_coYield && this.d_h2Yield == bp.d_h2Yield && this.d_sootYield == bp.d_sootYield && theUtil.equal(this.d_soot, bp.d_soot) && this.d_energy.equals(bp.d_energy);
    }

    public static class OxygenEnergy
    extends Energy {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_epumo2;

        public OxygenEnergy() {
            this(SIUS.newud(13100.0, 48), false);
        }

        public OxygenEnergy(UnitDouble epumo2, boolean ideal) {
            super(ideal);
            this.d_epumo2 = epumo2;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof OxygenEnergy)) {
                return false;
            }
            OxygenEnergy oe = (OxygenEnergy)obj;
            return super.equals(obj) && this.d_epumo2.equals(oe.d_epumo2);
        }
    }

    public static class FuelEnergy
    extends Energy {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_heatOfCombustion;

        public FuelEnergy(UnitDouble hoc, boolean ideal) {
            super(ideal);
            this.d_heatOfCombustion = hoc;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof FuelEnergy)) {
                return false;
            }
            FuelEnergy fe = (FuelEnergy)obj;
            return super.equals(obj) && this.d_heatOfCombustion.equals(fe.d_heatOfCombustion);
        }
    }

    public static abstract class Energy
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final boolean d_ideal;

        public Energy() {
            this(false);
        }

        public Energy(boolean ideal) {
            this.d_ideal = ideal;
        }

        public boolean equals(Object obj) {
            return obj instanceof Energy && ((Energy)obj).d_ideal == this.d_ideal;
        }
    }
}

