/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.particle;

import java.io.IOException;
import java.io.ObjectInputStream;
import pyrosim.legacy_2012_1.domain.CustomFDSProps;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.particle.FuelPartDesc;
import pyrosim.legacy_2012_1.domain.particle.GenericPartDesc;
import pyrosim.legacy_2012_1.domain.particle.IParticleDesc;
import pyrosim.legacy_2012_1.domain.particle.WaterPartDesc;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSink;
import pyrosim.legacy_2012_1.domain.signals.OneLogicInPin;

public class Particle
extends NamedPyroObject
implements ISignalSink {
    static final long serialVersionUID = 1L;
    private String d_fyi;
    private IParticleDesc d_desc;
    private CustomFDSProps d_customFDSProps;
    private OneLogicInPin d_inPin;

    public Particle(String name) {
        this(name, new GenericPartDesc());
    }

    public Particle(String name, IParticleDesc desc) {
        super(name);
        this.d_desc = desc;
        this.d_customFDSProps = new CustomFDSProps();
        this.d_inPin = new OneLogicInPin(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_customFDSProps == null) {
            this.d_customFDSProps = new CustomFDSProps();
        }
        if (this.d_inPin == null) {
            this.d_inPin = new OneLogicInPin(this);
        }
    }

    public CustomFDSProps getCustomFDSProps() {
        return this.d_customFDSProps;
    }

    public void setCustomFDSProps(CustomFDSProps props) {
        this.d_customFDSProps = props;
        this.changedEvt(new Object[0]);
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String fyi) {
        this.d_fyi = fyi;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Object clone() {
        Particle clone = (Particle)super.clone();
        clone.d_inPin = (OneLogicInPin)this.d_inPin.clone(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof Particle && super.equals(obj) && this.d_inPin.equals(((Particle)obj).d_inPin) && this.propEquals(obj);
    }

    public boolean propEquals(Object obj) {
        return obj == this || obj instanceof Particle && this.d_desc.equals(((Particle)obj).d_desc) && this.d_customFDSProps.equals(((Particle)obj).d_customFDSProps);
    }

    public int propHash() {
        return this.d_desc.hashCode() + this.d_customFDSProps.hashCode();
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    public IParticleDesc getDescription() {
        return this.d_desc;
    }

    public void setDescription(IParticleDesc desc) {
        assert (this.d_desc.isMassless() == desc.isMassless());
        this.d_desc = desc;
        this.changedEvt(new Object[0]);
    }

    public boolean isMassless() {
        return this.d_desc.isMassless();
    }

    public boolean isWater() {
        return this.d_desc instanceof WaterPartDesc;
    }

    public boolean isFuel() {
        return this.d_desc instanceof FuelPartDesc;
    }

    public boolean isGeneric() {
        return this.d_desc instanceof GenericPartDesc;
    }

    @Override
    public boolean invokesMixFrac() {
        return this.d_desc.invokesMixFrac();
    }
}

