/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.hvac;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.geom.Vent;
import pyrosim.legacy_2012_1.domain.hvac.HvacComponent;
import pyrosim.legacy_2012_1.domain.hvac.HvacDuct;
import pyrosim.legacy_2012_1.domain.hvac.HvacFilter;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.util.Util;

public class HvacNode
extends HvacComponent {
    private static final long serialVersionUID = 1414663300556603303L;
    public static final String OPT_VENT_XYZ = "opt_vent_xyz";
    private Map<Pair<HvacDuct, HvacDuct>, UnitDouble> d_losses;

    public HvacNode(String id) {
        super(id);
        HvacNode.setDefaults(this);
        this.d_losses = new HashMap<Pair<HvacDuct, HvacDuct>, UnitDouble>();
    }

    @Override
    public HvacNode clone() {
        HvacNode clone = (HvacNode)super.clone();
        clone.d_losses = new HashMap<Pair<HvacDuct, HvacDuct>, UnitDouble>(this.d_losses);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_losses == null) {
            this.d_losses = new HashMap<Pair<HvacDuct, HvacDuct>, UnitDouble>();
        }
    }

    public static void setDefaults(HvacComponent obj) {
        obj.setProp("TYPE_ID", "NODE");
        obj.setProp("AMBIENT", false);
        obj.setProp("FILTER_ID", null);
        obj.setProp("LOSS", Collections.EMPTY_LIST);
        obj.setProp("VENT_ID", null);
        obj.setProp("XYZ", null);
        obj.setProp(OPT_VENT_XYZ, "XYZ");
        obj.setProp("DUCT_ID", Collections.EMPTY_LIST);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        this.addDep(deps, "VENT_ID");
        this.addDep(deps, "FILTER_ID");
        this.addDep(deps, "DUCT_ID");
    }

    private void setVent(Vent obj) {
        this.setProp("VENT_ID", obj);
        this.changedEvt(new Object[0]);
    }

    private void setFilter(HvacFilter obj) {
        this.setProp("FILTER_ID", obj);
        this.changedEvt(new Object[0]);
    }

    private void setDuct(HvacDuct obj) {
        this.addDuct(obj);
        this.changedEvt(new Object[0]);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old instanceof Vent) {
            Util.removeAllNotOfType(objs, Vent.class);
        } else if (old instanceof HvacFilter) {
            Util.removeAllNotOfType(objs, HvacFilter.class);
        } else if (old instanceof HvacDuct) {
            Util.removeAllNotOfType(objs, HvacDuct.class);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old instanceof Vent) {
            return new AReplaceRefTask<Vent>((Object)old, (Object)replacement){

                @Override
                protected void set(Vent obj) {
                    HvacNode.this.setVent(obj);
                }
            };
        }
        if (old instanceof HvacFilter) {
            return new AReplaceRefTask<HvacFilter>((Object)old, (Object)replacement){

                @Override
                protected void set(HvacFilter obj) {
                    HvacNode.this.setFilter(obj);
                }
            };
        }
        if (old instanceof HvacDuct) {
            return new AReplaceRefTask<HvacDuct>((Object)old, (Object)replacement){

                @Override
                protected void set(HvacDuct obj) {
                    HvacNode.this.setDuct(obj);
                }
            };
        }
        return super.taskReplaceDep(old, replacement);
    }

    public void addDuct(HvacDuct duct) {
        if (duct == null) {
            return;
        }
        ArrayList<HvacDuct> attachedDucts = new ArrayList<HvacDuct>((Collection)this.getProp("DUCT_ID"));
        if (!attachedDucts.contains(duct)) {
            attachedDucts.add(duct);
            this.setProp("DUCT_ID", attachedDucts);
        }
    }

    public void removeDuct(HvacDuct duct) {
        if (duct == null) {
            return;
        }
        List attachedDucts = (List)this.getProp("DUCT_ID");
        if (attachedDucts.contains(duct)) {
            attachedDucts.remove(duct);
            this.setProp("DUCT_ID", attachedDucts);
        }
    }

    public boolean isAttachedToDuct(HvacDuct duct) {
        List attachedDucts = (List)this.getProp("DUCT_ID");
        return attachedDucts.contains(duct);
    }

    public int getNumDucts() {
        return ((List)this.getProp("DUCT_ID")).size();
    }

    public boolean isInterior() {
        return (Boolean)this.getProp("AMBIENT") == false;
    }

    public Map<Pair<HvacDuct, HvacDuct>, UnitDouble> getLossMap() {
        return this.d_losses;
    }

    public void setLossMap(Map<Pair<HvacDuct, HvacDuct>, UnitDouble> losses) {
        this.d_losses = losses;
    }

    public List<UnitDouble> getLossList(boolean repZerosWithNull) {
        ArrayList<UnitDouble> losses = new ArrayList<UnitDouble>();
        List attachedDucts = (List)this.getProp("DUCT_ID");
        for (HvacDuct a : attachedDucts) {
            for (HvacDuct b : attachedDucts) {
                Pair<HvacDuct, HvacDuct> key = new Pair<HvacDuct, HvacDuct>(a, b);
                UnitDouble value = this.d_losses.get(key);
                if (repZerosWithNull && value != null && theUtil.eq0(value.getValue(Unit.ONE), 1.0E-9)) {
                    value = null;
                }
                losses.add(this.d_losses.get(key));
            }
        }
        assert (losses.size() == this.getNumDucts() * this.getNumDucts());
        return losses;
    }
}

