/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.geom;

import java.util.ArrayList;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.geom.TexOrigin;
import pyrosim.legacy_2012_1.domain.rasterization.FDSObjectRasterization;
import pyrosim.legacy_2012_1.domain.rasterization.FDSRasterization;
import pyrosim.legacy_2012_1.domain.rasterization.FaceProps;
import pyrosim.legacy_2012_1.geom.IPyroDisplayProps;
import pyrosim.legacy_2012_1.geom.TexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.ITexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.PropsBuilder;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class FDSUtil {
    public static DisplayGeom getRastDisplay(IPyroDisplayProps dispProps, FDSObject obj, TexOrigin texOrigin) {
        if (dispProps == null || dispProps.getRasterizer() == null || !dispProps.getRasterizer().shouldRasterize(obj)) {
            return null;
        }
        FDSRasterization rast = dispProps.getRasterizer();
        FDSObjectRasterization objRast = rast.rasterize(obj);
        if (objRast == null) {
            return DisplayGeom.EMPTY;
        }
        ArrayList geoms = new ArrayList(objRast.geoms.length);
        PropsBuilder propsBuilder = new PropsBuilder();
        for (Pair<IGeom, FaceProps[]> pair : objRast.geoms) {
            geoms.add(pair.v1);
            if (((FaceProps[])pair.v2).length == 1) {
                IPrimProps prop = objRast.fragGen.generateDisplayProps(((FaceProps[])pair.v2)[0]);
                int numFaces = ((IGeom)pair.v1).getNumPrims(1);
                propsBuilder.add(prop, numFaces);
                continue;
            }
            for (FaceProps prop : (FaceProps[])pair.v2) {
                propsBuilder.add(objRast.fragGen.generateDisplayProps(prop), false);
            }
        }
        IPropsSrc props = propsBuilder.finalizeProps();
        GeomGroup geom = new GeomGroup(geoms);
        TexCoordGenerator texGen = new TexCoordGenerator(geom, texOrigin);
        return new DisplayGeom((IGeom)geom, (ITexCoordGenerator)texGen, props);
    }
}

