/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.controls;

import java.util.Arrays;
import java.util.List;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.controls.AControl;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.ILatchable;
import pyrosim.legacy_2012_1.domain.signals.ILogicOutPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.LogicOutPin;
import pyrosim.legacy_2012_1.domain.signals.OneLogicInPin;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class TimeDelayCtrl
extends AControl
implements ILatchable {
    static final long serialVersionUID = 1L;
    private UnitDouble d_timeDelay;
    private IInPin d_inPin;
    private IOutPin d_outPin;

    public TimeDelayCtrl(UnitDouble timeDelay) {
        this.d_timeDelay = timeDelay;
        this.d_inPin = new OneLogicInPin(this);
        this.d_outPin = new LogicOutPin(this);
    }

    @Override
    protected String getDefaultName() {
        return Intl.intl("tdelay");
    }

    @Override
    public boolean latches(ILogicOutPin pin) {
        return false;
    }

    @Override
    public Object clone() {
        TimeDelayCtrl clone = (TimeDelayCtrl)super.clone();
        clone.d_inPin = (IInPin)this.d_inPin.clone(clone);
        clone.d_outPin = (IOutPin)this.d_outPin.clone(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TimeDelayCtrl)) {
            return false;
        }
        TimeDelayCtrl ctrl = (TimeDelayCtrl)obj;
        return super.equals(obj) && this.d_timeDelay.equals(ctrl.d_timeDelay) && this.d_inPin.equals(ctrl.d_inPin);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 141726698 + this.d_inPin.hashCode() + this.d_timeDelay.hashCode();
    }

    @Override
    public boolean isNoop() {
        return this.d_timeDelay.getValue(SI.SECOND) == 0.0 || super.isNoop();
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        return Arrays.asList(this.d_outPin);
    }

    public void setTimeDelay(UnitDouble timeDelay) {
        this.d_timeDelay = timeDelay;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getTimeDelay() {
        return this.d_timeDelay;
    }
}

