/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.surf;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.CustomFDSProps;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.PredefSurf;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfDescStatic;
import pyrosim.legacy_2012_1.domain.dependencies.SkipDep;
import pyrosim.legacy_2012_1.domain.texture.Texture;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IMaterial;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Surface
extends NamedPyroObject
implements IMaterial {
    static final long serialVersionUID = 1L;
    public static final Object EVT_TEXTURE = new Object();
    public static final Object EVT_COLOR = new Object();
    public static final Object EVT_FYI = new Object();
    private Color d_color;
    private TextureInfo d_texinfo;
    @SkipDep
    private transient Icon d_icon = null;
    private ISurfDesc d_surfDesc = null;
    private String d_fyi;
    private CustomFDSProps d_customFDSProps;

    public Surface() {
        this(Intl.intl("DEFAULT"));
    }

    public Surface(String name) {
        this(name, new Color(255, 204, 102), null);
    }

    public Surface(String name, Color color, TextureInfo texInfo) {
        this(name, color, texInfo, new SurfDescStatic.Inert());
    }

    public Surface(String name, Color color, TextureInfo texInfo, ISurfDesc desc) {
        super(name);
        this.d_color = color;
        this.d_texinfo = texInfo;
        this.d_surfDesc = desc;
        this.d_fyi = "";
        this.d_customFDSProps = new CustomFDSProps();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_customFDSProps == null) {
            this.d_customFDSProps = new CustomFDSProps();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Surface)) {
            return false;
        }
        Surface s = (Surface)obj;
        return super.equals(obj) && this.d_color.equals(s.d_color) && theUtil.equal(this.d_texinfo, s.d_texinfo) && this.d_surfDesc.equals(s.d_surfDesc) && this.d_customFDSProps.equals(s.d_customFDSProps);
    }

    public Color getColor() {
        return this.d_color;
    }

    public void setColor(Color col) {
        if (this.d_color.equals(col)) {
            return;
        }
        this.d_color = col;
        this.changedEvt(EVT_COLOR);
    }

    public CustomFDSProps getCustomFDSProps() {
        return this.d_customFDSProps;
    }

    public void setCustomFDSProps(CustomFDSProps props) {
        this.d_customFDSProps = props;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Pair<Color, pyrosim.legacy_2012_1.thunderheadeng.image.Image> getDiffuse() {
        pyrosim.legacy_2012_1.thunderheadeng.image.Image img = null;
        if (this.d_texinfo != null && this.getDomain() != null) {
            Texture tex = TextureInfo.getTexture(this.d_texinfo, ((PyroMod)this.getDomain()).getTextureDB());
            img = tex != null ? tex.getImage() : null;
        }
        return new Pair<Color, Object>(this.d_color, img);
    }

    @Override
    public Pair<Color, pyrosim.legacy_2012_1.thunderheadeng.image.Image> getSpecular() {
        return new Pair<Color, Object>(Color.WHITE, null);
    }

    @Override
    public pyrosim.legacy_2012_1.thunderheadeng.image.Image getNormal() {
        return null;
    }

    public void setSurfDesc(ISurfDesc desc) {
        this.d_surfDesc = desc;
        this.changedEvt(new Object[0]);
    }

    public ISurfDesc getSurfDesc() {
        return this.d_surfDesc;
    }

    public TextureInfo getTextureInfo() {
        return this.d_texinfo;
    }

    public void setTexture(TextureInfo texinfo) {
        if (this.d_texinfo == texinfo) {
            return;
        }
        this.d_texinfo = texinfo;
        this.invalidateIcon();
        this.changedEvt(EVT_TEXTURE);
    }

    public String getFYI() {
        return this.d_fyi;
    }

    public void setFYI(String fyi) {
        this.d_fyi = fyi;
        this.changedEvt(EVT_FYI);
    }

    private void invalidateIcon() {
        this.d_icon = null;
    }

    public Icon getIcon(int width, int height) {
        if (this.d_icon == null) {
            TextureInfo ti = this.getTextureInfo();
            if (ti != null && this.getDomain() != null) {
                Texture tex = TextureInfo.getTexture(ti, ((PyroMod)this.getDomain()).getTextureDB());
                assert (tex != null);
                BufferedImage fullimage = tex.getBufferedImage();
                if (fullimage == null) {
                    return null;
                }
                BufferedImage iconImage = new BufferedImage(width, height, 2);
                Graphics2D g2d = iconImage.createGraphics();
                AffineTransform xform = new AffineTransform();
                xform.translate(1.0, 1.0);
                xform.scale((double)(width - 2) / (double)fullimage.getWidth(), (double)(height - 2) / (double)fullimage.getHeight());
                g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setColor(new Color(0, 0, 0, 0));
                g2d.fillRect(0, 0, width, height);
                g2d.drawImage(fullimage, xform, new ImageObserver(){

                    @Override
                    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                        return true;
                    }
                });
                g2d.dispose();
                this.d_icon = new ImageIcon(iconImage);
            } else {
                this.d_icon = null;
            }
        }
        return this.d_icon;
    }

    public boolean isPredefined() {
        for (PredefSurf surf : PredefSurf.values()) {
            if (!surf.name().equals(this.getName())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Surface: " + this.getName() + " (" + this.d_fyi + ")";
    }

    @Override
    public boolean invokesMixFrac() {
        return this.d_surfDesc.invokesMixFrac();
    }
}

