/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pyrosim.Intl;
import pyrosim.io.IOUtil;
import pyrosim.legacy_2012_1.domain.APyroObject;

public class ResultsArchive
extends APyroObject {
    static final long serialVersionUID = 1L;
    public static final Directory DIRECTORY = new Directory();
    public static final Compressed COMPRESSED = new Compressed();
    public static final Uncompressed UNCOMPRESSED = new Uncompressed();
    public static final List<IMethod> ALL_METHODS = Arrays.asList(DIRECTORY, UNCOMPRESSED, COMPRESSED);
    private final Map<String, Record> d_records = new HashMap<String, Record>();

    public void addArchive(Record record) {
        this.d_records.put(record.name, record);
        this.changedEvt(new Object[0]);
    }

    public void deleteArchive(Record record) {
        this.d_records.remove(record.name);
        this.changedEvt(new Object[0]);
    }

    public Collection<Record> getAllRecords() {
        return this.d_records.values();
    }

    public List<Record> getActiveArchives(File outputDir) {
        ArrayList<Record> active = new ArrayList<Record>(this.d_records.size());
        for (Record rec : this.d_records.values()) {
            if (!rec.method.exists(outputDir, rec.name)) continue;
            active.add(rec);
        }
        return active;
    }

    public static class CompressedOptions {
        public final int compressionLevel;

        public CompressedOptions(int level) {
            this.compressionLevel = level;
        }
    }

    public static class Compressed
    extends Zipped {
        static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return Intl.intl("Store in compressed ZIP");
        }

        @Override
        protected void zip(File resultsDir, File zipFile, Object options) throws IOException {
            assert (options instanceof CompressedOptions);
            CompressedOptions co = (CompressedOptions)options;
            IOUtil.zip(resultsDir, zipFile, true, co.compressionLevel);
        }

        private Object readResolve() throws ObjectStreamException {
            return COMPRESSED;
        }
    }

    public static class Uncompressed
    extends Zipped {
        static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return Intl.intl("Store in uncompressed ZIP");
        }

        @Override
        protected void zip(File resultsDir, File zipFile, Object options) throws IOException {
            IOUtil.zip(resultsDir, zipFile, false, 0);
        }

        private Object readResolve() throws ObjectStreamException {
            return UNCOMPRESSED;
        }
    }

    private static abstract class Zipped
    implements IMethod {
        static final long serialVersionUID = 1L;

        protected abstract void zip(File var1, File var2, Object var3) throws IOException;

        private Zipped() {
        }

        @Override
        public void archive(File srcDir, File dstDir, String archiveName, boolean retainCurrentResults, Object options) throws IOException {
            File outFile = Zipped.getResultFile(dstDir, archiveName);
            if (outFile.exists()) {
                throw new IOException(String.format(Intl.intl("%s already exists."), outFile.getAbsolutePath()));
            }
            this.zip(srcDir, outFile, options);
            IOUtil.checkZippedFile(srcDir, outFile);
            if (!retainCurrentResults) {
                IOUtil.delete(srcDir);
            }
        }

        @Override
        public boolean exists(File dir, String name) {
            File file = Zipped.getResultFile(dir, name);
            return file.exists() && file.isFile();
        }

        protected static File getResultFile(File dir, String archiveName) {
            return new File(dir, archiveName + ".zip");
        }

        @Override
        public void restore(File srcArchiveDir, String srcArchiveName, File dstDir, boolean retainArchive) throws IOException {
            File src = Zipped.getResultFile(srcArchiveDir, srcArchiveName);
            IOUtil.unzip(src, dstDir);
            IOUtil.checkUnzippedFile(src, dstDir);
            if (!retainArchive) {
                IOUtil.delete(src);
            }
        }
    }

    public static class Directory
    implements IMethod {
        static final long serialVersionUID = 1L;

        private Directory() {
        }

        @Override
        public String toString() {
            return Intl.intl("Store in new results directory");
        }

        @Override
        public void archive(File srcDir, File dstDir, String archiveName, boolean retainCurrentResults, Object options) throws IOException {
            File dest = new File(dstDir, archiveName);
            this.exchange(srcDir, dest, retainCurrentResults);
        }

        @Override
        public void restore(File srcArchiveDir, String srcArchiveName, File dstDir, boolean retainArchive) throws IOException {
            File src = new File(srcArchiveDir, srcArchiveName);
            this.exchange(src, dstDir, retainArchive);
        }

        private void exchange(File source, File dest, boolean retainSource) throws IOException {
            if (dest.exists()) {
                throw new IOException(String.format(Intl.intl("%s already exists."), dest.getAbsolutePath()));
            }
            if (!retainSource) {
                if (!source.renameTo(dest)) {
                    IOUtil.copyDir(source, dest);
                    IOUtil.delete(source);
                }
            } else {
                IOUtil.copyDir(source, dest);
            }
        }

        @Override
        public boolean exists(File dir, String name) {
            File file = new File(dir, name);
            return file.exists() && file.isDirectory();
        }

        private Object readResolve() throws ObjectStreamException {
            return DIRECTORY;
        }
    }

    public static interface IMethod
    extends Serializable {
        public void archive(File var1, File var2, String var3, boolean var4, Object var5) throws IOException;

        public void restore(File var1, String var2, File var3, boolean var4) throws IOException;

        public boolean exists(File var1, String var2);

        public String toString();
    }

    public static class Record
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final IMethod method;
        public final String name;
        public final long dateCreated;

        public Record(String name, IMethod method, long dateCreated) {
            this.name = name;
            this.method = method;
            this.dateCreated = dateCreated;
        }
    }
}

