/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.filechooser.FileFilter;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.io.IOUtil;
import pyrosim.legacy_2012_1.domain.texture.Texture;
import pyrosim.legacy_2012_1.domain.texture.TextureDB;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.thunderheadeng.image.Image;
import pyrosim.legacy_2012_1.thunderheadeng.io.ExampleFileFilter;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class TextureDBMgr {
    private static final String TEX_DIR_NAME = "textures";
    private static final String INFO_EXTN = ".xml";
    private File d_dbDir;
    private TextureDB d_db;

    public TextureDBMgr() {
        this(null);
    }

    public TextureDBMgr(File dbDir) {
        this.d_dbDir = dbDir;
        this.init();
    }

    private void init() {
        this.d_db = new TextureDB();
        File texDir = this.getTexDir();
        if (texDir != null) {
            this.scanDir(texDir);
        }
    }

    public TextureDB getDatabase() {
        return this.d_db;
    }

    public FileFilter[] getFileFilters() {
        return new FileFilter[]{new ExampleFileFilter(new String[]{"bmp", "gif", "jpg", "jpeg", "png"}, "All Supported Formats"), new ExampleFileFilter(new String[]{"bmp"}, "Windows Bitmap"), new ExampleFileFilter(new String[]{"gif"}, "Graphics Interchange Format"), new ExampleFileFilter(new String[]{"jpg", "jpeg"}, "JPEG File Interchange Format"), new ExampleFileFilter(new String[]{"png"}, "Portable Network Graphics")};
    }

    public void setTextureDB(TextureDB db) {
        if (db == this.d_db) {
            return;
        }
        this.init();
        ArrayList<String> dbNames = new ArrayList<String>(db.names());
        for (String name : this.d_db.names()) {
            Texture otherTex = db.getTexture(name);
            TextureInfo otherTi = db.getDefaultInfo(name);
            if (otherTex == null) {
                db.setTexture(name, this.d_db.getTexture(name));
            }
            if (otherTi != null) continue;
            db.setDefaultInfo(name, this.d_db.getDefaultInfo(name));
        }
        for (String name : dbNames) {
            File dbDir;
            Texture thisTex = this.d_db.getTexture(name);
            Texture otherTex = db.getTexture(name);
            TextureInfo otherTi = db.getDefaultInfo(name);
            assert (otherTex != null);
            if (otherTi == null) {
                otherTi = new TextureInfo(name);
                db.setDefaultInfo(name, otherTi);
            }
            if ((dbDir = this.getTexDir()) != null && thisTex == null) {
                File dest = new File(dbDir, name);
                if (!otherTex.getImage().save(dest.getAbsolutePath())) continue;
                Image newimg = Image.loadUncached(dest.getAbsolutePath());
                Texture newTex = new Texture(name, newimg);
                db.setTexture(name, newTex);
                TextureDBMgr.store(dbDir, name, otherTi);
                continue;
            }
            if ((thisTex == null || thisTex.getImage().isCached() || !otherTex.getImage().isCached() || !TextureDBMgr.sudoCompare(thisTex.getImage(), otherTex.getImage())) && (thisTex == null || otherTex.isValid())) continue;
            db.setTexture(name, thisTex);
        }
        this.d_db = db;
    }

    private static boolean sudoCompare(Image i1, Image i2) {
        return TextureDBMgr.size(i1) == TextureDBMgr.size(i2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long size(Image image) {
        if (image.isCached()) {
            return image.getBuffer().capacity();
        }
        File f = new File(image.getFilename());
        try (FileInputStream is = new FileInputStream(f);){
            long l = is.getChannel().size();
            return l;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public File getTexDir() {
        if (this.d_dbDir == null) {
            return null;
        }
        File texDir = new File(this.d_dbDir, TEX_DIR_NAME);
        if (!texDir.isDirectory()) {
            if (texDir.exists()) {
                texDir.delete();
            }
            texDir.mkdir();
        }
        return texDir;
    }

    public void setDefaultInfo(String texname, TextureInfo defaultInfo) {
        this.d_db.setDefaultInfo(texname, defaultInfo);
        File dbdir = this.getTexDir();
        if (dbdir != null) {
            this.store(dbdir, texname);
        }
    }

    public boolean contains(File src) {
        String destName = src.getName();
        return this.d_db.names().contains(destName);
    }

    public TextureInfo addToDB(File src) throws IOException {
        UnitDouble height;
        UnitDouble width;
        Image img;
        String destName = src.getName();
        if (this.d_db.names().contains(destName)) {
            return this.d_db.getDefaultInfo(destName);
        }
        File texDir = this.getTexDir();
        if (texDir != null) {
            File dest = new File(this.getTexDir(), destName);
            Image tempimg = Image.load(src.getAbsolutePath());
            img = tempimg != null && tempimg.save(dest.getAbsolutePath()) ? Image.loadUncached(dest.getAbsolutePath()) : Image.loadUncached(src.getAbsolutePath());
        } else {
            img = Image.loadUncached(src.getAbsolutePath());
        }
        int p_width = img.getWidth();
        int p_height = img.getHeight();
        if (p_width > p_height) {
            width = new UnitDouble(1.0, SI.METER);
            height = new UnitDouble((double)p_height / (double)p_width, SI.METER);
        } else if (p_height > p_width) {
            height = new UnitDouble(1.0, SI.METER);
            width = new UnitDouble((double)p_width / (double)p_height, SI.METER);
        } else {
            width = new UnitDouble(1.0, SI.METER);
            height = new UnitDouble(1.0, SI.METER);
        }
        TextureInfo texInfo = new TextureInfo(destName, width, height);
        Texture tex = new Texture(destName, img);
        this.d_db.setTexture(destName, tex);
        this.setDefaultInfo(destName, texInfo);
        return texInfo;
    }

    private static File getPropsFile(File texDir, String texName) {
        String fn = texName + INFO_EXTN;
        return new File(texDir, fn);
    }

    private void store(File texDir, String texName) {
        TextureInfo ti = this.d_db.getDefaultInfo(texName);
        TextureDBMgr.store(texDir, texName, ti);
    }

    private static void store(File texDir, String texName, TextureInfo ti) {
        System.out.print("storing defaults for \"" + texName + "\"...");
        TexturePrefs tp = new TexturePrefs();
        UnitDouble tWid = ti.getWidth();
        UnitDouble tHt = ti.getHeight();
        Unit u = tWid.getUnit();
        tp.setLenUnit(tWid.getUnit());
        tp.setProperty("width", Double.toString(tWid.getValue(u)));
        tp.setProperty("height", Double.toString(tHt.getValue(u)));
        try {
            File f = TextureDBMgr.getPropsFile(texDir, texName);
            FileOutputStream fos = new FileOutputStream(f);
            tp.storeToXML(fos, texName);
            fos.close();
            System.out.println("done");
        }
        catch (IOException e) {
            System.out.println("failed");
            e.printStackTrace();
        }
    }

    public FilenameFilter getFilenameFilter() {
        final FileFilter[] filters = this.getFileFilters();
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File file = new File(dir, name);
                for (FileFilter filter : filters) {
                    if (!filter.accept(file)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private void scanDir(File texDir) {
        List<File> texFn = IOUtil.listFiles(texDir, this.getFilenameFilter());
        String[] names = new String[texFn.size()];
        for (int i = 0; i < texFn.size(); ++i) {
            String texFile = texFn.get(i).getAbsolutePath();
            names[i] = texFn.get(i).getName();
            String texID = texFn.get(i).getName();
            Texture tex = new Texture(texID, Image.loadUncached(texFile));
            File infoFile = new File(texDir, names[i] + INFO_EXTN);
            if (infoFile.exists()) {
                TexturePrefs tp = new TexturePrefs();
                try {
                    FileInputStream fis = new FileInputStream(infoFile);
                    tp.loadFromXML(fis);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    tp = null;
                }
                if (tp != null) {
                    TextureInfo texInfo = new TextureInfo(texID);
                    Unit lenU = tp.getLenUnit();
                    double wid = tp.getDouble("width", 1.0);
                    double ht = tp.getDouble("height", 1.0);
                    texInfo.setWidth(new UnitDouble(wid, lenU));
                    texInfo.setHeight(new UnitDouble(ht, lenU));
                    this.d_db.setTexture(texID, tex);
                    this.d_db.setDefaultInfo(texID, texInfo);
                }
            }
            if (this.d_db.names().contains(texID)) continue;
            TextureInfo texInfo = new TextureInfo(texID);
            this.d_db.setTexture(texID, tex);
            this.setDefaultInfo(texID, texInfo);
        }
    }

    private static class TexturePrefs
    extends Properties {
        private static final long serialVersionUID = 3381148438110254373L;
        public static final int UNIT_METERS = 0;
        public static final int UNIT_FEET = 1;
        private static final String KEY_WID = "width";
        private static final String KEY_HT = "height";
        private static final String KEY_UNITS = "length_unit";

        private TexturePrefs() {
        }

        public double getDouble(String key, double defVal) {
            String prop = this.getProperty(key);
            if (prop != null) {
                return Double.parseDouble(this.getProperty(key));
            }
            return defVal;
        }

        public void setLenUnit(Unit u) {
            BaseUnit m = SI.METER;
            Unit ft = NonSI.FOOT;
            if (((Unit)m).equals(u)) {
                this.setProperty(KEY_UNITS, Integer.toString(0));
            } else if (ft.equals(u)) {
                this.setProperty(KEY_UNITS, Integer.toString(1));
            } else {
                throw new IllegalArgumentException(u.toString());
            }
        }

        public Unit getLenUnit() {
            String prop = this.getProperty(KEY_UNITS);
            if (prop != null && prop.equals(Integer.toString(0))) {
                return SI.METER;
            }
            if (prop != null && prop.equals(Integer.toString(1))) {
                return NonSI.FOOT;
            }
            return null;
        }
    }
}

