/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.gui;

import pyrosim.legacy_2006_2.thunderheadeng.gui.guiField;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;

public class guiIntField
extends guiField {
    private static final long serialVersionUID = -2018094539797374486L;
    private int d_value;
    private boolean d_modified;
    private IntValueRange d_range;

    public guiIntField() {
        this(0);
    }

    public guiIntField(IntValueRange valueRange) {
        this((Integer)valueRange.clampValue(valueRange.getMinValue()), valueRange);
    }

    public guiIntField(int value) {
        this(value, null);
    }

    public guiIntField(int value, IntValueRange valueRange) {
        this.init();
        this.d_range = valueRange == null ? IntValueRange.createUncheckedRange() : valueRange;
        this.setValue(value);
    }

    private void init() {
        this.d_value = 0;
        this.d_modified = false;
        this.setHorizontalAlignment(2);
    }

    public void setValueRange(IntValueRange range) {
        this.d_range = range;
        this.setValue(this.d_range.clampValue(this.d_value));
    }

    public void setValue(int value) {
        if (!this.d_range.checkValue(value)) {
            String msg = "Value out of range in guiIntField.setValue()";
            throw new IllegalArgumentException(msg);
        }
        super.setText(Integer.toString(value));
        this.d_value = value;
    }

    @Override
    public void setText(String text) {
        int newValue = Integer.parseInt(text);
        this.setValue(newValue);
    }

    public int getValue() {
        return this.d_value;
    }

    public boolean validateData(boolean modify, boolean warn) {
        int newValue;
        if (!this.shouldValidate()) {
            return true;
        }
        try {
            newValue = Integer.parseInt(this.getText());
        }
        catch (NumberFormatException e) {
            if (warn) {
                String msg = "The entry \"" + this.getText() + "\" is invalid.\n" + "Please enter " + this.d_range.describeRange() + ".";
                this.showMessageBox(msg);
                this.requestFocusHack();
            }
            return false;
        }
        if (!this.d_range.checkValue(newValue)) {
            if (warn) {
                String msg = "The entry \"" + this.getText() + "\" is out of range.\n" + "Please enter " + this.d_range.describeRange() + ".";
                this.showMessageBox(msg);
                this.requestFocusHack();
            }
            return false;
        }
        if (modify) {
            if (newValue != this.d_value) {
                this.setValue(newValue);
                this.d_modified = true;
            }
        } else {
            this.d_value = newValue;
        }
        return true;
    }

    @Override
    public boolean validateData() {
        return this.validateData(true, true);
    }

    @Override
    public boolean isModified() {
        if (this.d_modified) {
            return true;
        }
        try {
            int newValue = Integer.parseInt(this.getText());
            return newValue != this.d_value;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
    }
}

