/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TCData {
    private List<String> d_labels;
    private List<String> d_quantities;
    private List<String> d_units;
    private List<Double>[] d_values;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_GENERIC = 1;
    public static final int ERROR_OPENING = 2;
    public static final int ERROR_NTC = 3;
    public static final int ERROR_LABELS = 4;
    public static final int ERROR_QUANTITIES = 5;
    public static final int ERROR_UNITS = 6;
    public static final int ERROR_VALUES_BASE = 10;
    private int d_err;

    public TCData(File tcFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(tcFile));
        }
        catch (FileNotFoundException e) {
            this.d_err = 2;
            return;
        }
        try {
            this.parseNTC(reader);
        }
        catch (Exception e) {
            this.d_err = 3;
            this.close(reader);
            return;
        }
        try {
            this.d_labels = this.parseLabels(reader);
        }
        catch (Exception e) {
            this.d_labels = new ArrayList<String>();
        }
        try {
            this.d_quantities = this.parseQuantities(reader);
        }
        catch (Exception e) {
            this.d_quantities = new ArrayList<String>();
        }
        try {
            this.d_units = this.parseUnits(reader);
        }
        catch (Exception e) {
            this.d_units = new ArrayList<String>();
        }
        ArrayList<List<Double>> valueLists = new ArrayList<List<Double>>();
        int value = 0;
        try {
            while (reader.ready()) {
                valueLists.add(this.parseValues(reader));
                ++value;
            }
        }
        catch (Exception e) {
            this.d_err = 10 + value;
        }
        this.close(reader);
        this.d_values = new List[valueLists.size()];
        for (int i = 0; i < valueLists.size(); ++i) {
            this.d_values[i] = (List)valueLists.get(i);
        }
        if (this.d_labels.size() != this.d_quantities.size() || this.d_quantities.size() != this.d_units.size()) {
            this.d_err = 1;
        }
    }

    private void close(BufferedReader file) {
        try {
            file.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public int getError() {
        return this.d_err;
    }

    public String errStr() {
        switch (this.getError()) {
            case 1: {
                return "file format error";
            }
            case 4: {
                return "error reading labels";
            }
            case 0: {
                return "no errors";
            }
            case 3: {
                return "error reading number of timesteps";
            }
            case 2: {
                return "error opening file";
            }
            case 5: {
                return "error reading quantities";
            }
            case 6: {
                return "error reading units";
            }
            case 10: {
                return "The input file contains no data";
            }
        }
        return "WARNING: list of values is incomplete (" + (this.getError() - 10 + 1) + ")";
    }

    public List<String> getLabels() {
        return this.d_labels;
    }

    public List<String> getQuantities() {
        return this.d_quantities;
    }

    public List<String> getUnits() {
        return this.d_units;
    }

    public List<Double> getValues(int ts) {
        return this.d_values[ts];
    }

    public int getNumValues() {
        return this.d_values.length;
    }

    private int parseNTC(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        assert (line != null);
        return Integer.parseInt(line.replaceAll(" ", ""));
    }

    private List<String> parseLabels(BufferedReader reader) throws IOException {
        ArrayList<String> labels = new ArrayList<String>();
        String line = reader.readLine();
        if (line != null) {
            line = line.replaceAll(" ", "");
            String[] vals = line.split(",");
            for (int i = 0; i < vals.length; ++i) {
                labels.add(vals[i]);
            }
        }
        return labels;
    }

    private List<String> parseQuantities(BufferedReader reader) throws IOException {
        ArrayList<String> quans = new ArrayList<String>();
        String line = reader.readLine();
        if (line != null) {
            line = line.replaceAll(" ", "");
            String[] vals = line.split(",");
            for (int i = 0; i < vals.length; ++i) {
                quans.add(vals[i]);
            }
        }
        return quans;
    }

    private List<String> parseUnits(BufferedReader reader) throws IOException {
        ArrayList<String> units = new ArrayList<String>();
        String line = reader.readLine();
        if (line != null) {
            line = line.replaceAll(" ", "");
            String[] vals = line.split(",");
            for (int i = 0; i < vals.length; ++i) {
                units.add(vals[i]);
            }
        }
        return units;
    }

    private List<Double> parseValues(BufferedReader reader) throws IOException {
        ArrayList<Double> values = new ArrayList<Double>();
        String line = reader.readLine();
        if (line != null) {
            line = line.replaceAll(" ", "");
            String[] vals = line.split(",");
            for (int i = 0; i < vals.length; ++i) {
                values.add(Double.valueOf(vals[i]));
            }
        }
        return values;
    }
}

