/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.Rectifier;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AlignedBlock;
import pyrosim.legacy_2006_2.domain.FDSColors;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.EventParser;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;

class ObstProcessor
extends AFDSRecordProcessor {
    private Map d_allObstructions = new TreeMap();
    private Hashtable d_compositesMap = new Hashtable();
    private int d_nextObstNum = 1;

    public ObstProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    private Material getMaterialSafe(FDSInputRecord rec, String materialName) throws FDSRecordFormatException {
        if (materialName == null) {
            return this.getParsingInfo().getDefaultMaterial();
        }
        Material mat = this.getResource(materialName, Material.class);
        if (mat == null) {
            throw new FDSRecordFormatException(rec, "The SURF, " + materialName + ", does not exist in the model.");
        }
        return mat;
    }

    @Override
    public String getFDSTypeParsed() {
        return "OBST";
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        boolean err = false;
        if (!"OBST".equals(rec.getType())) {
            return false;
        }
        Vector coords = null;
        try {
            AlignedBlock correctBlock;
            Boolean sawtooth;
            Boolean permitHole;
            coords = (Vector)rec.getValue("XB");
            Point3d min = new Point3d((Double)coords.get(0), (Double)coords.get(2), (Double)coords.get(4));
            Point3d max = new Point3d((Double)coords.get(1), (Double)coords.get(3), (Double)coords.get(5));
            if (Rectifier.rectify(min, max)) {
                // empty if block
            }
            Unit u = FdsSISystem.getInstance().getLengthUnit();
            UnitPoint3D minu = new UnitPoint3D(min, u);
            UnitPoint3D maxu = new UnitPoint3D(max, u);
            String desc = rec.getComment();
            if (desc == null || desc.equals("")) {
                desc = new String("Obstruction #" + this.d_nextObstNum++);
            }
            AlignedBlock block = new AlignedBlock(minu, maxu, desc, this.getParsingInfo().getDefaultMaterial());
            Object surfID = rec.getValue("SURF_ID");
            if (surfID != null) {
                block.setMaterial(this.getMaterialSafe(rec, surfID.toString()));
            } else {
                Vector surfaces;
                surfID = rec.getValue("SURF_IDS");
                if (surfID != null) {
                    surfaces = (Vector)surfID;
                    Material top = this.getMaterialSafe(rec, surfaces.elementAt(0).toString());
                    Material sides = this.getMaterialSafe(rec, surfaces.elementAt(1).toString());
                    Material bottom = this.getMaterialSafe(rec, surfaces.elementAt(2).toString());
                    block.setMaterial(5, top);
                    block.setMaterial(0, sides);
                    block.setMaterial(1, sides);
                    block.setMaterial(2, sides);
                    block.setMaterial(3, sides);
                    block.setMaterial(4, bottom);
                } else {
                    surfID = rec.getValue("SURF_ID6");
                    if (surfID != null) {
                        surfaces = (Vector)surfID;
                        block.setMaterial(0, this.getMaterialSafe(rec, surfaces.elementAt(0).toString()));
                        block.setMaterial(1, this.getMaterialSafe(rec, surfaces.elementAt(1).toString()));
                        block.setMaterial(2, this.getMaterialSafe(rec, surfaces.elementAt(2).toString()));
                        block.setMaterial(3, this.getMaterialSafe(rec, surfaces.elementAt(3).toString()));
                        block.setMaterial(4, this.getMaterialSafe(rec, surfaces.elementAt(4).toString()));
                        block.setMaterial(5, this.getMaterialSafe(rec, surfaces.elementAt(5).toString()));
                    } else {
                        block.setMaterial(this.getParsingInfo().getDefaultMaterial());
                    }
                }
            }
            Color color = this.parseColor(rec);
            if (color != null) {
                block.setColor(color);
            } else {
                String colorName = (String)rec.getValue("COLOR");
                if (colorName != null) {
                    if (colorName.equalsIgnoreCase("INVISIBLE")) {
                        block.setVisible(false);
                    }
                    block.setColor(FDSColors.getColor(colorName));
                }
            }
            Boolean thicken = (Boolean)rec.getValue("THICKEN");
            if (thicken != null) {
                block.setIsThickened(thicken);
            }
            if ((permitHole = (Boolean)rec.getValue("PERMIT_HOLE")) != null) {
                block.setPermitsHole(permitHole);
            }
            if ((sawtooth = (Boolean)rec.getValue("SAWTOOTH")) != null) {
                block.setIsSawtoothed(sawtooth);
            }
            boolean usingExisting = (correctBlock = (AlignedBlock)EventParser.getCorrectObject(this.d_allObstructions, block)) != block;
            block = correctBlock;
            String[] activateStrings = new String[]{"T_CREATE"};
            String[] deactivateStrings = new String[]{"T_REMOVE"};
            String heatActivateString = "HEAT_CREATE";
            String heatDeactivateString = "HEAT_REMOVE";
            EventParser.parseEvents(this, block, rec, activateStrings, deactivateStrings, heatActivateString, heatDeactivateString, this.getContainer().getHeatDetectors());
            if (!usingExisting) {
                FDSObject match = (FDSObject)this.d_compositesMap.get(block.getName());
                if (match != null && match.getName().equals(block.getName())) {
                    if (match instanceof FDSComposite) {
                        ((FDSComposite)match).taskAdd(block).run();
                    } else {
                        int index;
                        for (index = 0; index < this.getContainer().getObstructions().size() && this.getContainer().getObstructions().get(index) != match; ++index) {
                        }
                        this.getContainer().getObstructions().taskRemove(index).run();
                        FDSComposite comp = new FDSComposite();
                        comp.taskSetName(match.getName()).run();
                        comp.taskAdd(match).run();
                        comp.taskAdd(block).run();
                        this.getContainer().getObstructions().taskAdd(comp, index).run();
                        this.d_compositesMap.put(match.getName(), comp);
                    }
                } else {
                    this.getContainer().getObstructions().taskAdd(block).run();
                    this.flagPyroTypeAffected(AlignedBlock.class);
                    if (!block.getName().equals("")) {
                        this.d_compositesMap.put(block.getName(), block);
                    }
                }
                this.d_allObstructions.put(block.getPropertyHashString(), block);
            }
        }
        catch (NullPointerException e1) {
            err = true;
        }
        catch (ClassCastException e2) {
            err = true;
        }
        catch (ArrayIndexOutOfBoundsException e3) {
            err = true;
        }
        if (err) {
            throw new FDSRecordFormatException(rec);
        }
        return true;
    }

    @Override
    public void done() {
    }
}

