/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import pyrosim.legacy_2006_2.io.BNDFProcessor;
import pyrosim.legacy_2006_2.io.DatabaseProcessor;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordProcessor;
import pyrosim.legacy_2006_2.io.GridProcessor;
import pyrosim.legacy_2006_2.io.HeadProcessor;
import pyrosim.legacy_2006_2.io.HeatProcessor;
import pyrosim.legacy_2006_2.io.HoleProcessor;
import pyrosim.legacy_2006_2.io.IsofProcessor;
import pyrosim.legacy_2006_2.io.MiscProcessor;
import pyrosim.legacy_2006_2.io.ObstProcessor;
import pyrosim.legacy_2006_2.io.PL3DProcessor;
import pyrosim.legacy_2006_2.io.PartProcessor;
import pyrosim.legacy_2006_2.io.PipeProcessor;
import pyrosim.legacy_2006_2.io.RadiProcessor;
import pyrosim.legacy_2006_2.io.ReacProcessor;
import pyrosim.legacy_2006_2.io.SlcfProcessor;
import pyrosim.legacy_2006_2.io.SmodProcessor;
import pyrosim.legacy_2006_2.io.SprkProcessor;
import pyrosim.legacy_2006_2.io.SurfProcessor;
import pyrosim.legacy_2006_2.io.ThcpProcessor;
import pyrosim.legacy_2006_2.io.TimeProcessor;
import pyrosim.legacy_2006_2.io.VentProcessor;

public class FDSRecordProcessorFactory {
    private static final Map<String, Set<String>> s_fdsTypesDependedOn = new TreeMap<String, Set<String>>();

    public static FDSRecordProcessor getProcessor(String fdsType, FDSParsingInfo parsingInfo) {
        if (fdsType.equals("BNDF")) {
            return new BNDFProcessor(parsingInfo);
        }
        if (fdsType.equals("DATABASE_RECORD")) {
            return new DatabaseProcessor(parsingInfo);
        }
        if (fdsType.equals("GRID")) {
            return new GridProcessor(parsingInfo);
        }
        if (fdsType.equals("HEAD")) {
            return new HeadProcessor(parsingInfo);
        }
        if (fdsType.equals("HEAT")) {
            return new HeatProcessor(parsingInfo);
        }
        if (fdsType.equals("SMOD")) {
            return new SmodProcessor(parsingInfo);
        }
        if (fdsType.equals("HOLE")) {
            return new HoleProcessor(parsingInfo);
        }
        if (fdsType.equals("ISOF")) {
            return new IsofProcessor(parsingInfo);
        }
        if (fdsType.equals("MISC")) {
            return new MiscProcessor(parsingInfo);
        }
        if (fdsType.equals("RADI")) {
            return new RadiProcessor(parsingInfo);
        }
        if (fdsType.equals("OBST")) {
            return new ObstProcessor(parsingInfo);
        }
        if (fdsType.equals("PART")) {
            return new PartProcessor(parsingInfo);
        }
        if (fdsType.equals("PIPE")) {
            return new PipeProcessor(parsingInfo);
        }
        if (fdsType.equals("PL3D")) {
            return new PL3DProcessor(parsingInfo);
        }
        if (fdsType.equals("REAC")) {
            return new ReacProcessor(parsingInfo);
        }
        if (fdsType.equals("SLCF")) {
            return new SlcfProcessor(parsingInfo);
        }
        if (fdsType.equals("SPRK")) {
            return new SprkProcessor(parsingInfo);
        }
        if (fdsType.equals("SURF")) {
            return new SurfProcessor(parsingInfo);
        }
        if (fdsType.equals("THCP")) {
            return new ThcpProcessor(parsingInfo);
        }
        if (fdsType.equals("TIME")) {
            return new TimeProcessor(parsingInfo);
        }
        if (fdsType.equals("VENT")) {
            return new VentProcessor(parsingInfo);
        }
        return null;
    }

    public static Set<String> getFDSTypesDependendedOn(String fdsTypeForProcessor) {
        Set<String> dependededOns = s_fdsTypesDependedOn.get(fdsTypeForProcessor);
        if (dependededOns == null) {
            return new TreeSet<String>();
        }
        return dependededOns;
    }

    public static boolean type1ProcessorDependsOnType2Processor(String fdsType1, String fdsType2) {
        Set<String> directDependedOns = FDSRecordProcessorFactory.getFDSTypesDependendedOn(fdsType1);
        for (String type : directDependedOns) {
            if (fdsType2.equals(type)) {
                return true;
            }
            if (!FDSRecordProcessorFactory.type1ProcessorDependsOnType2Processor(type, fdsType2)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> getDependedOnByAll() {
        TreeSet<String> deps = new TreeSet<String>();
        deps.add("DATABASE_RECORD");
        return deps;
    }

    private static Set<String> getDependedOnByBNDF() {
        Set<String> deps = FDSRecordProcessorFactory.getDependedOnByAll();
        deps.add("MISC");
        return deps;
    }

    private static Set<String> getDependedOnByOBST() {
        Set<String> deps = FDSRecordProcessorFactory.getDependedOnByAll();
        deps.add("SURF");
        deps.add("HEAT");
        deps.add("MISC");
        return deps;
    }

    private static Set<String> getDependedOnByVENT() {
        Set<String> deps = FDSRecordProcessorFactory.getDependedOnByOBST();
        deps.add("GRID");
        return deps;
    }

    private static Set<String> getDependedOnByHOLE() {
        Set<String> deps = FDSRecordProcessorFactory.getDependedOnByAll();
        deps.add("HEAT");
        return deps;
    }

    private static Set<String> getDependedOnBySURF() {
        Set<String> deps = FDSRecordProcessorFactory.getDependedOnByAll();
        deps.add("PART");
        return deps;
    }

    private static Set<String> getDependedOnBySPRK() {
        Set<String> deps = FDSRecordProcessorFactory.getDependedOnByAll();
        deps.add("PART");
        return deps;
    }

    private static Set<String> getDependedOnByMISC() {
        Set<String> deps = FDSRecordProcessorFactory.getDependedOnByAll();
        deps.add("SURF");
        deps.add("REAC");
        return deps;
    }

    static {
        s_fdsTypesDependedOn.put("OBST", FDSRecordProcessorFactory.getDependedOnByOBST());
        s_fdsTypesDependedOn.put("VENT", FDSRecordProcessorFactory.getDependedOnByVENT());
        s_fdsTypesDependedOn.put("HOLE", FDSRecordProcessorFactory.getDependedOnByHOLE());
        s_fdsTypesDependedOn.put("SURF", FDSRecordProcessorFactory.getDependedOnBySURF());
        s_fdsTypesDependedOn.put("SPRK", FDSRecordProcessorFactory.getDependedOnBySPRK());
        s_fdsTypesDependedOn.put("MISC", FDSRecordProcessorFactory.getDependedOnByMISC());
        s_fdsTypesDependedOn.put("BNDF", FDSRecordProcessorFactory.getDependedOnByBNDF());
    }
}

