/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.AAddTask;
import pyrosim.legacy_2006_2.domain.ARemoveTask;
import pyrosim.legacy_2006_2.domain.AbstractActivationEventList;
import pyrosim.legacy_2006_2.domain.ActivationEvent;
import pyrosim.legacy_2006_2.domain.ActivationEventList;
import pyrosim.legacy_2006_2.domain.TimeActivationEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class TimeActivationEventList
extends AbstractActivationEventList
implements ActivationEventList {
    static final long serialVersionUID = 1L;
    private TreeMap<Object, ActivationEvent> d_mEvents = new TreeMap();

    public TimeActivationEventList(Set<PyroMod> domains) {
        super(0, domains);
    }

    private boolean addEvent(ActivationEvent evt) {
        ADomainObject.addDomains(evt, this.getDomains());
        return this.d_mEvents.put(evt.getCriteria(), evt) != null;
    }

    private boolean removeEvent(ActivationEvent evt) {
        ADomainObject.removeDomains(evt, this.getDomains());
        return this.d_mEvents.remove(evt.getCriteria()) != null;
    }

    public Collection getAllEvents() {
        return this.d_mEvents.values();
    }

    @Override
    public int size() {
        return this.d_mEvents.size();
    }

    @Override
    public Collection getInputRecords(FDSInputRecord baseRecord, Map recordMap) {
        Collection events = this.getAllEvents();
        Iterator it = events.iterator();
        Vector<ActivateSequence> actSeqs = new Vector<ActivateSequence>();
        ActivateSequence currentSequence = new ActivateSequence();
        int m = 0;
        while (it.hasNext()) {
            TimeActivationEvent event = (TimeActivationEvent)it.next();
            int action = event.getAction();
            if (action == 0) {
                currentSequence.setActivate(event);
            } else {
                currentSequence.setDeactivate(event);
            }
            if (m == 0 && currentSequence.isFinished() || currentSequence.isComplete() || m == events.size() - 1 && currentSequence.isStarted()) {
                actSeqs.add(currentSequence);
                currentSequence = new ActivateSequence();
            }
            ++m;
        }
        Vector<FDSInputRecord> returnRecords = new Vector<FDSInputRecord>();
        FDSInputRecord record = baseRecord.getValue("T_OPEN") != null || baseRecord.getValue("T_CLOSE") != null || baseRecord.getValue("T_ACTIVATE") != null || baseRecord.getValue("T_DEACTIVATE") != null || baseRecord.getValue("HEAT_ACTIVATE") != null || baseRecord.getValue("HEAT_DEACTIVATE") != null || baseRecord.getValue("T_CREATE") != null || baseRecord.getValue("T_REMOVE") != null || baseRecord.getValue("HEAT_CREATE") != null || baseRecord.getValue("HEAT_REMOVE") != null ? (FDSInputRecord)baseRecord.clone() : baseRecord;
        for (int m2 = 0; m2 < actSeqs.size(); ++m2) {
            ActivateSequence seq = (ActivateSequence)actSeqs.get(m2);
            seq.fillRecord(record, recordMap);
            returnRecords.add(record);
            record = (FDSInputRecord)record.clone();
            record.removeValue("T_OPEN");
            record.removeValue("T_CLOSE");
            record.removeValue("T_ACTIVATE");
            record.removeValue("T_DEACTIVATE");
            record.removeValue("HEAT_ACTIVATE");
            record.removeValue("HEAT_DEACTIVATE");
            record.removeValue("T_CREATE");
            record.removeValue("T_REMOVE");
            record.removeValue("HEAT_CREATE");
            record.removeValue("HEAT_REMOVE");
        }
        return returnRecords;
    }

    @Override
    public Object clone() {
        TimeActivationEventList returnList = (TimeActivationEventList)super.clone();
        returnList.d_mEvents = new TreeMap();
        Collection c = this.getAllEvents();
        for (ActivationEvent evt : c) {
            returnList.addEvent((ActivationEvent)evt.clone());
        }
        return returnList;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TimeActivationEventList)) {
            return false;
        }
        TimeActivationEventList l = (TimeActivationEventList)obj;
        if (l.d_mEvents.size() != this.d_mEvents.size()) {
            return false;
        }
        Iterator<ActivationEvent> it = this.d_mEvents.values().iterator();
        Iterator<ActivationEvent> it2 = l.d_mEvents.values().iterator();
        while (it.hasNext()) {
            if (((Object)it.next()).equals(it2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Task taskRemoveEvent(ActivationEvent evt) {
        return new ARemoveTask<TimeActivationEvent>(this.getDomains(), new VectorFromArray<TimeActivationEvent>((TimeActivationEvent)evt)){

            @Override
            protected boolean remove(TimeActivationEvent obj) {
                return TimeActivationEventList.this.removeEvent(obj);
            }

            @Override
            protected boolean add(TimeActivationEvent obj) {
                return TimeActivationEventList.this.addEvent(obj);
            }
        };
    }

    @Override
    public Task taskAddEvent(ActivationEvent evt) {
        return new AAddTask<TimeActivationEvent>(this.getDomains(), new VectorFromArray<TimeActivationEvent>((TimeActivationEvent)evt)){

            @Override
            protected boolean remove(TimeActivationEvent obj) {
                return TimeActivationEventList.this.removeEvent(obj);
            }

            @Override
            protected boolean add(TimeActivationEvent obj) {
                return TimeActivationEventList.this.addEvent(obj);
            }
        };
    }

    private class ActivateSequence {
        private TimeActivationEvent d_Act = null;
        private TimeActivationEvent d_Deact = null;
        private Unit seconds = SI.SECOND;

        private ActivateSequence() {
        }

        public boolean isFinished() {
            return this.d_Deact != null;
        }

        public boolean isStarted() {
            return this.d_Act != null;
        }

        public boolean isComplete() {
            return this.d_Act != null && this.d_Deact != null;
        }

        public void setActivate(TimeActivationEvent act) {
            if (this.d_Deact != null) {
                double deactTime;
                double actTime = ((UnitDouble)act.getCriteria()).getValue(this.seconds);
                if (actTime < (deactTime = ((UnitDouble)this.d_Deact.getCriteria()).getValue(this.seconds))) {
                    this.d_Act = act;
                } else {
                    this.d_Deact = null;
                    this.d_Act = act;
                }
            } else {
                this.d_Act = act;
            }
        }

        public void setDeactivate(TimeActivationEvent deact) {
            if (this.d_Act != null) {
                double deactTime;
                double actTime = ((UnitDouble)this.d_Act.getCriteria()).getValue(this.seconds);
                if (actTime < (deactTime = ((UnitDouble)deact.getCriteria()).getValue(this.seconds))) {
                    this.d_Deact = deact;
                } else {
                    this.d_Act = null;
                    this.d_Deact = deact;
                }
            } else {
                this.d_Deact = deact;
            }
        }

        public void fillRecord(FDSInputRecord record, Map recordMap) {
            if (this.d_Act != null) {
                record.setValue((String)recordMap.get(this.d_Act.getAction()), ((UnitDouble)this.d_Act.getCriteria()).getValue(this.seconds));
            }
            if (this.d_Deact != null) {
                record.setValue((String)recordMap.get(this.d_Deact.getAction()), ((UnitDouble)this.d_Deact.getCriteria()).getValue(this.seconds));
            }
        }
    }
}

