/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.TransformTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class ScaleTask
extends TransformTask {
    private final UnitPoint3D d_base;
    private final Tuple3d d_scale;

    public ScaleTask(PyroMod mediator, Collection<? extends FDSObject> objects, int mode, int n, UnitPoint3D base, Tuple3d scale) {
        super(mediator, objects, mode, n);
        this.d_base = (UnitPoint3D)base.clone();
        this.d_scale = new Vector3d(scale);
    }

    @Override
    protected Object getXFormForIteration(int i) {
        Transform xform = new Transform();
        xform.d_scale = new Vector3d();
        ((Transform)xform).d_scale.x = Math.pow(this.d_scale.x, i);
        ((Transform)xform).d_scale.y = Math.pow(this.d_scale.y, i);
        ((Transform)xform).d_scale.z = Math.pow(this.d_scale.z, i);
        return xform;
    }

    @Override
    protected Task taskTransformObject(FDSObject o, Object xform) {
        assert (xform instanceof Transform);
        return o.taskScaleObject(this.d_base, ((Transform)xform).d_scale);
    }

    private static class Transform {
        private Tuple3d d_scale;

        private Transform() {
        }
    }
}

