/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AMakeUniqueNameTask;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.APyroManReplaceTask;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.FDSObjectIterator;
import pyrosim.legacy_2006_2.domain.Floor;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.events.FloorDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class FloorManager
extends APyroDomainManager<String, Floor> {
    private Hashtable<String, Floor> d_floors;

    public FloorManager(PyroMod mod) {
    }

    public void setFloors(Hashtable<String, Floor> floors) {
        this.d_floors = floors;
    }

    public Task taskAddDefaultFloor() {
        Floor f = new Floor("Default", 0.0, 3.0, SI.METER, null);
        return this.taskAdd(f);
    }

    public Task taskAddFloorFromObst(final Collection<? extends FDSObject> obsts) {
        return new CompositeTask<PyroMod>(this.getDomains()){

            @Override
            protected void queueBeginRuntimeTasks() {
                UnitPoint3D min = FDSComposite.getMinPoint(new FDSObjectIterator(obsts, false));
                UnitPoint3D max = FDSComposite.getMaxPoint(new FDSObjectIterator(obsts, false));
                Floor newFloor = new Floor("Floor", min.zu(), max.zu(), null);
                this.addTask(FloorManager.this.taskMakeUnique(newFloor));
                this.addTask(FloorManager.this.taskAdd(newFloor));
            }
        };
    }

    @Override
    protected boolean add(Floor floor) {
        if (this.d_floors.containsKey(floor.getName())) {
            return false;
        }
        this.d_floors.put(floor.getName(), floor);
        super.add(floor);
        this.fireDomainEvent(new FloorDomainEvent(this, floor, 3));
        return true;
    }

    @Override
    protected boolean remove(Floor floor) {
        Floor existing = this.d_floors.remove(floor.getName());
        if (existing == null) {
            return false;
        }
        super.remove(existing);
        this.fireDomainEvent(new FloorDomainEvent(this, floor, 4));
        return true;
    }

    @Override
    public Task taskAddAll(Collection<? extends Floor> pyroObjects) {
        return new APyroManAddTask<String, Floor>((IPyroManager)this, pyroObjects){

            @Override
            public boolean add(Floor obj) {
                return FloorManager.this.add(obj);
            }

            @Override
            public boolean remove(Floor obj) {
                return FloorManager.this.remove(obj);
            }
        };
    }

    @Override
    public Task taskRemoveAll(List<Floor> pyroObjects, List<Floor> replacements) {
        return new APyroManReplaceTask<String, Floor>((IPyroManager)this, pyroObjects, replacements){

            @Override
            public boolean add(Floor obj) {
                return FloorManager.this.add(obj);
            }

            @Override
            public boolean remove(Floor obj) {
                return FloorManager.this.remove(obj);
            }
        };
    }

    @Override
    public boolean contains(String key) {
        return this.get(key) != null;
    }

    @Override
    public Floor get(String key) {
        return this.d_floors.get(key);
    }

    @Override
    public Floor get(Floor pyroObject) {
        return this.get(pyroObject.getName());
    }

    @Override
    public boolean canMakeUnique(Floor pyroObject) {
        return true;
    }

    @Override
    public Task taskMakeUnique(Floor pyroObject) {
        return new AMakeUniqueNameTask<Floor>(this.getDomains(), pyroObject){

            @Override
            protected Task taskMakeUnique(Floor obj) {
                return obj.taskSetName(APyroDomainManager.getUniqueName(FloorManager.this, obj.getName()));
            }
        };
    }

    @Override
    public String describeObject(Floor pyroObject) {
        return pyroObject.getName();
    }

    @Override
    public int size() {
        return this.d_floors.size();
    }

    @Override
    public boolean isEmpty() {
        return this.d_floors.isEmpty();
    }

    public Floor[] toArray() {
        return this.d_floors.values().toArray(new Floor[this.size()]);
    }

    public Floor[] toArray(Floor[] array) {
        return this.d_floors.values().toArray(array);
    }

    @Override
    public Class<Floor> getVClass() {
        return Floor.class;
    }

    @Override
    public Class<String> getKClass() {
        return String.class;
    }

    @Override
    public Collection<? extends Floor> toCollection() {
        return this.d_floors.values();
    }

    @Override
    public Iterator<Floor> iterator() {
        return this.d_floors.values().iterator();
    }
}

