/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import pyrosim.legacy_2006_2.thunderheadeng.gui.Mediator;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public abstract class AAddTask<E>
implements Task {
    private final Set<? extends Mediator> d_mediators;
    private final Collection<E> d_toAdd;
    private final Collection<E> d_actuallyAdded;

    protected abstract boolean remove(E var1);

    protected abstract boolean add(E var1);

    public AAddTask(Set<? extends Mediator> mediators, Collection<E> toAdd) {
        this.d_toAdd = new ArrayList<E>(toAdd);
        this.d_actuallyAdded = new ArrayList(toAdd.size());
        this.d_mediators = mediators;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public int getEst() {
        return 0;
    }

    @Override
    public void undo() {
        this.pauseUpdates();
        for (E obj : this.d_actuallyAdded) {
            this.remove(obj);
        }
        this.d_actuallyAdded.clear();
        this.resumeUpdates();
    }

    @Override
    public void run() {
        this.pauseUpdates();
        for (E obj : this.d_toAdd) {
            if (!this.add(obj)) continue;
            this.d_actuallyAdded.add(obj);
        }
        this.resumeUpdates();
    }

    private void pauseUpdates() {
        if (this.d_mediators != null) {
            for (Mediator mediator : this.d_mediators) {
                mediator.pauseUpdates();
            }
        }
    }

    private void resumeUpdates() {
        if (this.d_mediators != null) {
            for (Mediator mediator : this.d_mediators) {
                mediator.resumeUpdates();
            }
        }
    }
}

