/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2;

import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class UnitPoint3D
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private double x;
    private double y;
    private double z;
    private Unit d_unit;

    public UnitPoint3D(Unit unit) {
        this.d_unit = unit;
    }

    public UnitPoint3D(double x, double y, double z, Unit unit) {
        this.set(x, y, z, unit);
    }

    public UnitPoint3D(double[] data, Unit unit) {
        assert (data.length >= 3);
        this.x = data[0];
        this.y = data[1];
        this.z = data[2];
        this.d_unit = unit;
    }

    public UnitPoint3D(Point3D point, Unit u) {
        this.set(point.x, point.y, point.z, u);
    }

    public UnitPoint3D(Tuple3d vec, Unit unit) {
        this.set(vec.x, vec.y, vec.z, unit);
    }

    public void set(double x, double y, double z, Unit unit) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.d_unit = unit;
    }

    public static UnitPoint3D fromLegacy(pyrosim.legacy_2006_2.legacy.v17.UnitPoint3D p) {
        Unit u = p.x.getUnit();
        if (u == null && (u = p.y.getUnit()) == null && (u = p.z.getUnit()) == null) {
            u = SI.METER;
        }
        double newx = p.x.getValue(u);
        double newy = p.y.getValue(u);
        double newz = p.z.getValue(u);
        return new UnitPoint3D(newx, newy, newz, u);
    }

    public Point3D getValue(Unit desiredUnit) {
        assert (this.d_unit != null);
        if (desiredUnit.equals(this.d_unit)) {
            return new Point3D(this.x, this.y, this.z);
        }
        return new Point3D(UnitDouble.convert(this.x, this.d_unit, desiredUnit), UnitDouble.convert(this.y, this.d_unit, desiredUnit), UnitDouble.convert(this.z, this.d_unit, desiredUnit));
    }

    public Point3d getPoint3dValue(Unit desiredUnit) {
        assert (this.d_unit != null);
        if (desiredUnit.equals(this.d_unit)) {
            return new Point3d(this.x, this.y, this.z);
        }
        return new Point3d(UnitDouble.convert(this.x, this.d_unit, desiredUnit), UnitDouble.convert(this.y, this.d_unit, desiredUnit), UnitDouble.convert(this.z, this.d_unit, desiredUnit));
    }

    public Vector3d getVector3dValue(Unit desiredUnit) {
        assert (this.d_unit != null);
        if (desiredUnit.equals(this.d_unit)) {
            return new Vector3d(this.x, this.y, this.z);
        }
        return new Vector3d(UnitDouble.convert(this.x, this.d_unit, desiredUnit), UnitDouble.convert(this.y, this.d_unit, desiredUnit), UnitDouble.convert(this.z, this.d_unit, desiredUnit));
    }

    public void getData(double[] data, Unit desiredUnit) {
        assert (data.length >= 3);
        data[0] = this.x(desiredUnit);
        data[1] = this.y(desiredUnit);
        data[2] = this.z(desiredUnit);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    public UnitDouble xu() {
        return new UnitDouble(this.x, this.d_unit);
    }

    public UnitDouble yu() {
        return new UnitDouble(this.y, this.d_unit);
    }

    public UnitDouble zu() {
        return new UnitDouble(this.z, this.d_unit);
    }

    public double x(Unit desiredUnit) {
        return UnitDouble.convert(this.x, this.d_unit, desiredUnit);
    }

    public double y(Unit desiredUnit) {
        return UnitDouble.convert(this.y, this.d_unit, desiredUnit);
    }

    public double z(Unit desiredUnit) {
        return UnitDouble.convert(this.z, this.d_unit, desiredUnit);
    }

    public void setX(UnitDouble x) {
        this.x = x.getValue(this.d_unit);
    }

    public void setY(UnitDouble y) {
        this.y = y.getValue(this.d_unit);
    }

    public void setZ(UnitDouble z) {
        this.z = z.getValue(this.d_unit);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public Unit getUnit() {
        return this.d_unit;
    }

    public void setUnit(Unit u) {
        this.d_unit = u;
    }

    public void add(UnitPoint3D p) {
        this.x += p.x(this.d_unit);
        this.y += p.y(this.d_unit);
        this.z += p.z(this.d_unit);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UnitPoint3D)) {
            return false;
        }
        UnitPoint3D p = (UnitPoint3D)obj;
        if (this.d_unit.equals(p.d_unit)) {
            return this.x == p.x && this.y == p.y && this.z == p.z;
        }
        return this.xu().equals(p.xu()) && this.yu().equals(p.yu()) && this.zu().equals(p.zu());
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ") " + this.d_unit;
    }
}

