/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy.v131.domain.boundcond.surf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import pyrosim.domain.TimeFunction;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class TempRegulation
implements Serializable {
    static final long serialVersionUID = 1L;
    public final UnitDouble d_netHeatFlux;
    public final UnitDouble d_temperature;
    public final UnitDouble d_heatFlux;
    public final TimeFunction d_rampup;
    public final double d_emissivity;
    public final UnitDouble d_htCoef;
    public final ThermalBCs d_thermalBCs;
    public final boolean d_logarithmic;
    public final boolean d_calculatedTemp;

    private TempRegulation(ThermalBCs boundaryConds, UnitDouble htCoef, boolean log, boolean calculatedTemp) {
        this.d_thermalBCs = boundaryConds;
        this.d_htCoef = htCoef;
        this.d_logarithmic = log;
        this.d_calculatedTemp = calculatedTemp;
        this.d_netHeatFlux = null;
        this.d_temperature = null;
        this.d_heatFlux = null;
        this.d_rampup = null;
        this.d_emissivity = 0.0;
    }

    public static TempRegulation newNetHeatFluxTR(UnitDouble netHeatFlux, double emissivity, UnitDouble htCoef, boolean log) {
        return new TempRegulation(new ThermalBCs(netHeatFlux, null, null, null, emissivity, TempRegulation.getDefaultAdiabatic()), htCoef, log, TempRegulation.getDefaultCalculatedTemp());
    }

    public static TempRegulation newFixedHeatFluxTR(UnitDouble temperature, UnitDouble heatFlux, TimeFunction rampup, double emissivity, UnitDouble htCoef, boolean log) {
        return new TempRegulation(new ThermalBCs(null, temperature, heatFlux, rampup, emissivity, TempRegulation.getDefaultAdiabatic()), htCoef, log, TempRegulation.getDefaultCalculatedTemp());
    }

    public static TempRegulation newFixedTempTR(UnitDouble temperature, double emissivity, UnitDouble htCoef, boolean log) {
        return new TempRegulation(new ThermalBCs(null, temperature, null, null, emissivity, TempRegulation.getDefaultAdiabatic()), htCoef, log, TempRegulation.getDefaultCalculatedTemp());
    }

    public static TempRegulation newCalcTempTR(double emissivity, UnitDouble htCoef, boolean log) {
        return new TempRegulation(new ThermalBCs(null, null, null, null, emissivity, TempRegulation.getDefaultAdiabatic()), htCoef, log, true);
    }

    public static TempRegulation newDefault() {
        return new TempRegulation(new ThermalBCs(null, null, null, null, TempRegulation.getDefaultEmissivity(), TempRegulation.getDefaultAdiabatic()), TempRegulation.getDefaultHtCoef(), TempRegulation.getDefaultLog(), TempRegulation.getDefaultCalculatedTemp());
    }

    public static TempRegulation newAdiabaticTR(UnitDouble htCoef, boolean log) {
        return new TempRegulation(new ThermalBCs(null, null, null, null, 1.0, true), htCoef, log, TempRegulation.getDefaultCalculatedTemp());
    }

    public static double getDefaultEmissivity() {
        return 0.9;
    }

    public static UnitDouble getDefaultHtCoef() {
        return null;
    }

    public static boolean getDefaultLog() {
        return false;
    }

    public static boolean getDefaultAdiabatic() {
        return false;
    }

    public static boolean getDefaultCalculatedTemp() {
        return false;
    }

    public static TempRegulation legacyDefaultTR() {
        return new TempRegulation(new ThermalBCs(null, null, SIUS.newud(0.0, 33), TimeFunction.newDefault(), 0.9, false), null, false, false);
    }

    public boolean isNetHeatFluxTR() {
        return this.d_thermalBCs.d_netHeatFlux != null;
    }

    public boolean isAdiabaticTR() {
        return this.d_thermalBCs.d_adiabatic;
    }

    public boolean isFixedTempTR() {
        return !this.isNetHeatFluxTR() && !this.isAdiabaticTR() && !this.isGrossFluxTR() && !this.isCalcTempTR();
    }

    public boolean isCalcTempTR() {
        return this.d_calculatedTemp;
    }

    public boolean isGrossFluxTR() {
        return this.d_thermalBCs.d_heatFlux != null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TempRegulation)) {
            return false;
        }
        TempRegulation reg = (TempRegulation)obj;
        return theUtil.equal(this.d_htCoef, reg.d_htCoef) && this.d_logarithmic == reg.d_logarithmic && this.d_thermalBCs.equals(reg.d_thermalBCs);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        UnitDouble heatFlux = this.d_heatFlux;
        if (in instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)in).getVersion() < 63 && this.d_heatFlux.getValueNoUnit() == 0.0) {
            heatFlux = null;
        }
        if (this.d_thermalBCs == null) {
            try {
                Util.assignFinalField(this, "d_thermalBCs", new ThermalBCs(this.d_netHeatFlux, this.d_temperature, heatFlux, this.d_rampup, this.d_emissivity, false));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.isAdiabaticTR()) {
            return pyrosim.domain.boundcond.surf.TempRegulation.newAdiabaticTR(this.d_htCoef, this.d_logarithmic);
        }
        if (this.isCalcTempTR()) {
            return pyrosim.domain.boundcond.surf.TempRegulation.newCalcTempTR(this.d_thermalBCs.d_emissivity, this.d_htCoef, this.d_logarithmic);
        }
        if (this.isFixedTempTR()) {
            return pyrosim.domain.boundcond.surf.TempRegulation.newFixedTempTR(this.d_thermalBCs.d_temperature, TimeFunction.newDefault(), this.d_thermalBCs.d_emissivity, this.d_htCoef, this.d_logarithmic);
        }
        if (this.isGrossFluxTR()) {
            TimeFunction convFunction;
            TimeFunction tempFunction;
            if (this.d_thermalBCs.d_heatFlux.getValueNoUnit() > 0.0) {
                tempFunction = TimeFunction.newDefault();
                convFunction = this.d_thermalBCs.d_rampup;
            } else {
                tempFunction = this.d_thermalBCs.d_rampup;
                convFunction = TimeFunction.newDefault();
            }
            return pyrosim.domain.boundcond.surf.TempRegulation.newFixedHeatFluxTR(this.d_thermalBCs.d_temperature, tempFunction, this.d_thermalBCs.d_heatFlux, convFunction, this.d_thermalBCs.d_emissivity, this.d_htCoef, this.d_logarithmic);
        }
        if (this.isNetHeatFluxTR()) {
            return pyrosim.domain.boundcond.surf.TempRegulation.newNetHeatFluxTR(this.d_thermalBCs.d_netHeatFlux, TimeFunction.newDefault(), this.d_thermalBCs.d_emissivity, this.d_htCoef, this.d_logarithmic);
        }
        assert (false);
        return null;
    }

    public static class ThermalBCs
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_temperature;
        public final UnitDouble d_heatFlux;
        public final UnitDouble d_netHeatFlux;
        public final double d_emissivity;
        public final TimeFunction d_rampup;
        public final boolean d_adiabatic;

        public ThermalBCs(UnitDouble netHeatFlux, UnitDouble temperature, UnitDouble heatFlux, TimeFunction rampup, double emissivity, boolean adiabatic) {
            this.d_temperature = temperature;
            this.d_heatFlux = heatFlux;
            this.d_netHeatFlux = netHeatFlux;
            this.d_emissivity = emissivity;
            this.d_rampup = rampup;
            this.d_adiabatic = adiabatic;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + theUtil.hashCode(this.d_temperature);
            hash = 31 * hash + theUtil.hashCode(this.d_heatFlux);
            hash = 31 * hash + theUtil.hashCode(this.d_netHeatFlux);
            hash = 31 * hash + theUtil.hashCode(this.d_rampup);
            hash = 31 * hash + theUtil.hashCode(this.d_emissivity);
            hash = 31 * hash + theUtil.hashCode(this.d_adiabatic);
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ThermalBCs)) {
                return false;
            }
            ThermalBCs bc = (ThermalBCs)obj;
            return theUtil.equal(this.d_temperature, bc.d_temperature) && theUtil.equal(this.d_heatFlux, bc.d_heatFlux) && theUtil.equal(this.d_netHeatFlux, bc.d_netHeatFlux) && theUtil.equal(this.d_rampup, bc.d_rampup) && this.d_emissivity == bc.d_emissivity && this.d_adiabatic == bc.d_adiabatic;
        }
    }
}

