/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.pyrosimV5V6;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitLineSeg3D;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.geometry.objs.BGImageXform;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Global;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;

public class ConvertUtil {
    public static thunderheadeng.units.UnitDouble c(WarningReport<? super Warning> warnings, String fieldDesc, int unitType, UnitDouble v) {
        if (v == null) {
            return null;
        }
        thunderheadeng.units.UnitDouble cVal = ConvertUtil.c(v);
        if (thunderheadeng.units.UnitDouble.areCompatible(SIUS.unit(unitType), v.getUnit())) {
            return cVal;
        }
        thunderheadeng.units.UnitDouble newCVal = SIUS.newud(v.getValueNoUnit(), unitType);
        if (cVal.getValueNoUnit() != 0.0) {
            String msg = String.format(Intl.intl("%1$s stored in wrong unit type."), fieldDesc);
            String action = String.format(Intl.intl("Value changed from \"%1$s\" to \"%2$s.\""), Global.format(cVal), Global.format(newCVal));
            warnings.addWarning(new Warning(msg, action));
        }
        return newCVal;
    }

    public static thunderheadeng.units.UnitDouble c(UnitDouble v) {
        if (v == null) {
            return null;
        }
        return new thunderheadeng.units.UnitDouble(v.getValueNoUnit(), v.getUnit());
    }

    public static UnitPoint3D c(pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D v) {
        if (v == null) {
            return null;
        }
        return v.fromLegacy(null);
    }

    public static SortedSet<thunderheadeng.units.UnitDouble> c(SortedSet<UnitDouble> v) {
        if (v == null) {
            return null;
        }
        return ConvertUtil.convert(new TreeSet(), v);
    }

    public static List<thunderheadeng.units.UnitDouble> c(Collection<UnitDouble> v) {
        if (v == null) {
            return null;
        }
        return ConvertUtil.convert(new ArrayList(v.size()), v);
    }

    public static <T extends Collection<thunderheadeng.units.UnitDouble>> T convert(T result, Collection<UnitDouble> v) {
        for (UnitDouble ud : v) {
            result.add((thunderheadeng.units.UnitDouble)ConvertUtil.c(ud));
        }
        return result;
    }

    public static thunderheadeng.units.UnitDouble[] c(UnitDouble[] v) {
        if (v == null) {
            return null;
        }
        thunderheadeng.units.UnitDouble[] result = new thunderheadeng.units.UnitDouble[v.length];
        for (int m = 0; m < v.length; ++m) {
            result[m] = ConvertUtil.c(v[m]);
        }
        return result;
    }

    public static thunderheadeng.units.UnitAABox c(UnitAABox v) {
        if (v == null) {
            return null;
        }
        return new thunderheadeng.units.UnitAABox(v.minx, v.miny, v.minz, v.maxx, v.maxy, v.maxz, v.unit);
    }

    public static BGImageXform c(pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BGImageXform v) {
        if (v == null) {
            return null;
        }
        return new BGImageXform(v.anchorImage, v.anchorModel, v.aImage, v.bImage, v.distABModel, v.abAngle);
    }

    public static thunderheadeng.units.UnitLineSeg3D c(UnitLineSeg3D v) {
        if (v == null) {
            return null;
        }
        return new thunderheadeng.units.UnitLineSeg3D(v.p1x, v.p1y, v.p1z, v.p2x, v.p2y, v.p2z, v.unit);
    }
}

