/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.zones.Leak;
import pyrosim.domain.zones.Zone;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Lists;

public class ZoneRenderer
extends AFDS6Renderer {
    private Map<Zone, Integer> d_zoneIxes = new IdentityHashMap<Zone, Integer>();
    private Set<Leak> d_renderedLeaks = new HashSet<Leak>();
    private Map<Zone, List<Leak>> d_leaks = new IdentityHashMap<Zone, List<Leak>>();

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Zone.class);
        types.add(Leak.class);
    }

    public Integer indexOf(Zone zone) {
        if (zone.isOuter()) {
            return 0;
        }
        return this.d_zoneIxes.get(zone);
    }

    private void mapZoneLeak(Zone zone, Leak leak) {
        List<Leak> zoneLeaks = this.d_leaks.get(zone);
        if (zoneLeaks == null) {
            zoneLeaks = new ArrayList<Leak>();
            this.d_leaks.put(zone, zoneLeaks);
        }
        zoneLeaks.add(leak);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, Collection<? extends IPyroObject> objs) {
        for (IPyroObject iPyroObject : objs) {
            Zone zone;
            if (iPyroObject instanceof Leak) {
                Leak leak = (Leak)iPyroObject;
                this.mapZoneLeak(leak.zone1, leak);
                this.mapZoneLeak(leak.zone2, leak);
                continue;
            }
            if (!(iPyroObject instanceof Zone) || (zone = (Zone)iPyroObject).isOuter()) continue;
            this.d_zoneIxes.put(zone, this.d_zoneIxes.size() + 1);
        }
        return super.render(props, objs);
    }

    @Override
    protected boolean render(IFDSRecordRenderer props, IPyroObject obj) {
        if (obj instanceof Leak) {
            return true;
        }
        if (!(obj instanceof Zone) || ((Zone)obj).isOuter()) {
            return false;
        }
        Zone zone = (Zone)obj;
        FDSRenderRecord rec = FDS6Const.newRenderRecord("ZONE");
        rec.setValue("ID", zone.getName());
        UnitPoint3D xyzPoint = new UnitPoint3D(zone.getLocation().loc, Geometry.LU);
        FDSArray<UnitDouble> xyzArray = new FDSArray<UnitDouble>(new int[]{3, 8});
        xyzArray.set(xyzPoint.xu(), new int[]{0, 0});
        xyzArray.set(xyzPoint.yu(), new int[]{1, 0});
        xyzArray.set(xyzPoint.zu(), new int[]{2, 0});
        rec.setValue("XYZ", xyzArray);
        List<Object> leakAreas = Lists.filled(this.d_zoneIxes.size() + 1, null);
        List<Leak> leaks = this.d_leaks.get(zone);
        if (leaks != null) {
            for (Leak leak : leaks) {
                Zone otherZone;
                Integer otherix;
                if (!this.d_renderedLeaks.add(leak) || (otherix = this.indexOf(otherZone = leak.otherZone(zone))) == null) continue;
                leakAreas.set(otherix, leak.area);
            }
        }
        rec.setValue("LEAK_AREA", leakAreas, false);
        props.render(rec, obj);
        return true;
    }
}

