/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.Set;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.Slice;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.QuantityMap;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import thunderheadeng.units.UnitAABox;

public class SliceRenderer
extends AFDS6Renderer {
    private final QuantityMap d_quantityMap;

    public SliceRenderer(QuantityMap mmap) {
        this.d_quantityMap = mmap;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Slice.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        Slice obj = (Slice)o;
        FDSRenderRecord rec = FDS6Const.newRenderRecord("SLCF");
        this.d_quantityMap.renderQuantity(rec, "QUANTITY", "PART_ID", "SPEC_ID", null, null, null, obj.getQuantity());
        rec.setValue("VECTOR", obj.includeFlowVector(), false);
        rec.setValue("CELL_CENTERED", obj.isCellCentered(), false);
        if (obj instanceof PlanarSlice) {
            String planeName;
            PlanarSlice pslice = (PlanarSlice)obj;
            switch (pslice.getPlane()) {
                case 0: {
                    planeName = "PBX";
                    break;
                }
                case 1: {
                    planeName = "PBY";
                    break;
                }
                case 2: {
                    planeName = "PBZ";
                    break;
                }
                default: {
                    assert (false);
                    planeName = "";
                }
            }
            rec.setValue(planeName, pslice.getLocation());
        } else if (obj instanceof VolumeSlice) {
            VolumeSlice vslice = (VolumeSlice)obj;
            UnitAABox box = GeomUtil.getUnitBounds(vslice);
            SliceRenderer.renderXB(rec, "XB", box.getMin(), box.getMax());
            rec.setValue("FYI", vslice.getName());
        }
        props.render(rec, o);
        return true;
    }
}

