/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.output.ProfRec;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.QuantityMap;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.MaterialRenderer;

public class ProfRenderer
extends AFDS6Renderer {
    private final QuantityMap d_mmap;
    private final MaterialRenderer d_matRenderer;

    public ProfRenderer(QuantityMap mmap, MaterialRenderer matRenderer) {
        this.d_mmap = mmap;
        this.d_matRenderer = matRenderer;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(ProfRec.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        Object mobj;
        ProfRec obj = (ProfRec)o;
        FDSRenderRecord rec = FDS6Const.newRenderRecord("PROF");
        IQuantity measure = obj.getQuantity();
        if (measure instanceof ObjectQuantity && (mobj = ((ObjectQuantity)measure).objects[0]) instanceof Material && !this.d_matRenderer.wasRendered((Material)mobj)) {
            return false;
        }
        rec.setValue("ID", obj.getName());
        ProfRenderer.renderLoc(rec, "XYZ", obj.getPoint());
        rec.setValue("IOR", obj.getIOR());
        this.d_mmap.renderQuantity(rec, "QUANTITY", null, null, null, null, null, measure);
        props.render(rec, o);
        return true;
    }
}

