/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.MathOps.AMathOp;
import pyrosim.domain.controls.MathOps.ConstantMathSource;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;

public class PinConnectionRenderer
extends AFDS6Renderer {
    public static final String CONST_SOURCE = "CONSTANT";
    private final FDSNameMap d_nameMap;
    private final Map<IOutPin, OutputRetrieval> d_outPinMap = new HashMap<IOutPin, OutputRetrieval>();
    private final List<InputRetrieval> d_inPinRetrievals = new ArrayList<InputRetrieval>();

    public PinConnectionRenderer(FDSNameMap nameMap) {
        this.d_nameMap = nameMap;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(IPyroObject.class);
    }

    @Override
    public boolean markDependency(DepSnapshot deps, IPyroObject obj, boolean renderExplicit) {
        return renderExplicit;
    }

    @Override
    public boolean render(IFDSRecordRenderer props, Collection<? extends IPyroObject> objs) {
        return this.renderConnections(props, null);
    }

    public Pair<FDSRenderRecord, Boolean> generateRecord(String recType, String idKey, IOutPin ... outPins) {
        return this.generateRecord(recType, idKey, false, outPins);
    }

    public Pair<FDSRenderRecord, Boolean> generateRecord(String recType, String idKey, boolean forcePinNames, IOutPin ... outPins) {
        String id;
        assert (recType.equals("CTRL") || recType.equals("DEVC") || recType.equals(CONST_SOURCE));
        assert (outPins.length > 0);
        OutputRetrieval ret = this.d_outPinMap.get(outPins[0]);
        if (ret != null) {
            return new Pair<FDSRenderRecord, Boolean>(ret.rec, false);
        }
        ISignalSource source = outPins[0].getAttachedSource();
        FDSRenderRecord rec = null;
        if (source instanceof ConstantMathSource) {
            id = CONST_SOURCE;
        } else if (source instanceof AMathOp) {
            id = this.d_nameMap.generateName(recType, ((AMathOp)source).getName());
            rec = FDS6Const.newRenderRecord(recType);
            rec.setValue(idKey, id);
        } else {
            String baseName = PinConnectionRenderer.getOutPinName(outPins, recType, forcePinNames);
            id = this.d_nameMap.generateName(recType, baseName);
            rec = FDS6Const.newRenderRecord(recType);
            rec.setValue(idKey, id);
        }
        ret = new OutputRetrieval(rec, recType, id);
        for (IOutPin pin : outPins) {
            assert (pin.getAttachedSource() == source);
            this.d_outPinMap.put(pin, ret);
        }
        return new Pair<FDSRenderRecord, Boolean>(rec, true);
    }

    public String getID(IOutPin outPin) {
        if (this.d_outPinMap.containsKey(outPin)) {
            return this.d_outPinMap.get((Object)outPin).id;
        }
        return null;
    }

    public void markForInputRetrieval(IInPin pin, FDSRenderRecord rec, String ctrlInputKey, String devcInputKey) {
        this.d_inPinRetrievals.add(new InputRetrieval(pin, rec, ctrlInputKey, devcInputKey));
    }

    public boolean renderConnections(IFDSRecordRenderer props, IPyroObject src) {
        for (InputRetrieval output : this.d_inPinRetrievals) {
            List<OutputRetrieval> inputs = this.getConnectedPinRecords(output.pin);
            if (inputs.size() > 1) {
                assert (output.ctrlInputKey.equals(output.devcInputKey));
                List<String> inputIDs = this.getConnectedIDs(inputs);
                output.rec.setValue(output.ctrlInputKey, inputIDs);
            } else if (inputs.size() == 1) {
                OutputRetrieval input = inputs.iterator().next();
                String inputIDKey = input.recType.equals("CTRL") ? output.ctrlInputKey : output.devcInputKey;
                Object value = output.rec.getSpec().fields.get(inputIDKey) instanceof FDSRecordSpec.ListFld ? Arrays.asList(input.id) : input.id;
                output.rec.setValue(inputIDKey, value);
            }
            IPyroObject rendSrc = src == null ? output.pin.getAttachedSink() : src;
            props.render(output.rec, rendSrc);
        }
        boolean rendered = !this.d_inPinRetrievals.isEmpty();
        this.d_inPinRetrievals.clear();
        return rendered;
    }

    private List<String> getConnectedIDs(List<OutputRetrieval> connections) {
        LinkedHashSet<String> ids = new LinkedHashSet<String>(connections.size());
        for (OutputRetrieval ret : connections) {
            ids.add(ret.id);
        }
        return new ArrayList<String>(ids);
    }

    private List<OutputRetrieval> getConnectedPinRecords(IInPin inPin) {
        Set<IOutPin> finalInputs = PinConnectionRenderer.finalizeInputs(inPin);
        ArrayList<OutputRetrieval> retrievals = new ArrayList<OutputRetrieval>(finalInputs.size());
        for (IOutPin pin : finalInputs) {
            OutputRetrieval rec = this.d_outPinMap.get(pin);
            if (rec == null) continue;
            retrievals.add(rec);
        }
        return retrievals;
    }

    public static Set<IOutPin> finalizeInputs(IInPin inPin) {
        LinkedIdentityHashSet<IOutPin> outputs = new LinkedIdentityHashSet<IOutPin>();
        PinConnectionRenderer.finalizeInputs(inPin, outputs);
        return outputs;
    }

    public static void finalizeInputs(IInPin inPin, Set<IOutPin> outputs) {
        Set<? extends IOutPin> connections = inPin.getConnections();
        for (IOutPin iOutPin : connections) {
            if (iOutPin.getAttachedSource() instanceof IControl && ((IControl)iOutPin.getAttachedSource()).isWire()) {
                IControl ctrl = (IControl)iOutPin.getAttachedSource();
                boolean compatible = false;
                for (IOutPin iOutPin2 : ctrl.getInputPin().getConnections()) {
                    if (!inPin.isCompatible(iOutPin2)) continue;
                    compatible = true;
                    break;
                }
                if (!compatible) continue;
                PinConnectionRenderer.finalizeInputs(ctrl.getInputPin(), outputs);
                continue;
            }
            outputs.add(iOutPin);
        }
    }

    public static String getOutPinName(IOutPin[] pins, String recType, boolean forcePinName) {
        String name;
        ISignalSource source = pins[0].getAttachedSource();
        name = source instanceof INamed ? (name = ((INamed)((Object)source)).getName()) : recType;
        List<? extends IOutPin> allOutPins = source.getOutputPins();
        if (allOutPins.size() > pins.length || forcePinName) {
            name = name + "->" + pins[0].getName();
        }
        return name;
    }

    private static class InputRetrieval {
        public final IInPin pin;
        public final FDSRenderRecord rec;
        public final String ctrlInputKey;
        public final String devcInputKey;

        public InputRetrieval(IInPin pin, FDSRenderRecord rec, String ctrlInputKey, String devcInputKey) {
            this.pin = pin;
            this.rec = rec;
            this.ctrlInputKey = ctrlInputKey;
            this.devcInputKey = devcInputKey;
        }
    }

    private static class OutputRetrieval {
        public final FDSRenderRecord rec;
        public final String recType;
        public final String id;

        public OutputRetrieval(FDSRenderRecord rec, String recType, String id) {
            this.rec = rec;
            this.recType = recType;
            this.id = id;
        }
    }
}

