/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.output.AMsrStat;
import pyrosim.domain.output.GasMsrStat;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.SolidMsrStat;
import pyrosim.domain.output.StatGeom;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.StatisticsUtil;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.common.StatisticMap;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.DeviceParser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class StatisticsParser
extends AFDS6Parser {
    private Map<StatHash, Set<Long>> d_solidStatMap = new LinkedHashMap<StatHash, Set<Long>>();
    private Map<StatHash, Set<Long>> d_gasStatMap = new LinkedHashMap<StatHash, Set<Long>>();

    public StatisticsParser(FDS6ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("DEVC");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        DeviceParser.getUnsupported(type, unsupportedFields);
        unsupportedFields.put("SURF_ID", "UNSUPPORTED");
    }

    private Long processSpatialStatistic(FDSParseRecord rec) {
        String spatialStatistic = (String)rec.get("SPATIAL_STATISTIC", false);
        if (spatialStatistic == null) {
            return null;
        }
        if (StatisticMap.getPyroVal_spatial(spatialStatistic) == null) {
            this.addWarning(rec, String.format(Intl.intl("%s statistics are not yet supported."), spatialStatistic), Intl.intl("Adding statistic to additional records section."));
            return null;
        }
        if (this.is2dAs3d(rec)) {
            spatialStatistic = StatisticMap.getVolumeForArea(spatialStatistic);
        }
        return StatisticMap.getPyroVal_spatial(spatialStatistic);
    }

    private boolean is2dAs3d(FDSParseRecord rec) {
        if (rec.getString("SPATIAL_STATISTIC", true).equals("SURFACE INTEGRAL") && rec.contains("XB")) {
            try {
                UnitPoint3D[] bounds = StatisticsParser.parseXB(rec, Intl.intl("Gas-phase statistics"), "XB", true);
                if (this.toRect(bounds) == null) {
                    return true;
                }
            }
            catch (FDSRecordFormatException e) {
                return false;
            }
        }
        return false;
    }

    private Long processTemporalStatistic(FDSParseRecord rec) {
        String temporalStatistic = (String)rec.get("TEMPORAL_STATISTIC", false);
        if (temporalStatistic == null) {
            return null;
        }
        if (temporalStatistic.equals("COV") || temporalStatistic.equals("CORRCOEF") || StatisticMap.getPyroVal_temporal(temporalStatistic) == null) {
            this.addWarning(rec, String.format(Intl.intl("%s statistics are not yet supported."), temporalStatistic), Intl.intl("Adding statistic to additional records section."));
            return null;
        }
        if (rec.contains("POINTS") && rec.getInteger("POINTS") > 1) {
            temporalStatistic = StatisticMap.getLineValForFDSTemporal(temporalStatistic);
        }
        return StatisticMap.getPyroVal_temporal(temporalStatistic);
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        Long stat;
        boolean containsLegacy = rec.contains("STATISTICS");
        boolean containsTemporal = rec.contains("TEMPORAL_STATISTIC");
        boolean containsSpatial = rec.contains("SPATIAL_STATISTIC");
        boolean containsStat = containsLegacy || containsTemporal || containsSpatial;
        boolean containsPoints = rec.contains("POINTS");
        boolean isTimeHistory = rec.getOptional("TIME_HISTORY").orElse(false);
        FlowMeasurer flowDevc = this.getParsingInfo().findObject(FlowMeasurer.class, rec.getString("ID"));
        if (flowDevc != null) {
            return true;
        }
        ArrayList<Long> statTypes = new ArrayList<Long>();
        if (containsPoints && isTimeHistory) {
            return true;
        }
        if (!containsStat && !containsPoints) {
            return true;
        }
        if (!containsStat && containsPoints) {
            statTypes.add(0x2000000L);
        }
        if (containsTemporal) {
            stat = this.processTemporalStatistic(rec);
            if (stat == null) {
                return false;
            }
            statTypes.add(stat);
        }
        if (containsSpatial) {
            stat = this.processSpatialStatistic(rec);
            if (stat == null) {
                return false;
            }
            statTypes.add(stat);
        }
        if (containsLegacy) {
            stat = this.processLegacyStatistic(rec);
            if (stat == null) {
                return false;
            }
            statTypes.add(stat);
        }
        if (StatisticsUtil.containsUnsupportedType(statTypes)) {
            this.addWarning(rec, Intl.intl("Unsupported statistic type detected."), Intl.intl("Adding record to Additional Records."));
            return false;
        }
        for (Long stat2 : statTypes) {
            IQuantity msr;
            boolean advancedTemporal = false;
            if (containsTemporal && containsSpatial) {
                if (StatisticsUtil.isTemporalStatistic(stat2)) continue;
                advancedTemporal = true;
            }
            if ((msr = this.parseQuantity(rec, "QUANTITY", "PART_ID", "SPEC_ID", "MATL_ID", "DUCT_ID", "NODE_ID", stat2, Intl.intl("Ignoring statistic."), true, false, false)) == null) {
                return false;
            }
            if (msr.get().quantityType != QuantityType.GAS && msr.get().quantityType != QuantityType.SOLID || (msr.get().outputTypes & 1L) != 1L) {
                this.addWarning(rec, String.format(Intl.intl("Statitistics can only be measured for solid and gas phase quantities."), new Object[0]), Intl.intl("Ignoring statistic."));
                return true;
            }
            if ((msr.get().outputTypes & stat2) != stat2) {
                this.addWarning(rec, String.format(Intl.intl("Invalid statistic for quantity %s."), rec.getString("QUANTITY")), Intl.intl("Ignoring statistic."));
                continue;
            }
            IGeom geom = this.parseGeom(rec, msr, stat2);
            if (geom == null) {
                return true;
            }
            if (msr.get().quantityType == QuantityType.SOLID) {
                this.parseSolidStat(rec, msr, stat2, geom, advancedTemporal);
                continue;
            }
            this.parseGasStat(rec, msr, stat2, geom, advancedTemporal);
        }
        return true;
    }

    private IGeom parseGeom(FDSParseRecord rec, IQuantity msr, long pyroStat) throws FDSRecordFormatException {
        IGeom geom;
        Point3d mid;
        UnitPoint3D loc = null;
        UnitPoint3D[] bounds = null;
        UnitPoint3D boundsMid = null;
        Integer numPoints = rec.getInteger("POINTS", false);
        if (rec.contains("XB")) {
            bounds = StatisticsParser.parseXB(rec, Intl.intl("Gas-phase statistics"), "XB", true);
            mid = Util3D.getMidPoint(bounds[0].getPoint3dValue(Geometry.LU), bounds[1].getPoint3dValue(Geometry.LU));
            boundsMid = new UnitPoint3D(mid, Geometry.LU);
        }
        if (rec.contains("XBP")) {
            bounds = StatisticsParser.parseXB(rec, Intl.intl("Gas-phase statistics"), "XBP", true);
            mid = Util3D.getMidPoint(bounds[0].getPoint3dValue(Geometry.LU), bounds[1].getPoint3dValue(Geometry.LU));
            boundsMid = new UnitPoint3D(mid, Geometry.LU);
        }
        if (rec.contains("XYZ")) {
            loc = StatisticsParser.parseLoc(rec, "DEVC", "XYZ", true);
        }
        if (bounds == null && loc == null) {
            this.addWarning(rec, Intl.intl("Statistics must define either an XB, XBP, or XYZ."), Intl.intl("Ignoring statistic."));
            return null;
        }
        UnitPoint3D delta = new UnitPoint3D(rec.contains("DX") ? (UnitDouble)rec.get("DX") : new UnitDouble(0.0, Geometry.LU), rec.contains("DY") ? (UnitDouble)rec.get("DY") : new UnitDouble(0.0, Geometry.LU), rec.contains("DZ") ? (UnitDouble)rec.get("DZ") : new UnitDouble(0.0, Geometry.LU));
        if (pyroStat == 0x2000000L || StatisticsUtil.isLineStatistic(pyroStat)) {
            geom = new StatGeom.LinearPointArrayGeom(bounds[0].getPoint3dValue(Geometry.LU), bounds[1].getPoint3dValue(Geometry.LU), numPoints);
        } else if (pyroStat == 0x400000L) {
            AARectangle rect = this.toRect(bounds);
            if (rect == null) {
                this.addWarning(rec, String.format(Intl.intl("%s statistics must specify an area."), "AREA INTEGRAL"), Intl.intl("Ignoring statistic."));
                return null;
            }
            geom = rect;
        } else {
            geom = StatisticsUtil.isTemporalStatistic(pyroStat) ? this.parsePointGeom(loc, boundsMid) : (numPoints != null ? new StatGeom.LinearVolumeArrayGeom(bounds[0].getPoint3dValue(Geometry.LU), bounds[1].getPoint3dValue(Geometry.LU), delta.getPoint3dValue(Geometry.LU), numPoints) : this.parseVolGeom(rec, bounds, loc));
        }
        return geom;
    }

    private IGeom parsePointGeom(UnitPoint3D pointLoc, UnitPoint3D middleBound) {
        if (pointLoc != null) {
            return new Point(pointLoc.getPoint3dValue(Geometry.LU));
        }
        assert (middleBound != null);
        return new Point(middleBound.getPoint3dValue(Geometry.LU));
    }

    private IGeom parseVolGeom(FDSParseRecord rec, UnitPoint3D[] bounds, UnitPoint3D pointLoc) {
        if (bounds != null) {
            return new AABoxGeom(this.toBox(bounds).getValue(Geometry.LU));
        }
        Grid grid = this.getGridForPoint(pointLoc);
        if (grid == null) {
            this.addWarning(rec, String.format(Intl.intl("Could not find grid for point %s."), pointLoc.toString()), Intl.intl("Ignoring statistic."));
            return null;
        }
        return new StatGeom.GridGeom(grid);
    }

    private Map<String, String> getCustomProps(FDSParseRecord rec, boolean advancedTemporal) {
        String temporal;
        CustomFDSProps cprops = this.getCustomVals(rec);
        Map<String, String> map = cprops.getProps();
        String propId = rec.getString("PROP_ID");
        if (propId != null) {
            map = new HashMap<String, String>(map);
            map.put("PROP_ID", "'" + propId + "'");
        }
        if (advancedTemporal && (temporal = rec.getString("TEMPORAL_STATISTIC")) != null) {
            map = new HashMap<String, String>(map);
            map.put("TEMPORAL_STATISTIC", "'" + temporal + "'");
        }
        return map;
    }

    private void parseGasStat(FDSParseRecord rec, IQuantity msr, long pyroStat, IGeom geom, boolean advancedTemporal) throws FDSRecordFormatException {
        StatHash hash = new StatHash(rec, geom, msr, this.getCustomProps(rec, advancedTemporal));
        this.getParsingInfo().getParseResult().extractedUnsupportedRecs.add(rec);
        Set<Long> stats = this.d_gasStatMap.get(hash);
        if (stats == null) {
            stats = new HashSet<Long>();
            this.d_gasStatMap.put(hash, stats);
        }
        stats.add(pyroStat);
    }

    private AARectangle toRect(UnitPoint3D[] bounds) {
        return bounds != null ? AARectangle.construct(bounds[0].getPoint3dValue(Geometry.LU), bounds[1].getPoint3dValue(Geometry.LU), 1.0E-9, false) : null;
    }

    private UnitAABox toBox(UnitPoint3D[] bounds) {
        return bounds != null ? new UnitAABox(bounds[0], bounds[1]) : null;
    }

    private void parseSolidStat(FDSParseRecord rec, IQuantity msr, long pyroStat, IGeom geom, boolean advancedTemporal) throws FDSRecordFormatException {
        StatHash hash = new StatHash(rec, geom, msr, this.getCustomProps(rec, advancedTemporal));
        this.getParsingInfo().getParseResult().extractedUnsupportedRecs.add(rec);
        Set<Long> stats = this.d_solidStatMap.get(hash);
        if (stats == null) {
            stats = new HashSet<Long>();
            this.d_solidStatMap.put(hash, stats);
        }
        stats.add(pyroStat);
    }

    private Grid getGridForPoint(UnitPoint3D loc) {
        Point3d loc3d = loc.getValue(SI.METER);
        for (PyroMod mod : this.getParsingInfo().getSourceContainers()) {
            for (Grid grid : mod.getGridManager().flatten()) {
                Point3d min = grid.getMinPoint().getValue(SI.METER);
                Point3d max = grid.getMaxPoint().getValue(SI.METER);
                if (!(loc3d.x >= min.x) || !(loc3d.x <= max.x) || !(loc3d.y >= min.y) || !(loc3d.y <= max.y) || !(loc3d.z >= min.z) || !(loc3d.z <= max.z)) continue;
                return grid;
            }
        }
        return null;
    }

    @Override
    protected void done() throws FDSRecordFormatException {
        AMsrStat stat2;
        String name;
        StatHash hash2;
        BiConsumer<StatHash, AMsrStat> add = (hash, stat) -> {
            stat.setCustomFDSProps(CustomFDSProps.get(hash.customProps));
            this.getContainer().getMsrStatMgr().add((IPyroObject)stat);
            this.flagObjectAdded((IPyroObject)stat);
        };
        for (Map.Entry<StatHash, Set<Long>> entry : this.d_solidStatMap.entrySet()) {
            hash2 = entry.getKey();
            name = this.getName(hash2.rec);
            stat2 = new SolidMsrStat(name, hash2.msr, hash2.geom, Collections.EMPTY_LIST, (Collection<Long>)entry.getValue());
            add.accept(hash2, stat2);
        }
        for (Map.Entry<StatHash, Set<Long>> entry : this.d_gasStatMap.entrySet()) {
            hash2 = entry.getKey();
            name = this.getName(hash2.rec);
            stat2 = new GasMsrStat(name, hash2.msr, hash2.geom, (Collection<Long>)entry.getValue());
            add.accept(hash2, stat2);
        }
    }

    private String getName(FDSParseRecord rec) {
        String name;
        String base = rec.getString("ID", false);
        String fdsStat = rec.getString("SPATIAL_STATISTIC", false);
        if (fdsStat == null) {
            fdsStat = rec.getString("TEMPORAL_STATISTIC", false);
        }
        if (fdsStat == null) {
            fdsStat = rec.getString("STATISTICS", false);
        }
        if (fdsStat == null) {
            if (rec.contains("POINTS")) {
                fdsStat = "STEADY STATE";
            } else assert (false);
        }
        if (base == null) {
            String name2 = this.getNames(IMeasurementStat.class).generateName();
            this.addWarning(rec, Intl.intl("Statistic has no name."), String.format(Intl.intl("Assigning name to \"%s.\""), name2));
            return name2;
        }
        if (base.length() > fdsStat.length() + 1 && base.endsWith("_" + fdsStat)) {
            base = base.substring(0, base.lastIndexOf("_" + fdsStat));
        }
        if (!(name = this.getNames(IMeasurementStat.class).generateValidName(base)).equals(base)) {
            this.addWarning(rec, Intl.intl("Statistic did not have a unique name."), String.format(Intl.intl("Changing name from \"%1$s\" to \"%2$s.\""), base, name));
        }
        return name;
    }

    private Long processLegacyStatistic(FDSParseRecord rec) {
        String fdsStat = (String)rec.get("STATISTICS", false);
        boolean pointsDef = rec.contains("POINTS");
        if (fdsStat.equals("RMS") && pointsDef) {
            fdsStat = "LINE RMS";
        } else if (pointsDef && (fdsStat.equals("COV") || fdsStat.equals("CORRCOEF"))) {
            this.addWarning(rec, String.format(Intl.intl("%s statistics are not yet supported."), fdsStat), Intl.intl("Adding statistic to additional records section."));
            return null;
        }
        Long pyroVal = StatisticMap.getPyroVal_legacy(fdsStat);
        return pyroVal;
    }

    private static class StatHash {
        public final FDSParseRecord rec;
        public final IGeom geom;
        public final IQuantity msr;
        public final Map<String, String> customProps;

        public StatHash(FDSParseRecord rec, IGeom geom, IQuantity msr, Map<String, String> cprops) {
            this.rec = rec;
            this.geom = geom;
            this.msr = msr;
            this.customProps = cprops;
        }

        public int hashCode() {
            return this.geom.hashCode() + this.msr.hashCode() + this.customProps.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            StatHash hash = (StatHash)obj;
            return this.geom.equals(hash.geom) && this.msr.equals(hash.msr) && this.customProps.equals(hash.customProps);
        }
    }
}

