/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacAircoil;
import pyrosim.domain.hvac.HvacComponent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacDuctLoss;
import pyrosim.domain.hvac.HvacFan;
import pyrosim.domain.hvac.HvacFilter;
import pyrosim.domain.hvac.HvacLeak;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.domain.variant.Variant;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import pyrosim.io.fds.v6.parsers.VentParser;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.TriConsumer;

public class HvacParser
extends AFDS6Parser {
    private Map<FDSParseRecord, HvacAircoil> d_aircoilMap = new LinkedHashMap<FDSParseRecord, HvacAircoil>();
    private Map<FDSParseRecord, HvacDuct> d_ductMap = new LinkedHashMap<FDSParseRecord, HvacDuct>();
    private Map<FDSParseRecord, HvacFan> d_fanMap = new LinkedHashMap<FDSParseRecord, HvacFan>();
    private Map<FDSParseRecord, HvacFilter> d_filterMap = new LinkedHashMap<FDSParseRecord, HvacFilter>();
    private Map<FDSParseRecord, HvacNode> d_nodeMap = new LinkedHashMap<FDSParseRecord, HvacNode>();
    private Map<FDSParseRecord, HvacNode> d_nodesWithVents = new LinkedHashMap<FDSParseRecord, HvacNode>();
    private Map<FDSParseRecord, HvacLeak> d_leakMap = new LinkedHashMap<FDSParseRecord, HvacLeak>();
    private PinConnParser d_pinConns;
    private VentParser d_ventParser;

    public HvacParser(FDS6ParsingInfo parsingInfo, PinConnParser pinConns, VentParser ventParser) {
        super(parsingInfo);
        this.d_pinConns = pinConns;
        this.d_ventParser = ventParser;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("HVAC");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        unsupportedFields.put("MASS_FLOW", "UNSUPPORTED");
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        HvacComponent comp;
        String id;
        if (!rec.contains("TYPE_ID")) {
            this.addWarning(rec, Intl.intl("Unable to process HVAC record: Type ID missing"), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        String type = rec.getString("TYPE_ID");
        if (type.equals("AIRCOIL")) {
            id = this.parseName(rec, "ID", HvacAircoil.class, 1);
            comp = new HvacAircoil(id);
            this.d_aircoilMap.put(rec, (HvacAircoil)comp);
            if (!this.parseAircoil(rec, (HvacAircoil)comp)) {
                return false;
            }
        } else if (type.equals("DUCT")) {
            id = this.parseName(rec, "ID", HvacDuct.class, 0);
            comp = new HvacDuct(id);
            this.d_ductMap.put(rec, (HvacDuct)comp);
            if (!this.parseDuct(rec, (HvacDuct)comp)) {
                return false;
            }
        } else if (type.equals("FAN")) {
            id = this.parseName(rec, "ID", HvacFan.class, 1);
            comp = new HvacFan(id);
            this.d_fanMap.put(rec, (HvacFan)comp);
            if (!this.parseFan(rec, (HvacFan)comp)) {
                return false;
            }
        } else if (type.equals("FILTER")) {
            id = this.parseName(rec, "ID", HvacFilter.class, 1);
            comp = new HvacFilter(id);
            this.d_filterMap.put(rec, (HvacFilter)comp);
            if (!this.parseFilter(rec, (HvacFilter)comp)) {
                return false;
            }
        } else if (type.equals("NODE")) {
            id = this.parseName(rec, "ID", HvacNode.class, 1);
            comp = new HvacNode(id);
            this.d_nodeMap.put(rec, (HvacNode)comp);
            if (!this.parseNode(rec, (HvacNode)comp)) {
                return false;
            }
        } else if (type.equals("LEAK")) {
            id = this.parseName(rec, "ID", HvacLeak.class, 1);
            comp = new HvacLeak(id);
            if (!this.parseLeak(rec, (HvacLeak)comp)) {
                return false;
            }
            this.d_leakMap.put(rec, (HvacLeak)comp);
        } else {
            this.addWarning(rec, Intl.intl("Unable to process HVAC record: Invalid type"), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (comp instanceof ICustomFDSPropsContainer) {
            this.parseCustomFDSProps(comp, rec);
        }
        if (comp instanceof IModelObj) {
            ModelComposite root = this.getContainer().getObstructions();
            Composite hvacGroup = root.find(Intl.intl("HVAC"), Composite.class, false);
            if (hvacGroup == null) {
                hvacGroup = root.newGroup(Intl.intl("HVAC"));
                root.add(hvacGroup);
                this.flagObjectAdded(hvacGroup);
            }
            hvacGroup.add(comp);
        } else {
            assert (comp instanceof IHvacObject);
            this.getContainer().getHvacList().add(comp);
        }
        this.flagObjectAdded(comp);
        return true;
    }

    private boolean parseLeak(FDSParseRecord rec, HvacLeak leak) {
        UnitDouble loss;
        if (rec.contains("AREA")) {
            leak.setLeakArea(rec.getUnitDouble("AREA"));
        }
        if (rec.contains("LOSS") && (loss = (UnitDouble)((FDSArray)rec.get("LOSS")).get(0, 0)) != null) {
            leak.setProp("LOSS", Arrays.asList(loss));
        }
        leak.setEnthalpy(rec.getBoolean("LEAK_ENTHALPY", true));
        return true;
    }

    private boolean parseAircoil(FDSParseRecord rec, HvacAircoil comp) {
        List efficiency;
        int count = 0;
        if (rec.contains("COOLANT_SPECIFIC_HEAT")) {
            comp.setProp("COOLANT_SPECIFIC_HEAT", rec.getUnitDouble("COOLANT_SPECIFIC_HEAT"));
            ++count;
        }
        if (rec.contains("COOLANT_MASS_FLOW")) {
            comp.setProp("COOLANT_MASS_FLOW", rec.getUnitDouble("COOLANT_MASS_FLOW"));
            ++count;
        }
        if (rec.contains("COOLANT_TEMPERATURE")) {
            comp.setProp("COOLANT_TEMPERATURE", rec.getUnitDouble("COOLANT_TEMPERATURE"));
            ++count;
        }
        if (rec.contains("EFFICIENCY") && (efficiency = rec.getList("EFFICIENCY", false)).size() > 0 && efficiency.get(0) != null) {
            comp.setProp("EFFICIENCY", efficiency.get(0));
            ++count;
        }
        if (count > 0 && count < 4) {
            this.addWarning(rec, Intl.intl("Unable to process HVAC record: COOLANT_CP, COOLANT_MDOT, COOLANT_TEMPERATURE, and EFFICIENTY must be defined."), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (count > 0 && rec.contains("FIXED_Q")) {
            this.addWarning(rec, Intl.intl("Unable to process HVAC record: Only one of FIXED_Q and COOLANT properies may be defined."), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (count == 4) {
            comp.setProp("opt_aircoil_model", (Object)HvacAircoil.Model.COOLANT);
            return true;
        }
        if (rec.contains("FIXED_Q")) {
            comp.setProp("opt_aircoil_model", (Object)HvacAircoil.Model.FIXEDQ);
            UnitDouble fixedQ = rec.getUnitDouble("FIXED_Q");
            TimeFunction func = this.parseTimeFunction(rec, "TAU_AC", "RAMP_ID");
            comp.setFixedQ(new TimeBasedValue<UnitDouble>(fixedQ, func));
        }
        if (rec.contains("CTRL_ID")) {
            this.addWarning(rec, Intl.intl("CTRL_ID invalid for HVAC Aircoil components"), String.format(Intl.intl("CTRL_ID dropped from aircoil %s."), comp.getName()));
        }
        if (rec.contains("DEVC_ID")) {
            this.addWarning(rec, Intl.intl("DEVC_ID invalid for HVAC Aircoil components"), String.format(Intl.intl("DEVC_ID dropped from aircoil %s."), comp.getName()));
        }
        return true;
    }

    private boolean parseDuct(FDSParseRecord rec, HvacDuct comp) {
        UnitDouble roughness;
        HvacDuct duct = comp;
        if (!this.parseDuctShape(rec, duct)) {
            return false;
        }
        if (!this.parseDuctAirflowObj(rec, duct)) {
            return false;
        }
        UnitDouble len = rec.getUnitDouble("LENGTH", true);
        comp.setProp("LENGTH", len);
        if (rec.contains("LOSS")) {
            FDSArray loss = (FDSArray)rec.get("LOSS");
            UnitDouble lossForward = (UnitDouble)loss.get(0, 0);
            UnitDouble lossBackward = (UnitDouble)loss.get(1, 0);
            if (lossForward != null && lossBackward != null) {
                comp.setProp("LOSS", Arrays.asList(lossForward, lossBackward));
            } else if (lossForward != null && lossBackward == null) {
                this.addWarning(rec, Intl.intl("Invalid HVAC entry: DUCT LOSS is a pair of real numbers."), Intl.intl("Using first entry for both values."));
                comp.setProp("LOSS", Arrays.asList(lossForward, new UnitDouble(lossForward.getValueNoUnit(), lossForward.getUnit())));
            } else {
                this.addWarning(rec, Intl.intl("Invalid HVAC entry: DUCT LOSS is a pair of real numbers."), Intl.intl("Using default values."));
            }
        }
        if (rec.contains("NODE_ID")) {
            List nodeId = rec.getList("NODE_ID", false);
            comp.d_n1 = (String)nodeId.get(0);
            comp.d_n2 = (String)nodeId.get(1);
        }
        if (rec.contains("REVERSE")) {
            comp.setProp("REVERSE", rec.getBoolean("REVERSE"));
        }
        if ((roughness = rec.getUnitDouble("ROUGHNESS", false)) == null) {
            comp.setProp("opt_friction_type", (Object)HvacDuct.FrictionType.NO_FRICTION);
        } else if (roughness.getValueNoUnit() > 0.0) {
            comp.setProp("opt_friction_type", (Object)HvacDuct.FrictionType.EXPLICIT);
            comp.setProp("ROUGHNESS", roughness);
        } else {
            comp.setProp("opt_friction_type", (Object)HvacDuct.FrictionType.COMPUTED_FRICTION);
        }
        HvacParser.markSingleInputForRetrieval(rec, comp, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        return true;
    }

    private boolean parseDuctShape(FDSParseRecord rec, HvacDuct comp) {
        UnitDouble diameter = rec.getUnitDouble("DIAMETER");
        UnitDouble area = rec.getUnitDouble("AREA");
        UnitDouble perimeter = rec.getUnitDouble("PERIMETER");
        if (diameter == null && area == null && perimeter == null) {
            String msg = String.format(Intl.intl("Unable to process HVAC duct: %1$s or %2$s must be specified, and %3$s can optionally be specified."), "DIAMETER", "AREA", "PERIMETER");
            this.addWarning(rec, msg, Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (diameter != null) {
            if (perimeter != null) {
                String msg = String.format(Intl.intl("Unable to process HVAC duct: %1$s and %2$s cannot both be specified."), "DIAMETER", "PERIMETER");
                this.addWarning(rec, msg, Intl.intl("HVAC Record Ignored"));
                return false;
            }
            comp.setProp("opt_shape", (Object)HvacDuct.Shape.CIRCULAR);
            comp.setProp("DIAMETER", diameter);
            return true;
        }
        if (area != null) {
            if (perimeter != null) {
                comp.setProp("opt_shape", (Object)HvacDuct.Shape.NON_CIRCULAR);
                comp.setProp("AREA", area);
                comp.setProp("PERIMETER", perimeter);
            } else {
                comp.setProp("opt_shape", (Object)HvacDuct.Shape.CIRCULAR);
                double darea = area.getValue(SI.METER.pow(2));
                double ddiameter = 2.0 * Math.sqrt(darea / Math.PI);
                comp.setProp("DIAMETER", new UnitDouble(ddiameter, SI.METER));
            }
            return true;
        }
        assert (perimeter != null);
        String msg = String.format(Intl.intl("Unable to process HVAC duct: Cannot specify %1$s without %2$s."), "PERIMETER", "AREA");
        this.addWarning(rec, msg, Intl.intl("HVAC Record Ignored"));
        return false;
    }

    private boolean parseDuctAirflowObj(FDSParseRecord rec, HvacDuct comp) {
        HvacDuct.AirflowObj airflowOpt = HvacDuct.AirflowObj.NONE;
        if (rec.contains("DAMPER") && rec.contains("FAN_ID") && rec.contains("AIRCOIL_ID") && rec.contains("VOLUME_FLOW")) {
            String warning = String.format(Intl.intl("Unable to process HVAC record: Only one of %1$s, %2$s, %3$s, or %4$s, may be specified."), "DAMPER", "FAN_ID", "AIRCOIL_ID", "VOLUME_FLOW");
            this.addWarning(rec, warning, Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (rec.contains("DAMPER")) {
            airflowOpt = HvacDuct.AirflowObj.DAMPER;
        } else if (rec.contains("FAN_ID")) {
            airflowOpt = HvacDuct.AirflowObj.FAN;
            comp.setProp("FAN_ID", rec.getString("FAN_ID"));
        } else if (rec.contains("AIRCOIL_ID")) {
            airflowOpt = HvacDuct.AirflowObj.AIRCOIL;
            comp.setProp("AIRCOIL_ID", rec.getString("AIRCOIL_ID"));
        } else if (rec.contains("VOLUME_FLOW")) {
            airflowOpt = HvacDuct.AirflowObj.VOLFLOW;
            UnitDouble volflow = rec.getUnitDouble("VOLUME_FLOW");
            TimeFunction volflowRamp = this.parseTimeFunction(rec, "TAU_VF", "RAMP_ID");
            comp.setVolflow(new TimeBasedValue<UnitDouble>(volflow, volflowRamp));
        }
        comp.setProp("opt_none_damper_fan", (Object)airflowOpt);
        return true;
    }

    private boolean parseFan(FDSParseRecord rec, HvacFan comp) {
        if (rec.contains("TAU_FAN")) {
            comp.setProp("TAU_FAN", rec.getUnitDouble("TAU_FAN"));
            comp.setTauFunc(AFDS6Parser.parseTCurve(rec, "TAU_FAN"));
        }
        if (rec.contains("LOSS")) {
            FDSArray lossArr = (FDSArray)rec.get("LOSS");
            UnitDouble loss = (UnitDouble)lossArr.get(0, 0);
            if (loss != null) {
                comp.setProp("LOSS", Arrays.asList(loss));
            } else {
                this.addWarning(rec, Intl.intl("Invalid HVAC entry: FAN LOSS"), Intl.intl("Using default."));
            }
        }
        int count = 0;
        if (rec.contains("VOLUME_FLOW")) {
            comp.setProp("VOLUME_FLOW", rec.getUnitDouble("VOLUME_FLOW"));
            comp.setProp("opt_fan_model", HvacFan.FAN_MODEL_VOLFLOW);
            ++count;
        }
        if (rec.contains("MAX_FLOW") && rec.contains("MAX_PRESSURE")) {
            comp.setProp("MAX_FLOW", rec.getUnitDouble("MAX_FLOW"));
            comp.setProp("MAX_PRESSURE", rec.getUnitDouble("MAX_PRESSURE"));
            comp.setProp("opt_fan_model", HvacFan.FAN_MODEL_QUADRATIC);
            ++count;
        }
        if (rec.contains("RAMP_ID")) {
            Ramp r = this.getParsingInfo().getRamp(rec.getString("RAMP_ID"), RampInputs.FLOW, 39, true);
            comp.setPressureFlow(Variant.ramp(r));
            comp.setProp("RAMP_ID", rec.getString("RAMP_ID"));
            comp.setProp("opt_fan_model", HvacFan.FAN_MODEL_PRESDROP);
            ++count;
        }
        if (count > 1) {
            this.addWarning(rec, Intl.intl("Unable to process HVAC FAN record: Only one of VOLUME_FLOW, MAX_FLOW + MAX_PRESSURE, and RAMP_ID can be defined"), Intl.intl("HVAC Record ignored."));
            return false;
        }
        if (rec.contains("CTRL_ID")) {
            this.addWarning(rec, Intl.intl("CTRL_ID invalid for HVAC Aircoil components"), String.format(Intl.intl("CTRL_ID dropped from aircoil %s."), comp.getName()));
        }
        if (rec.contains("DEVC_ID")) {
            this.addWarning(rec, Intl.intl("DEVC_ID invalid for HVAC Aircoil components"), String.format(Intl.intl("DEVC_ID dropped from aircoil %s."), comp.getName()));
        }
        return true;
    }

    private boolean parseFilter(FDSParseRecord rec, HvacFilter comp) {
        if (rec.contains("CLEAN_LOSS")) {
            comp.setProp("CLEAN_LOSS", rec.getUnitDouble("CLEAN_LOSS"));
        }
        if (rec.contains("EFFICIENCY")) {
            comp.setProp("EFFICIENCY", rec.getList("EFFICIENCY", false));
        }
        if (rec.contains("LOADING")) {
            comp.setProp("LOADING", rec.getList("LOADING", false));
        }
        if (rec.contains("LOADING_MULTIPLIER")) {
            comp.setProp("LOADING_MULTIPLIER", rec.getList("LOADING_MULTIPLIER", false));
        }
        if (rec.contains("SPEC_ID")) {
            comp.setProp("SPEC_ID", rec.getList("SPEC_ID", false));
        }
        if (rec.contains("LOSS") && rec.contains("RAMP_ID")) {
            this.addWarning(rec, Intl.intl("Unable to process HVAC record: Only one of LOSS and RAMP_ID may be specified"), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (rec.contains("LOSS")) {
            comp.setProp("opt_loss_ramp", (Object)HvacFilter.LossModel.LINEAR);
            FDSArray lossArr = (FDSArray)rec.get("LOSS");
            UnitDouble loss = (UnitDouble)lossArr.get(0, 0);
            if (loss != null) {
                comp.setProp("LOSS", Arrays.asList(loss));
            } else {
                this.addWarning(rec, Intl.intl("Invalid HVAC entry: FILTER LOSS"), Intl.intl("Using default."));
            }
        } else if (rec.contains("RAMP_ID")) {
            comp.setProp("opt_loss_ramp", (Object)HvacFilter.LossModel.CUSTOM);
            Ramp r = this.getParsingInfo().getRamp(rec.getString("RAMP_ID"), RampInputs.MASS, 28, true);
            comp.setCustomLoss(Variant.ramp(r));
        }
        return true;
    }

    private boolean parseNode(FDSParseRecord rec, HvacNode comp) throws FDSRecordFormatException {
        HvacNode node = comp;
        boolean ambient = rec.getBoolean("AMBIENT", true);
        String ventID = rec.getString("VENT_ID");
        if (ambient && ventID != null) {
            String msg = String.format(Intl.intl("Invalid HVAC NODE: Only one of %1$s and %2$s may be specified."), "AMBIENT", "VENT_ID");
            this.addWarning(rec, msg, Intl.intl("HVAC Record Ignored."));
            return false;
        }
        if (ambient) {
            node.setNodeType(HvacNode.NodeType.AMBIENT);
        } else if (ventID == null) {
            node.setNodeType(HvacNode.NodeType.INTERNAL);
        } else {
            this.d_nodesWithVents.put(rec, node);
        }
        UnitPoint3D loc = HvacParser.parseLoc(rec, "HVAC", "XYZ", true, ventID == null);
        if (loc != null) {
            comp.setProp("XYZ", loc);
        }
        return true;
    }

    private static final <T> T findById(Map<FDSParseRecord, T> map, String id) {
        for (FDSParseRecord rec : map.keySet()) {
            if (!rec.contains("ID") || !rec.getString("ID").equals(id)) continue;
            return map.get(rec);
        }
        return null;
    }

    @Override
    public void done() {
        for (FDSParseRecord rec : this.d_ductMap.keySet()) {
            HvacDuct duct = this.d_ductMap.get(rec);
            this.finalizeDuct(rec, duct);
        }
        for (FDSParseRecord rec : this.d_nodeMap.keySet()) {
            HvacNode node = this.d_nodeMap.get(rec);
            this.finalizeNode(rec, node);
        }
    }

    private void finalizeDuct(FDSParseRecord rec, HvacDuct duct) {
        String acId;
        String fanId;
        String[] nodeId = new String[]{duct.d_n1, duct.d_n2};
        if (nodeId != null) {
            HvacNode node1 = HvacParser.findById(this.d_nodeMap, nodeId[0]);
            HvacNode node2 = HvacParser.findById(this.d_nodeMap, nodeId[1]);
            if (node1 == null) {
                this.addWarning(rec, String.format(Intl.intl("Unable to find NODE for DUCT (NODE_ID=%s)."), node1), Intl.intl("Creating invalid HVAC DUCT"));
            }
            if (node2 == null) {
                this.addWarning(rec, String.format(Intl.intl("Unable to find NODE for DUCT (NODE_ID=%s)."), node2), Intl.intl("Creating invalid HVAC DUCT."));
            }
            duct.setProp("NODE_ID", Arrays.asList(node1, node2));
        }
        if ((fanId = (String)duct.getProp("FAN_ID")) != null) {
            HvacFan fan = HvacParser.findById(this.d_fanMap, fanId);
            if (fan == null) {
                this.addWarning(rec, String.format(Intl.intl("Unable to find FAN for DUCT (FAN_ID=%s)."), fanId), Intl.intl("Turned off airflow for duct."));
                duct.setProp("opt_none_damper_fan", (Object)HvacDuct.AirflowObj.NONE);
            }
            duct.setProp("FAN_ID", fan);
        }
        if ((acId = (String)duct.getProp("AIRCOIL_ID")) != null) {
            HvacAircoil ac = HvacParser.findById(this.d_aircoilMap, acId);
            if (ac == null) {
                this.addWarning(rec, String.format(Intl.intl("Unable to find AIRCOIL for DUCT (AIRCOIL_ID=%s)."), acId), Intl.intl("Turned off airflow for duct."));
                duct.setProp("opt_none_damper_fan", (Object)HvacDuct.AirflowObj.NONE);
            }
            duct.setProp("AIRCOIL_ID", ac);
        }
    }

    private void finalizeNode(FDSParseRecord rec, HvacNode node) {
        String filterId;
        ArrayList<HvacDuct> ducts = Collections.EMPTY_LIST;
        if (rec.contains("DUCT_ID")) {
            List ductIds = (List)rec.get("DUCT_ID");
            if (ductIds.size() >= 10) {
                this.addWarning(rec, Intl.intl("List exceeds limit: DUCT_ID"), Intl.intl("Ignoring tailing entries"));
                ductIds = ductIds.subList(0, 9);
            }
            ducts = new ArrayList<HvacDuct>(ductIds.size());
            for (String ductId : ductIds) {
                HvacDuct duct = HvacParser.findById(this.d_ductMap, ductId);
                if (duct == null) {
                    this.addWarning(rec, String.format(Intl.intl("Unable to find DUCT for NODE (DUCT_ID=%s)."), ductId), Intl.intl("Missing DUCT record will be ignored."));
                } else if (!duct.getNodes().contains(node)) {
                    this.addWarning(rec, String.format(Intl.intl("Inconsistent connection: DUCT, \"%1$s,\" does not specify connection to NODE, \"%2$s.\""), ductId, node.getName()), Intl.intl("Ignoring connection."));
                    duct = null;
                }
                ducts.add(duct);
            }
        }
        if (rec.contains("LOSS")) {
            FDSArray lossArr = (FDSArray)rec.get("LOSS");
            if (lossArr == null) {
                this.addWarning(rec, Intl.intl("Invalid HVAC entry: NODE LOSS"), Intl.intl("Using default."));
            } else {
                HvacNode.NodeType type;
                HvacNode.NodeType nodeType = type = rec.getString("VENT_ID") != null ? HvacNode.NodeType.VENT : node.getNodeType();
                if (type.terminal) {
                    UnitDouble inLoss = (UnitDouble)lossArr.get(0, 0);
                    UnitDouble outLoss = (UnitDouble)lossArr.get(1, 0);
                    if (inLoss == null) {
                        inLoss = new UnitDouble(0.0, Unit.ONE);
                    }
                    if (outLoss == null) {
                        outLoss = new UnitDouble(0.0, Unit.ONE);
                    }
                    node.setTerminalLoss(inLoss, outLoss);
                } else {
                    for (int col = 0; col < ducts.size(); ++col) {
                        HvacDuct toDuct = (HvacDuct)ducts.get(col);
                        if (toDuct == null) continue;
                        for (int row = col + 1; row < ducts.size(); ++row) {
                            HvacDuct fromDuct = (HvacDuct)ducts.get(row);
                            if (fromDuct == null) continue;
                            UnitDouble fwdLoss = (UnitDouble)lossArr.get(row, col);
                            UnitDouble revLoss = (UnitDouble)lossArr.get(col, row);
                            if (!HvacParser.isLoss(fwdLoss) && !HvacParser.isLoss(revLoss)) continue;
                            HvacDuctLoss hdl = new HvacDuctLoss(node, fromDuct, toDuct, HvacParser.finalizeLoss(fwdLoss), HvacParser.finalizeLoss(revLoss));
                            this.getContainer().getBridges().add(hdl);
                            this.flagObjectAdded(hdl);
                        }
                    }
                }
            }
        }
        if ((filterId = rec.getString("FILTER_ID", true)) != null) {
            HvacFilter filter = HvacParser.findById(this.d_filterMap, filterId);
            node.setProp("FILTER_ID", filter);
            if (filter == null) {
                this.addWarning(rec, String.format(Intl.intl("Unable to find FILTER for NODE (FILTER_ID=%s)."), filterId), Intl.intl("Ignoring filter."));
            } else if (ducts.size() > 2) {
                this.addWarning(rec, String.format(Intl.intl("Filtered node connected to %d ducts. Maximum allowed with filters=2."), ducts.size()), Intl.intl("Node will be invalid until fixed."));
            }
        }
    }

    private static boolean isLoss(UnitDouble val) {
        return val != null && val.getValueNoUnit() != 0.0;
    }

    private static UnitDouble finalizeLoss(UnitDouble val) {
        return val == null ? new UnitDouble(0.0, Unit.ONE) : val;
    }

    @Override
    public void postProcess() {
        HvacParser.postProcessFilters(this.d_filterMap, this.getContainer().getExSpecList());
        Map<FDSParseRecord, Vent> ventMap = this.d_ventParser.getVentMap();
        HvacParser.postProcessLeaks(this.d_leakMap, ventMap);
        HvacParser.postProcessVentNodes(this.d_nodesWithVents, ventMap, (rec, err, msg) -> this.addWarning((FDSParseRecord)rec, (String)err, (String)msg));
    }

    private static void postProcessLeaks(Map<FDSParseRecord, HvacLeak> leaks, Map<FDSParseRecord, Vent> vents) {
        for (Map.Entry<FDSParseRecord, HvacLeak> entry : leaks.entrySet()) {
            FDSParseRecord rec = entry.getKey();
            HvacLeak leak = entry.getValue();
            String v1Id = rec.getString("VENT_ID");
            String v2Id = rec.getString("VENT2_ID");
            leak.setVent1(HvacParser.findById(vents, v1Id));
            leak.setVent2(HvacParser.findById(vents, v2Id));
        }
    }

    private static void postProcessFilters(Map<FDSParseRecord, HvacFilter> filters, ExSpecList species) {
        for (Map.Entry<FDSParseRecord, HvacFilter> entr : filters.entrySet()) {
            List<Object> loadings;
            if (!entr.getKey().contains("SPEC_ID")) continue;
            List specNames = (List)entr.getValue().getProp("SPEC_ID");
            ArrayList<ExSpec> newSpecs = new ArrayList<ExSpec>();
            for (String name : specNames) {
                newSpecs.add(species.get(name));
            }
            entr.getValue().setProp("SPEC_ID", newSpecs);
            if (!entr.getKey().contains("LOADING")) {
                loadings = new ArrayList<UnitDouble>();
                for (int i = 0; i < specNames.size(); ++i) {
                    loadings.add(new UnitDouble(0.0, SI.KILOGRAM));
                }
                entr.getValue().setProp("LOADING", loadings);
                continue;
            }
            if (entr.getKey().getList("LOADING", false).size() >= specNames.size()) continue;
            loadings = entr.getKey().getList("LOADING", false);
            for (int i = loadings.size(); i < specNames.size(); ++i) {
                loadings.add(new UnitDouble(0.0, SI.KILOGRAM));
            }
            entr.getValue().setProp("LOADING", loadings);
        }
    }

    private static void postProcessVentNodes(Map<FDSParseRecord, HvacNode> nodes, Map<FDSParseRecord, Vent> vents, TriConsumer<FDSParseRecord, String, String> addWarn) {
        for (Map.Entry<FDSParseRecord, HvacNode> entry : nodes.entrySet()) {
            String ventId;
            FDSParseRecord rec = entry.getKey();
            if (!rec.contains("VENT_ID") || (ventId = rec.getString("VENT_ID")) == null) continue;
            HvacNode node = entry.getValue();
            Vent vent = HvacParser.findById(vents, ventId);
            try {
                if (vent == null) {
                    throw new Exception(String.format(Intl.intl("VENT id=%s not found."), ventId));
                }
                if (!vent.getSurface().isPredefined(PredefSurf.HVAC)) {
                    throw new Exception(String.format(Intl.intl("VENT referenced by HVAC NODE uses SURF, \"%s\", but must use SURF, \"HVAC\", instead."), vent.getSurface().getName()));
                }
                node.setVent(vent);
            }
            catch (Exception e) {
                node.setNodeType(HvacNode.NodeType.AMBIENT);
                addWarn.accept(rec, e.getLocalizedMessage(), Intl.intl("Set node type to AMBIENT."));
            }
        }
    }
}

