/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.controls.DeadbandCtrl;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.LatchCtrl;
import pyrosim.domain.controls.LogicOps.AIntCompareOp;
import pyrosim.domain.controls.LogicOps.AndOp;
import pyrosim.domain.controls.LogicOps.DblGreaterThanOp;
import pyrosim.domain.controls.LogicOps.DblLessThanOp;
import pyrosim.domain.controls.LogicOps.IntEqualOp;
import pyrosim.domain.controls.LogicOps.IntGreaterThanOp;
import pyrosim.domain.controls.LogicOps.IntLessThanOp;
import pyrosim.domain.controls.LogicOps.IntNotEqualOp;
import pyrosim.domain.controls.LogicOps.NotOp;
import pyrosim.domain.controls.LogicOps.OrOp;
import pyrosim.domain.controls.MathOps.AMathOp;
import pyrosim.domain.controls.MathOps.ArcCosOp;
import pyrosim.domain.controls.MathOps.ArcSinOp;
import pyrosim.domain.controls.MathOps.ArcTanOp;
import pyrosim.domain.controls.MathOps.CosOp;
import pyrosim.domain.controls.MathOps.CountOp;
import pyrosim.domain.controls.MathOps.DivideOp;
import pyrosim.domain.controls.MathOps.ExpOp;
import pyrosim.domain.controls.MathOps.LogOp;
import pyrosim.domain.controls.MathOps.MaxOp;
import pyrosim.domain.controls.MathOps.MinOp;
import pyrosim.domain.controls.MathOps.MultiplyOp;
import pyrosim.domain.controls.MathOps.PIDControllerOp;
import pyrosim.domain.controls.MathOps.PercentileOp;
import pyrosim.domain.controls.MathOps.PowerOp;
import pyrosim.domain.controls.MathOps.SinOp;
import pyrosim.domain.controls.MathOps.SubtractOp;
import pyrosim.domain.controls.MathOps.SumOp;
import pyrosim.domain.controls.TimeDelayCtrl;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.simctrl.ASimCtrlDevice;
import pyrosim.domain.devices.simctrl.KillDevice;
import pyrosim.domain.devices.simctrl.RestartFileDevc;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.signals.IDoubleInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;

public class ControlParser
extends AFDS6Parser {
    private final PinConnParser d_pinConns;
    private final List<IControl> d_doubleInCtrls;

    public ControlParser(FDS6ParsingInfo parsingInfo, PinConnParser pinConns) {
        super(parsingInfo);
        this.d_pinConns = pinConns;
        this.d_doubleInCtrls = new ArrayList<IControl>();
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("CTRL");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        unsupportedFields.put("EVACUATION", "UNSUPPORTED");
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        IControl control;
        String id = (String)rec.get("ID");
        if (id == null || id.trim().equals("")) {
            this.addWarning(rec, Intl.intl("Control has no ID."), Intl.intl("Adding control to additional records section."));
            return false;
        }
        if (this.d_pinConns.outputNameExists(id)) {
            this.addWarning(rec, Intl.intl("CTRL ID is not unique across all controls and devices."), Intl.intl("Ignoring control."));
            return true;
        }
        String function = (String)rec.get("FUNCTION_TYPE");
        if (function == null) {
            this.addWarning(rec, Intl.intl("Control has no function type specified."), Intl.intl("Adding control to additional records section."));
            return false;
        }
        if (function.equals("KILL") || function.equals("RESTART")) {
            ASimCtrlDevice devc = function.equals("KILL") ? this.parseKill(rec, id) : this.parseRestart(rec, id);
            this.markInputRetrieval(rec, devc);
            this.getContainer().getDevices().add(devc);
            this.flagObjectAdded(devc);
            int exists = this.existsStatus(rec, devc, IDevice.class);
            if (exists != 0) {
                return this.convertToReturn(exists);
            }
            this.getContainer().getDevices().add(devc);
            this.flagObjectAdded(devc);
            return true;
        }
        if (function.equals("ANY")) {
            control = this.parseAny(rec);
        } else if (function.equals("ALL")) {
            control = this.parseAll(rec);
        } else if (function.equals("ONLY")) {
            control = this.parseOnly(rec);
        } else if (function.equals("AT_LEAST")) {
            control = this.parseAtLeast(rec);
        } else if (function.equals("TIME_DELAY")) {
            control = this.parseTimeDelay(rec);
        } else if (function.equals("CUSTOM")) {
            control = this.parseCustom(rec);
        } else if (function.equals("DEADBAND")) {
            control = this.parseDeadBand(rec);
        } else if (function.equals("MULTIPLY")) {
            control = this.parseMathOp(rec, MultiplyOp::new);
        } else if (function.equals("DIVIDE")) {
            control = this.parseMathOp(rec, DivideOp::new);
        } else if (function.equals("SUBTRACT")) {
            control = this.parseMathOp(rec, SubtractOp::new);
        } else if (function.equals("POWER")) {
            control = this.parseMathOp(rec, PowerOp::new);
        } else if (function.equals("EXP")) {
            control = this.parseMathOp(rec, ExpOp::new);
        } else if (function.equals("LOG")) {
            control = this.parseMathOp(rec, LogOp::new);
        } else if (function.equals("SIN")) {
            control = this.parseMathOp(rec, SinOp::new);
        } else if (function.equals("ASIN")) {
            control = this.parseMathOp(rec, ArcSinOp::new);
        } else if (function.equals("COS")) {
            control = this.parseMathOp(rec, CosOp::new);
        } else if (function.equals("ACOS")) {
            control = this.parseMathOp(rec, ArcCosOp::new);
        } else if (function.equals("SUM")) {
            control = this.parseMathOp(rec, SumOp::new);
        } else if (function.equals("MAX")) {
            control = this.parseMathOp(rec, MaxOp::new);
        } else if (function.equals("MIN")) {
            control = this.parseMathOp(rec, MinOp::new);
        } else if (function.equals("ATAN")) {
            control = this.parseMathOp(rec, ArcTanOp::new);
        } else if (function.equals("PERCENTILE")) {
            control = this.parsePercentileOp(rec);
        } else if (function.equals("PID")) {
            control = this.parsePIDControllerOp(rec);
        } else {
            this.addWarning(rec, String.format(Intl.intl("Unknown control function type, %s."), function), Intl.intl("Adding control to additional records section."));
            return false;
        }
        if (control != null) {
            control.setName(id);
            for (IOutPin iOutPin : control.getOutputPins()) {
                this.d_pinConns.addOutputName(iOutPin, id);
            }
        }
        return true;
    }

    public void finish() throws FDSRecordFormatException {
        for (IControl ctrl : this.d_doubleInCtrls) {
            IDoubleInPin inPin = (IDoubleInPin)ctrl.getInputPin();
            inPin.changeInputUnits(SIUS.getInstance());
        }
    }

    private RestartFileDevc parseRestart(FDSParseRecord rec, String id) {
        return new RestartFileDevc(id);
    }

    private KillDevice parseKill(FDSParseRecord rec, String id) {
        return new KillDevice(id);
    }

    private IControl parseDeadBand(FDSParseRecord rec) {
        int tripDir;
        String onBound = (String)rec.get("ON_BOUND", true);
        if (onBound.equals("LOWER")) {
            tripDir = 0;
        } else if (onBound.equals("UPPER")) {
            tripDir = 1;
        } else {
            this.addWarning(rec, String.format(Intl.intl("Unknown on-bound, %s."), onBound), Intl.intl("Adding control to additional records."));
            return null;
        }
        if (!rec.contains("SETPOINT")) {
            this.addWarning(rec, Intl.intl("Deadband control has no setpoint."), Intl.intl("Adding control to additional records."));
            return null;
        }
        List bounds = rec.getList("SETPOINT", false);
        if (bounds.size() != 2) {
            this.addWarning(rec, Intl.intl("Deadband controls require two values for the setpoint."), Intl.intl("Adding control to additional records."));
            return null;
        }
        DeadbandCtrl ctrl = new DeadbandCtrl(tripDir, new UnitDouble((Double)bounds.get(0), Unit.ONE), new UnitDouble((Double)bounds.get(1), Unit.ONE));
        this.markInputRetrieval(rec, ctrl);
        this.d_doubleInCtrls.add(ctrl);
        return this.parseInvertAndLatch(rec, ctrl);
    }

    private PercentileOp parsePercentileOp(FDSParseRecord rec) throws FDSRecordFormatException {
        PercentileOp op = this.parseMathOp(rec, PercentileOp::new);
        Double percentile = rec.getDouble("PERCENTILE");
        if (percentile == null) {
            throw new FDSRecordFormatException(rec, Intl.intl("PERCENTILE must be defined for a Percentile type CTRL."));
        }
        op.setPercentile(rec.getDouble("PERCENTILE"));
        return op;
    }

    private PIDControllerOp parsePIDControllerOp(FDSParseRecord rec) {
        PIDControllerOp op = this.parseMathOp(rec, PIDControllerOp::new);
        op.setTargetValue(rec.getDouble("TARGET_VALUE", true));
        op.setProportionalGain(rec.getDouble("PROPORTIONAL_GAIN", true));
        op.setIntegralGain(rec.getDouble("INTEGRAL_GAIN", true));
        op.setDerivativeGain(rec.getDouble("DIFFERENTIAL_GAIN", true));
        return op;
    }

    private <T extends AMathOp> T parseMathOp(FDSParseRecord rec, Supplier<T> buildOp) {
        AMathOp op = (AMathOp)buildOp.get();
        op.getMeasureInfo().setAlarmInfo(ControlParser.parseAlarm(rec));
        this.registerConstantInput(rec, op);
        this.markInputRetrieval(rec, op);
        return (T)op;
    }

    private static AlarmInfo parseAlarm(FDSParseRecord rec) {
        List setpointVals = rec.getList("SETPOINT", false);
        if (setpointVals == null) {
            return null;
        }
        return new AlarmInfo(SIUS.newud((Double)setpointVals.iterator().next(), 28), ControlParser.parseTripFlags(rec));
    }

    private static int parseTripFlags(FDSParseRecord rec) {
        int tripFlags = 0;
        if (rec.getBoolean("INITIAL_STATE", true).booleanValue()) {
            tripFlags |= 2;
        }
        if (rec.getBoolean("LATCH", true).booleanValue()) {
            tripFlags |= 1;
        }
        if (rec.getInteger("TRIP_DIRECTION", true) <= 0) {
            tripFlags |= 4;
        }
        return tripFlags;
    }

    private IControl parseCustom(FDSParseRecord rec) throws FDSRecordFormatException {
        AControl result;
        String rampID = (String)rec.get("RAMP_ID");
        if (rampID == null) {
            throw new FDSRecordFormatException(rec, Intl.intl("Custom control has no ramp function."));
        }
        IRampInput unitlessInput = new IRampInput(){
            private static final long serialVersionUID = -9176306205357962471L;

            @Override
            public String getName() {
                return "";
            }

            @Override
            public int getUnitType() {
                return 28;
            }

            @Override
            public String getTVar() {
                return "T";
            }
        };
        Ramp ramp = this.getParsingInfo().getRamp(rampID, unitlessInput, 28, false);
        if (ramp == null) {
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("Could not find ramp with id, %s."), rampID));
        }
        boolean initialState = rec.getBoolean("INITIAL_STATE", true);
        Pair<List<UnitDouble>, Boolean> rampRes = ControlParser.parseCustomRamp(ramp, initialState);
        if (((List)rampRes.v1).isEmpty()) {
            this.addWarning(rec, String.format(Intl.intl("Custom ramp %s for control contains no zero-crossings."), rampID), Intl.intl("Unused time entries from ramp dropped."));
        }
        if (((List)rampRes.v1).size() == 1) {
            UnitDouble val = (UnitDouble)((List)rampRes.v1).iterator().next();
            result = (Boolean)rampRes.v2 != false ? new DblLessThanOp(val) : new DblGreaterThanOp(val);
        } else {
            result = new CustomCtrl((boolean)((Boolean)rampRes.v2), (Collection)rampRes.v1);
        }
        this.markInputRetrieval(rec, result);
        this.d_doubleInCtrls.add(result);
        return result;
    }

    private static Pair<List<UnitDouble>, Boolean> parseCustomRamp(Ramp ramp, boolean initialState) {
        boolean initValue;
        List<Ramp.Entry> entries = ramp.getRecords();
        if (entries.isEmpty()) {
            return new Pair<List<UnitDouble>, Boolean>(new ArrayList(), false);
        }
        TreeMap<Double, Double> vals = new TreeMap<Double, Double>();
        for (Ramp.Entry entry : entries) {
            UnitDouble val = entry.t;
            vals.put(val.getValueNoUnit(), entry.f.getValueNoUnit());
        }
        ArrayList<UnitDouble> crossings = new ArrayList<UnitDouble>();
        boolean bl = initValue = (Double)vals.values().iterator().next() >= 0.0;
        if (initialState) {
            initValue = !initValue;
        }
        Iterator entryit = vals.entrySet().iterator();
        Map.Entry last = entryit.next();
        while (entryit.hasNext()) {
            Map.Entry curr = entryit.next();
            if ((Double)curr.getValue() < 0.0 && (Double)last.getValue() >= 0.0 || (Double)curr.getValue() >= 0.0 && (Double)last.getValue() < 0.0) {
                double m = ((Double)curr.getValue() - (Double)last.getValue()) / ((Double)curr.getKey() - (Double)last.getKey());
                double b = (Double)curr.getValue() - m * (Double)curr.getKey();
                double crossing = -b / m;
                crossings.add(new UnitDouble(crossing, Unit.ONE));
            }
            last = curr;
        }
        return new Pair<List<UnitDouble>, Boolean>(crossings, initValue);
    }

    private IControl parseTimeDelay(FDSParseRecord rec) {
        UnitDouble delay = (UnitDouble)rec.get("DELAY", true);
        TimeDelayCtrl ctrl = new TimeDelayCtrl(delay);
        this.markInputRetrieval(rec, ctrl);
        return this.parseInvertAndLatch(rec, ctrl);
    }

    private IControl parseAll(FDSParseRecord rec) {
        AndOp op = new AndOp();
        this.markInputRetrieval(rec, op);
        return this.parseInvertAndLatch(rec, op);
    }

    private IControl parseAny(FDSParseRecord rec) {
        OrOp op = new OrOp();
        this.markInputRetrieval(rec, op);
        return this.parseInvertAndLatch(rec, op);
    }

    private IControl parseAtLeast(FDSParseRecord rec) {
        CountOp summer = new CountOp();
        this.markInputRetrieval(rec, summer);
        boolean initState = rec.getBoolean("INITIAL_STATE", true);
        int num = rec.getInteger("N", true);
        AIntCompareOp ctrl = initState ? new IntLessThanOp(num) : new IntGreaterThanOp(num - 1);
        ctrl.getInputPin().connect(summer.getOutputPins().get(0));
        return this.parseLatch(rec, ctrl);
    }

    private IControl parseOnly(FDSParseRecord rec) {
        CountOp summer = new CountOp();
        this.markInputRetrieval(rec, summer);
        boolean initState = rec.getBoolean("INITIAL_STATE", true);
        int num = rec.getInteger("N", true);
        AIntCompareOp ctrl = initState ? new IntNotEqualOp(num) : new IntEqualOp(num);
        ctrl.getInputPin().connect(summer.getOutputPins().get(0));
        return this.parseLatch(rec, ctrl);
    }

    private IControl parseInvertAndLatch(FDSParseRecord rec, IControl existing) {
        return this.parseInvert(rec, this.parseLatch(rec, existing));
    }

    private IControl parseLatch(FDSParseRecord rec, IControl existing) {
        boolean latch = rec.getBoolean("LATCH", true);
        if (latch) {
            LatchCtrl ctrl = new LatchCtrl();
            ctrl.getInputPin().connect(existing.getOutputPins().get(0));
            return ctrl;
        }
        return existing;
    }

    private IControl parseInvert(FDSParseRecord rec, IControl existing) {
        boolean initState = rec.getBoolean("INITIAL_STATE", true);
        if (initState) {
            NotOp op = new NotOp();
            op.getInputPin().connect(existing.getOutputPins().get(0));
            return op;
        }
        return existing;
    }

    private void registerConstantInput(FDSParseRecord rec, AMathOp op) {
        if (rec.contains("CONSTANT")) {
            this.d_pinConns.addConstantMathSource(op.getInputPin(), rec.getDouble("CONSTANT"));
        }
    }

    private void markInputRetrieval(FDSParseRecord rec, ISignalSink ctrl) {
        List<String> inputIDs = rec.getList("INPUT_ID", false);
        this.d_pinConns.markInputForRetrieval(rec, ctrl.getInputPin(), inputIDs);
    }
}

