/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.swing.JOptionPane;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import thunderheadeng.gui.Application;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;

public class POVRayWriter {
    private static final String nl = System.getProperty("line.separator");

    public static void writePOVRayFile(PyroSim pyro, String file, int width, int height, boolean isAntiAlias, boolean isShadows, boolean isPOVFile) {
    }

    private static Vector3d[] getPOVRayCamVecs(Camera c, double screenWidth, double screenHeight) {
        if (c instanceof PerspectiveCamera) {
            PerspectiveCamera pc = (PerspectiveCamera)c;
            double fov = pc.getFOV();
            double zoomFactor = pc.getZoom();
            Point2d zoomLoc = pc.getZoomLoc();
            double near = pc.getNearClip();
            double upLen = 2.0 * Math.tan(fov * 0.5) * near / zoomFactor;
            double rlen = upLen * screenWidth / screenHeight;
            Vector3d rightVec = pc.getRightVector();
            rightVec.normalize();
            rightVec.scale(rlen);
            Vector3d upVec = pc.getUpVector();
            upVec.normalize();
            upVec.scale(upLen);
            Vector3d dir = pc.getViewVector();
            dir.normalize();
            dir.scale(near);
            Point3d refPoint = new Point3d();
            refPoint.add(pc.getPosition(), dir);
            pc.translateEye(refPoint, new Vector3d(zoomLoc.x, zoomLoc.y, 0.0));
            dir.sub(refPoint, pc.getPosition());
            double scale = 1.0 / upVec.length();
            rightVec.scale(scale);
            upVec.scale(scale);
            dir.scale(scale);
            return new Vector3d[]{rightVec, upVec, dir};
        }
        if (c instanceof OrthoCamera) {
            OrthoCamera oc = (OrthoCamera)c;
            Vector3d dir = oc.getViewVector(oc.getReference());
            Vector3d upVec = oc.getUpVector();
            Vector3d rightVec = oc.getRightVector();
            double fov = oc.getSubjectSize();
            double zoomFactor = oc.getZoom();
            Point2d zoomLoc = oc.getZoomLoc();
            double near = oc.getNearClip();
            double upLen = fov / zoomFactor;
            double rlen = upLen * screenWidth / screenHeight;
            rightVec.normalize();
            rightVec.scale(rlen);
            upVec.normalize();
            upVec.scale(upLen);
            dir.normalize();
            dir.scale(near);
            Point3d refPoint = new Point3d();
            refPoint.add(oc.getPosition(), dir);
            oc.translateEye(refPoint, new Vector3d(zoomLoc.x, zoomLoc.y, 0.0));
            dir.cross(upVec, rightVec);
            Vector3d location = new Vector3d();
            location.set(refPoint);
            location.sub(dir);
            dir.scale(0.5);
            return new Vector3d[]{rightVec, upVec, dir, location};
        }
        return null;
    }

    private static void writeTriangle(Point3d[] points, double r, double g, double b, PrintWriter writer) {
        if (points.length == 4) {
            writer.printf("\ttriangle{ < %.4f, %.4f, %.4f>, < %.4f, %.4f, %.4f>, < %.4f, %.4f, %.4f>\n", points[0].x, points[0].y, points[0].z, points[2].x, points[2].y, points[2].z, points[3].x, points[3].y, points[3].z);
            writer.printf("\t\ttexture{pigment{color rgb < %.4f, %.4f, %.4f>} ", r / 256.0, g / 256.0, b / 256.0);
            writer.write("\t\t\tnormal {bumps .05 scale .05}}}\n");
        }
        writer.printf("\ttriangle{ < %.4f, %.4f, %.4f>, < %.4f, %.4f, %.4f>, < %.4f, %.4f, %.4f>\n", points[0].x, points[0].y, points[0].z, points[1].x, points[1].y, points[1].z, points[2].x, points[2].y, points[2].z);
        writer.printf("\t\ttexture{pigment{color rgb < %.4f, %.4f, %.4f>} ", r / 256.0, g / 256.0, b / 256.0);
        writer.write("\t\t\tnormal {bumps .05 scale .05}}}\n");
    }

    private static void writeTriangle(Point3d[] points, double h, double w, PrintWriter writer) {
        double dist1 = points[0].distance(points[1]);
        double dist2 = points[1].distance(points[2]);
        Point2d pic00 = new Point2d(0.0, 0.0);
        Point2d pic01 = new Point2d(0.0, dist2 / h);
        Point2d pic10 = new Point2d(dist1 / w, 0.0);
        Point2d pic11 = new Point2d(dist1 / w, dist2 / h);
        if (points.length == 4) {
            writer.printf("\ttriangle{ < %.4f, %.4f, %.4f>, < %.4f, %.4f, %.4f>, < %.4f, %.4f, %.4f>\n", points[3].x, points[3].y, points[3].z, points[2].x, points[2].y, points[2].z, points[1].x, points[1].y, points[1].z);
            writer.printf("\t\t uv_vectors < %.4f, %.4f>, < %.4f, %.4f>, ", pic00.x, pic00.y, pic10.x, pic10.y);
            writer.printf("<%.4f, %.4f>}\n", pic11.x, pic11.y);
        }
        writer.printf("\ttriangle{ < %.4f, %.4f, %.4f>, < %.4f, %.4f, %.4f>, < %.4f, %.4f, %.4f>\n", points[3].x, points[3].y, points[3].z, points[0].x, points[0].y, points[0].z, points[1].x, points[1].y, points[1].z);
        writer.printf("\t\t uv_vectors < %.4f, %.4f>, < %.4f, %.4f>, ", pic00.x, pic00.y, pic01.x, pic01.y);
        writer.printf("<%.4f, %.4f>}\n", pic11.x, pic11.y);
    }

    private static int runPOVRay(String ending, String outputFileName, boolean isAntiAlias, int width, int height) {
        String megaPovLocation = PyroPrefs.getString(PyroPrefs.PREF_MPOVLOCATION);
        String AA = "";
        AA = isAntiAlias ? "+A" : "-A";
        String fileType = "";
        if (ending.equals(".png")) {
            fileType = "+FN";
        } else if (ending.equals(".ppm")) {
            fileType = "+FP";
        } else if (ending.equals(".tga") || ending.equals(".targa")) {
            fileType = "+FT";
        } else {
            fileType = "+FT";
            outputFileName = outputFileName.replace(ending, ".tga");
            ending = ".tga";
        }
        File outFile = new File(outputFileName);
        String output = outFile.getName();
        String inputFileName = output.replace(ending, ".pov");
        try {
            String[] args = new String[]{"\"" + megaPovLocation + "\"", "+I" + inputFileName, "+O" + output, fileType, "-UV", "+w" + width, "+h" + height, AA};
            String[] env = null;
            File dir = new File(outputFileName).getParentFile();
            Process p = Runtime.getRuntime().exec(args, env, dir);
            InputStreamReader isr = new InputStreamReader(p.getErrorStream());
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            while (line != null) {
                line = br.readLine();
            }
            isr = new InputStreamReader(p.getInputStream());
            br = new BufferedReader(isr);
            line = br.readLine();
            while (line != null) {
                line = br.readLine();
            }
            int code = p.waitFor();
            return code;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("An unknown error ocurred while attempting to run MegaPOV."), Intl.intl("Error While Executing MegaPOV"), 0);
            return -1;
        }
    }
}

