/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.detectors.SprinklerLink;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.SprinklerLinkModelComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;

public class SprinklerLinkEditor
extends ADevcEditor<SprinklerLink> {
    private final SprinklerLinkDataPanel d_dataPanel;

    public SprinklerLinkEditor(PyroMod pyMod) {
        this.d_dataPanel = new SprinklerLinkDataPanel(pyMod);
    }

    @Override
    public String getDesc() {
        return Intl.intl("Sprinkler Link");
    }

    @Override
    public String getDefName() {
        return Intl.intl("SLINK");
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new FreePointGeomEditor();
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    @Override
    public boolean validateData(Component parent, SprinklerLink loadedObj, boolean showWarn, boolean allowModify) {
        return true;
    }

    @Override
    public SprinklerLink create() {
        return new SprinklerLink("", this.d_dataPanel.getSprinklerLinkModel(), new FreePointLoc());
    }

    @Override
    public void load(SprinklerLink sl) {
        this.d_dataPanel.setSprinklerLinkModel(sl.getModel());
    }

    @Override
    public void save(SprinklerLink link) {
        link.setModel(this.d_dataPanel.getSprinklerLinkModel());
    }

    public static class SprinklerLinkDataPanel
    extends guiPanel {
        private static final long serialVersionUID = 7485619082615631763L;
        private final guiComboBox<SprinklerLinkModel> d_typeCombo;

        public SprinklerLinkDataPanel(PyroMod pyMod) {
            this.setLayout(new GridBagLayout());
            this.d_typeCombo = new SprinklerLinkModelComboBox(pyMod.getSprinklerLinkModels());
            this.d_typeCombo.setMinimumSize(this.d_typeCombo.getPreferredSize());
            JButton d_editSprinkLink = new JButton(Intl.intl("Edit") + "...");
            d_editSprinkLink.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Actions.editSprinklerLinkModels((SprinklerLinkModel)d_typeCombo.getSelectedItem());
                    if (d_typeCombo.getSelectedItem() == null && d_typeCombo.getItemCount() > 0) {
                        d_typeCombo.setSelectedIndex(0);
                    }
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Type:"), this.d_typeCombo, d_editSprinkLink, 0);
            gb.finalizeRows();
        }

        public SprinklerLinkModel getSprinklerLinkModel() {
            return this.d_typeCombo.getSelectedItem();
        }

        public void setSprinklerLinkModel(SprinklerLinkModel spl) {
            this.d_typeCombo.setSelectedItem(spl);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (this.d_typeCombo.getSelectedItem() == null) {
                if (showWarn) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Please choose a type."));
                }
                if (allowModify) {
                    this.d_typeCombo.requestFocus();
                }
                return false;
            }
            return true;
        }
    }
}

