/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JButton;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.ControlMgr;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.devices.ControlValueDevice;
import pyrosim.domain.devices.DeviceManager;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.GaugeHeatFluxGasMeasurer;
import pyrosim.domain.devices.measurers.Thermocouple;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.PyroComboBox;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.MsrDeviceEditorUtil;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Sets;

public class GasPointDevcEditor
extends ADevcEditor<GasPointMeasurer> {
    private final String d_desc;
    private final String d_defName;
    private final GasPointDeviceDataPanel d_dataPanel;
    private final IQuantity d_fixedMsr;

    public GasPointDevcEditor(PyroMod pyMod, IDevcEditor.Mode mode) {
        this(pyMod, Intl.intl("Gas-phase Device"), Intl.intl("GAS"), null, mode);
    }

    public GasPointDevcEditor(PyroMod pyMod, String desc, String defName, IQuantity type, IDevcEditor.Mode mode) {
        this.d_desc = desc;
        this.d_defName = defName;
        this.d_dataPanel = new GasPointDeviceDataPanel(pyMod, type, mode);
        this.d_fixedMsr = type;
    }

    @Override
    public String getDefName() {
        return this.d_defName;
    }

    @Override
    public String getDesc() {
        return this.d_desc;
    }

    @Override
    public Collection<String> getCustomTypes() {
        HashSet<String> types = new HashSet<String>();
        GasPointMeasurer.getCustomFDSTypes((IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem(), types);
        return types;
    }

    @Override
    public Set<String> getFDSPreviewTypes() {
        return Sets.fromArrayHS("PROP", "DEVC");
    }

    @Override
    public AlarmInfoPanel createAlarmPanel() {
        AlarmInfoPanel alarmPanel = new AlarmInfoPanel((IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem());
        this.d_dataPanel.d_measCombo.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                alarmPanel.setCurrentMsr((IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem());
            }
        });
        if (this.d_fixedMsr != null) {
            alarmPanel.setCurrentMsr(this.d_fixedMsr);
        }
        return alarmPanel;
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new FreePointGeomEditor();
    }

    @Override
    public void load(GasPointMeasurer gpm) {
        this.d_dataPanel.load(gpm);
    }

    @Override
    public GasPointMeasurer create() {
        return this.d_dataPanel.create("");
    }

    @Override
    public void save(GasPointMeasurer msr) {
        this.d_dataPanel.save(msr);
    }

    @Override
    public boolean validateData(Component parent, GasPointMeasurer loadedObj, boolean showWarn, boolean allowModify) {
        return MsrDeviceEditorUtil.validateData(parent, loadedObj, (IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem(), showWarn, allowModify);
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    public static class GasPointDeviceDataPanel
    extends guiPanel {
        private static final long serialVersionUID = 3844599879929888196L;
        private final IDevcEditor.Mode d_mode;
        private final DeviceManager d_mgr;
        private final QuantityComboBox d_measCombo;
        private final ThermocoupleProps d_thermocouplePanel;
        private final GaugeHeatFluxGasProps d_gaugeHeatFluxGasPanel;

        public GasPointDeviceDataPanel(PyroMod pyMod, IQuantity defType, IDevcEditor.Mode mode) {
            this.d_mgr = pyMod.getDevices();
            this.d_mode = mode;
            this.setLayout(new GridBagLayout());
            this.d_measCombo = new QuantityComboBox(GasPointMeasurer.getOutputType(), GasPointMeasurer.getQuantityType());
            this.d_thermocouplePanel = new ThermocoupleProps();
            this.d_gaugeHeatFluxGasPanel = new GaugeHeatFluxGasProps();
            this.d_measCombo.setMinimumSize(this.d_measCombo.getPreferredSize());
            this.d_measCombo.addItemListener(arg0 -> this.updateCardSelect());
            if (defType != null) {
                this.d_measCombo.setSelectedItem(defType);
            }
            if (mode == IDevcEditor.Mode.EDIT) {
                this.d_measCombo.setEnabled(false);
            }
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Quantity:"), this.d_measCombo, 0);
            gb.addRow(this.d_thermocouplePanel, 0, 1.0);
            gb.addRow(this.d_gaugeHeatFluxGasPanel, 0, 1.0);
            gb.finalizeRows();
            this.updateCardSelect();
        }

        private void updateCardSelect() {
            IQuantity sel = (IQuantity)this.d_measCombo.getSelectedItem();
            this.d_thermocouplePanel.setVisible(sel.get().equals((Object)Quantity.THERMOCOUPLE));
            this.d_gaugeHeatFluxGasPanel.setVisible(sel.get().equals((Object)Quantity.GAUGE_HEAT_FLUX_GAS));
            PyroGuiUtil.pack(this);
        }

        public void load(GasPointMeasurer gpm) {
            boolean enableCombo = this.d_mode == IDevcEditor.Mode.CREATE;
            Predicate<Quantity> msrFilter = this.d_measCombo.getFilter();
            if (gpm instanceof Thermocouple) {
                Thermocouple tc = (Thermocouple)gpm;
                this.d_thermocouplePanel.load(tc);
                this.d_measCombo.setEnabled(enableCombo);
            } else if (gpm instanceof GaugeHeatFluxGasMeasurer) {
                GaugeHeatFluxGasMeasurer ghfgm = (GaugeHeatFluxGasMeasurer)gpm;
                this.d_gaugeHeatFluxGasPanel.load(ghfgm);
                this.d_measCombo.setEnabled(enableCombo);
            } else if (this.d_mode == IDevcEditor.Mode.EDIT) {
                Predicate<Quantity> reject = Filters.reject(Quantity.THERMOCOUPLE, Quantity.GAUGE_HEAT_FLUX_GAS);
                msrFilter = msrFilter.and(reject);
                this.d_measCombo.setEnabled(true);
            }
            this.d_measCombo.setSelectedItem(gpm.getQuantity());
            this.d_measCombo.setFilter(msrFilter);
            this.updateCardSelect();
        }

        public GasPointMeasurer create(String name) {
            if (((IQuantity)this.d_measCombo.getSelectedItem()).get().equals((Object)Quantity.THERMOCOUPLE)) {
                return new Thermocouple(name, new FreePointLoc());
            }
            if (((IQuantity)this.d_measCombo.getSelectedItem()).get().equals((Object)Quantity.GAUGE_HEAT_FLUX_GAS)) {
                return new GaugeHeatFluxGasMeasurer(name, new FreePointLoc());
            }
            return new GasPointMeasurer(name, (IQuantity)this.d_measCombo.getSelectedItem(), new FreePointLoc());
        }

        public void save(GasPointMeasurer msr) {
            if (msr instanceof Thermocouple) {
                assert (((IQuantity)this.d_measCombo.getSelectedItem()).get().equals((Object)Quantity.THERMOCOUPLE));
                Thermocouple tc = (Thermocouple)msr;
                this.d_thermocouplePanel.save(tc);
            } else if (msr instanceof GaugeHeatFluxGasMeasurer) {
                assert (((IQuantity)this.d_measCombo.getSelectedItem()).get().equals((Object)Quantity.GAUGE_HEAT_FLUX_GAS));
                GaugeHeatFluxGasMeasurer ghfg = (GaugeHeatFluxGasMeasurer)msr;
                this.d_gaugeHeatFluxGasPanel.save(ghfg);
            } else {
                IQuantity newMsr = (IQuantity)this.d_measCombo.getSelectedItem();
                UnitSystem us = PyroSim.getApp().getUnitSystem();
                Unit newUnit = us.getUnit(newMsr.get().unitType);
                msr.setQuantity(newMsr, newUnit);
            }
        }
    }

    private static class GaugeHeatFluxGasProps
    extends guiPanel {
        private static final long serialVersionUID = 904712893678455209L;
        private ValueField<UnitDouble> d_gaugeTemperature;
        private ValueField<UnitDouble> d_heatTransferCoeff;
        private guiCheckBox d_enableHeatTransferCoeff = new guiCheckBox(Intl.intl("Enable Heat Transfer Coefficient:"));

        public GaugeHeatFluxGasProps() {
            this.d_heatTransferCoeff = ValueFields.udFld(UnitSystem.getSource(81));
            this.d_gaugeTemperature = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_gaugeTemperature.setNullAllowed(true);
            ValueFields.getFormat(this.d_gaugeTemperature).alias(null, "TMPA");
            this.d_gaugeTemperature.setValue(null);
            this.d_heatTransferCoeff.setEnabled(false);
            this.d_enableHeatTransferCoeff.addChangeListener(evt -> this.d_heatTransferCoeff.setEnabled(this.d_enableHeatTransferCoeff.isSelected()));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Gauge Temperature:"), this.d_gaugeTemperature, 0);
            gb.addRow(this.d_enableHeatTransferCoeff, this.d_heatTransferCoeff, 0);
            gb.finalizeRows();
            this.load(new GaugeHeatFluxGasMeasurer("", null));
        }

        public void load(GaugeHeatFluxGasMeasurer ghfg) {
            this.d_gaugeTemperature.setValue(ghfg.getGaugeTemperature());
            this.d_heatTransferCoeff.setValue(ghfg.getHeatTransferCoefficient());
            boolean isNull = this.d_heatTransferCoeff.getValue() == null;
            this.d_enableHeatTransferCoeff.setSelected(!isNull);
            if (isNull) {
                this.d_heatTransferCoeff.setValue(new UnitDouble(0.0, SIUS.unit(81)));
            }
        }

        public void save(GaugeHeatFluxGasMeasurer ghfg) {
            ghfg.setGaugeTemperature((UnitDouble)this.d_gaugeTemperature.getValue());
            ghfg.setHeatTransferCoefficient(this.d_enableHeatTransferCoeff.isSelected() ? (UnitDouble)this.d_heatTransferCoeff.getValue() : null);
        }
    }

    private static class ThermocoupleProps
    extends guiPanel {
        private static final long serialVersionUID = 904712893678455207L;
        private ValueField<UnitDouble> d_beadDiam = ValueFields.udFld(UnitSystem.getSource(9));
        private ValueField<Double> d_emissivity = ValueFields.doubleFld();
        private ValueField<UnitDouble> d_beadDensity = ValueFields.udFld(UnitSystem.getSource(4));
        private ValueField<UnitDouble> d_beadSpecHeat = ValueFields.udFld(UnitSystem.getSource(11));

        public ThermocoupleProps() {
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Bead Diameter:"), this.d_beadDiam);
            gb.addRow(Intl.intl("Emissivity:"), this.d_emissivity);
            gb.addRow(Intl.intl("Bead Density:"), this.d_beadDensity);
            gb.addRow(Intl.intl("Bead Specific Heat:"), this.d_beadSpecHeat);
            gb.finalizeRows();
            this.load(new Thermocouple("", null));
        }

        public void load(Thermocouple tc) {
            this.d_beadDiam.setValue(tc.getBeadDiameter());
            this.d_emissivity.setValue(tc.getEmissivity());
            this.d_beadDensity.setValue(tc.getBeadDensity());
            this.d_beadSpecHeat.setValue(tc.getBeadSpecHeat());
        }

        public void save(Thermocouple tc) {
            tc.setBeadDiameter((UnitDouble)this.d_beadDiam.getValue());
            tc.setEmissivity((Double)this.d_emissivity.getValue());
            tc.setBeadDensity((UnitDouble)this.d_beadDensity.getValue());
            tc.setBeadSpecHeat((UnitDouble)this.d_beadSpecHeat.getValue());
        }
    }

    public static class ControlValueDeviceProps
    extends guiPanel {
        static final long serialVersionUID = 1L;
        private final guiComboBox<ControlBridge> d_controlCombo;

        public ControlValueDeviceProps(PyroMod pyMod) {
            this.setLayout(new GridBagLayout());
            this.d_controlCombo = new ControlBridgeComboBox(pyMod.getControls());
            this.d_controlCombo.setMinimumSize(this.d_controlCombo.getPreferredSize());
            JButton editControlsBtn = new JButton(Intl.intl("Edit..."));
            editControlsBtn.addActionListener(e -> {
                Actions.editControls(this.d_controlCombo.getSelectedItem());
                if (this.d_controlCombo.getSelectedItem() == null && this.d_controlCombo.getItemCount() > 0) {
                    this.d_controlCombo.setSelectedIndex(0);
                }
            });
            GridBagHelper gbh = new GridBagHelper(this);
            gbh.addRow(Intl.intl("Control:"), this.d_controlCombo, editControlsBtn);
            gbh.finalizeRows();
        }

        public void load(ControlValueDevice devc) {
            this.d_controlCombo.setSelectedItem(devc.getLinkedControl());
        }

        public void save(ControlValueDevice devc) {
            devc.setLinkedControl(this.d_controlCombo.getSelectedItem());
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (this.d_controlCombo.getSelectedItem() == null) {
                if (showWarn) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Please choose a Control."));
                }
                if (allowModify) {
                    this.d_controlCombo.requestFocus();
                }
                return false;
            }
            return true;
        }

        public static class ControlBridgeComboBox
        extends PyroComboBox<ControlBridge> {
            static final long serialVersionUID = 1L;

            public ControlBridgeComboBox(ControlMgr mgr) {
                super(mgr, ControlBridge.class);
                this.setFilter(cb -> ControlBridgeComboBox.isCustomControlBridge(cb) || ControlBridgeComboBox.isMathematicControlBridge(cb));
            }

            private static boolean isCustomControlBridge(ControlBridge cb) {
                if (cb.getInputPin().getConnections().size() > 0) {
                    ISignalSource src = cb.getInputPin().getConnectedSources().iterator().next();
                    return src instanceof CustomCtrl;
                }
                return false;
            }

            private static boolean isMathematicControlBridge(ControlBridge cb) {
                return cb.isMathControl();
            }
        }
    }
}

