/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.controls;

import java.awt.Dimension;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.TableModel;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.SignalInput;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.gui.RampFuncDlg;
import pyrosim.gui.controls.ControlDesc;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;

public class RampActivationPanel
extends guiPanel {
    static final long serialVersionUID = 1L;
    private final guiComboBox<IRampInput> d_rampInputs;
    private final IRampInput d_defRampInput;
    private final guiTableEditor d_editor;
    private final guiTable d_table;
    private ControlDesc.SinkType d_sinkType = ControlDesc.SinkType.ACTIVATE;

    public RampActivationPanel() {
        IDoubleOutPin clock = (IDoubleOutPin)Clock.INSTANCE.getOutputPins().get(0);
        this.d_defRampInput = new SignalInput(clock);
        Collection<IRampInput> rampInputs = RampFuncDlg.getRampInputs(this.d_defRampInput);
        this.d_rampInputs = RampFuncDlg.createInputCombo(rampInputs);
        this.d_rampInputs.addItemListener(e -> this.updateInputHeader(this.d_rampInputs.getSelectedItem()));
        String[] headers = new String[]{"", Intl.intl("Event")};
        Class[] columnClasses = new Class[]{Double.class, String.class};
        this.d_table = guiTableUtil.fixedColumnTable(headers, columnClasses);
        this.d_editor = new guiTableEditor(this.d_table, 30);
        this.d_table.setNullValuesAllowed(false);
        this.d_editor.setPreferredSize(new Dimension(350, 250));
        this.d_table.setColumnOptions(1, new Activation(true), new Activation(false));
        GridBagHelper gbh = new GridBagHelper(this);
        gbh.addRow(Intl.intl("Function Input:"), this.d_rampInputs);
        gbh.addRow(this.d_editor, new double[]{1.0, 1.0}, GridBagHelper.REMAINING);
        this.d_table.autoSizeColumns(200);
        gbh.finalizeRows();
        this.updateInputHeader(this.d_defRampInput);
        this.d_rampInputs.setSelectedItem(this.d_defRampInput);
    }

    private void updateInputHeader(IRampInput input) {
        String desc = RampFuncDlg.formatColHeader(input.getName(), input.getUnitType());
        this.d_table.getColumnModel().getColumn(0).setHeaderValue(desc);
        this.repaint();
    }

    public void setSinkType(ControlDesc.SinkType sinkType) {
        this.d_sinkType = sinkType;
        this.repaint();
    }

    private Map<UnitDouble, Boolean> parseRampTable(Unit tUnit) {
        TableModel model = this.d_editor.getTable().getModel();
        TreeMap<UnitDouble, Boolean> rampMap = new TreeMap<UnitDouble, Boolean>();
        for (int i = 0; i < model.getRowCount(); ++i) {
            UnitDouble tripVal = new UnitDouble((Double)model.getValueAt(i, 0), tUnit);
            Activation act = (Activation)model.getValueAt(i, 1);
            if (tripVal == null || act == null) continue;
            rampMap.put(tripVal, act.value);
        }
        return rampMap;
    }

    public void load(CustomCtrl ctrl, boolean invert) {
        int tUnitType;
        if (ctrl.getInputPin().getConnections().size() == 0) {
            this.d_rampInputs.setSelectedItem(this.d_defRampInput);
            tUnitType = this.d_defRampInput.getUnitType();
        } else {
            IDoubleOutPin originPin = (IDoubleOutPin)ctrl.getInputPin().getConnections().iterator().next();
            SignalInput input = new SignalInput(originPin);
            this.d_rampInputs.setSelectedItem(input);
            tUnitType = originPin.getUnitType();
        }
        Unit tUnit = PyroSim.getApp().getUnitSystem().getUnit(tUnitType);
        boolean lastState = ctrl.getInitialState() ^ invert;
        int row = 0;
        this.d_table.clearRows();
        for (UnitDouble val : ctrl.getTripValues()) {
            boolean currState = !lastState;
            this.d_table.getModel().setValueAt(val.getValue(tUnit), row, 0);
            this.d_table.getModel().setValueAt(new Activation(currState), row, 1);
            ++row;
            lastState = currState;
        }
        this.d_table.repaint();
    }

    public ILogicOutPin save() {
        IDoubleOutPin originPin = ((SignalInput)this.d_rampInputs.getSelectedItem()).input;
        Unit tUnit = PyroSim.getApp().getUnitSystem().getUnit(originPin.getUnitType());
        Map<UnitDouble, Boolean> tripMap = this.parseRampTable(tUnit);
        Iterator<Map.Entry<UnitDouble, Boolean>> iter = tripMap.entrySet().iterator();
        boolean initiallyOn = true;
        if (!tripMap.isEmpty()) {
            boolean lastActivate = iter.next().getValue();
            while (iter.hasNext()) {
                Map.Entry<UnitDouble, Boolean> next = iter.next();
                if (next.getValue() == lastActivate) {
                    iter.remove();
                    continue;
                }
                lastActivate = next.getValue();
            }
            initiallyOn = tripMap.values().iterator().next() == false;
        }
        CustomCtrl ctrl = new CustomCtrl(initiallyOn, tripMap.keySet());
        ctrl.getInputPin().connect(originPin);
        return (ILogicOutPin)ctrl.getOutputPins().get(0);
    }

    private class Activation {
        public final boolean value;

        public Activation(boolean value) {
            this.value = value;
        }

        public String toString() {
            return this.value ? ((RampActivationPanel)RampActivationPanel.this).d_sinkType.strings.activate : ((RampActivationPanel)RampActivationPanel.this).d_sinkType.strings.deactivate;
        }
    }
}

