/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import pyrosim.Intl;
import pyrosim.gui.ResizableWindow;
import pyrosim.gui.controls.ControlDesc;
import pyrosim.gui.controls.ControlPnl;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.util.SortCache;

public class ControlPnlUtil {

    public static class MultiSelectHelperWindow<T>
    extends PopupWindow {
        private static final long serialVersionUID = -8784523385840655311L;
        private TableModel<T> d_tableModel;
        private guiTable d_table;
        private JButton d_okBtn;
        private JButton d_clearBtn;
        private JButton d_selAllBtn;
        private Callback<T> d_callback;

        public MultiSelectHelperWindow() {
        }

        public MultiSelectHelperWindow(Frame parent) {
            super(parent);
        }

        public MultiSelectHelperWindow(Window parent) {
            super(parent);
        }

        public boolean isEmpty() {
            return this.d_tableModel.getRowCount() == 0;
        }

        public void initAllObjs(Collection<? extends T> availObjs) {
            this.d_tableModel = new TableModel<T>(availObjs);
            if (this.d_tableModel.getRowCount() > 0) {
                this.d_table = new guiTable(this.d_tableModel, 0);
                guiTableEditor editor = new guiTableEditor(this.d_table, 0);
                this.d_table.setTableHeader(null);
                this.d_table.setShowVerticalLines(false);
                this.d_table.setColumnSelectionAllowed(false);
                this.d_table.setSelectionMode(0);
                TableCellRenderer rend = this.d_table.getCellRenderer(0, 0);
                Component comp = rend.getTableCellRendererComponent(this.d_table, Boolean.FALSE, false, false, 0, 0);
                int width = comp.getPreferredSize().width + 20;
                this.d_table.getColumnModel().getColumn(0).setMaxWidth(width);
                this.d_table.getColumnModel().getColumn(0).setMinWidth(width);
                this.d_table.setPreferredScrollableViewportSize(new Dimension(this.d_table.getPreferredSize().width, 100));
                this.d_okBtn = new JButton(Intl.intl("OK"));
                this.d_clearBtn = new JButton(Intl.intl("Clear"));
                this.d_clearBtn.addActionListener(e -> this.d_tableModel.clearSel());
                this.d_selAllBtn = new JButton(Intl.intl("Select All"));
                this.d_selAllBtn.addActionListener(e -> this.d_tableModel.selectAll());
                this.d_clearBtn.setPreferredSize(new Dimension(this.d_clearBtn.getPreferredSize().width, this.d_clearBtn.getPreferredSize().height - 4));
                this.d_selAllBtn.setPreferredSize(new Dimension(this.d_selAllBtn.getPreferredSize().width, this.d_selAllBtn.getPreferredSize().height - 4));
                final Comparator comparator = (o1, o2) -> ControlDesc.getName(o1).compareToIgnoreCase(ControlDesc.getName(o2));
                if (this.d_table.getRowCount() > 8) {
                    final guiTextField findFld = new guiTextField();
                    findFld.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyReleased(KeyEvent e) {
                            String toFind = findFld.getText();
                            if (e.getKeyCode() == 10) {
                                int selRow = d_table.getSelectedRow();
                                if (selRow >= 0) {
                                    boolean val = (Boolean)d_table.getValueAt(selRow, 0);
                                    d_table.setValueAt(!val, selRow, 0);
                                }
                                findFld.setSelectionStart(0);
                                findFld.setSelectionEnd(toFind.length());
                            } else {
                                int ix = d_tableModel.d_objCache.findGeneric(toFind, comparator);
                                if (ix < 0) {
                                    ix = -ix - 1;
                                }
                                if (ix >= d_table.getRowCount()) {
                                    ix = d_table.getRowCount() - 1;
                                }
                                d_table.setRowSelectionInterval(ix, ix);
                                Rectangle rect = d_table.getCellRect(ix, -1, true);
                                rect.height = ((MultiSelectHelperWindow)this).d_table.getVisibleRect().height;
                                d_table.scrollRectToVisible(rect);
                            }
                        }
                    });
                    guiPanel northPanel = new guiPanel(new BorderLayout());
                    northPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 6, 0));
                    northPanel.add(findFld);
                    this.add((Component)northPanel, "North");
                }
                guiLabel numSelLbl = new guiLabel("");
                this.d_tableModel.addTableModelListener(e -> this.updateSelLabel(numSelLbl));
                this.updateSelLabel(numSelLbl);
                guiPanel footerPnl = new guiPanel(new GridBagLayout());
                int row = 0;
                GridBagUtil.add(footerPnl, this.d_clearBtn, 0, ++row, 1, 1, 6, 0, 3, 6, 0, 0.0, 0.0, 17);
                GridBagUtil.add(footerPnl, this.d_selAllBtn, 1, row, 1, 1, 6, 0, 3, 0, 0, 0.0, 0.0, 17);
                GridBagUtil.add(footerPnl, numSelLbl, 0, ++row, 2, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
                GridBagUtil.add(footerPnl, this.d_okBtn, 0, ++row, 2, 1, 0, 0, 0, 0, 0, 1.0, 0.0, 13);
                this.add((Component)editor, "Center");
                this.add((Component)footerPnl, "South");
            } else {
                this.add((Component)new guiLabel(Intl.intl("There are currently no objects in the model.")), "Center");
            }
            this.pack();
        }

        private void updateSelLabel(guiLabel selLbl) {
            String tooltip = "";
            int m = 0;
            for (Integer ix : ((TableModel)this.d_tableModel).d_selObjs) {
                if (ix < 0) continue;
                Object obj = ((TableModel)this.d_tableModel).d_objCache.get(ix);
                if (m++ != 0) {
                    tooltip = tooltip + ", ";
                }
                tooltip = tooltip + ControlDesc.getName(obj);
                if (m != 10) continue;
                break;
            }
            if (m < ((TableModel)this.d_tableModel).d_selObjs.size()) {
                tooltip = tooltip + ", ...";
            }
            selLbl.setText(String.format(Intl.intl("Number selected: %d"), ((TableModel)this.d_tableModel).d_selObjs.size()));
            selLbl.setToolTipText(tooltip);
        }

        public void init(Point loc, Collection<? extends T> selObjs, Callback<T> callback) {
            this.d_callback = callback;
            this.d_tableModel.load(selObjs);
            for (ActionListener list : this.d_okBtn.getActionListeners()) {
                this.d_okBtn.removeActionListener(list);
            }
            this.d_okBtn.addActionListener(e -> {
                callback.select(this.d_tableModel.save());
                this.setVisible(false);
            });
            this.setLocation(loc);
            this.setVisible(true);
        }

        @Override
        public void commit() {
            this.d_callback.select(this.d_tableModel.save());
        }

        private static class TableModel<T>
        extends AbstractTableModel {
            private static final long serialVersionUID = 8101300018625206497L;
            private static final int COL_ENABLED = 0;
            private static final int COL_DETECTOR = 1;
            private static final int NUM_COLS = 2;
            private final SortCache<T> d_objCache;
            private final Set<Integer> d_selObjs;

            public TableModel(Collection<? extends T> availObjs) {
                this.d_objCache = new SortCache<T>(availObjs);
                this.d_selObjs = new TreeSet<Integer>();
            }

            public void selectAll() {
                for (int m = 0; m < this.d_objCache.size(); ++m) {
                    this.d_selObjs.add(m);
                }
                this.fireTableRowsUpdated(0, this.d_objCache.size() - 1);
            }

            public void clearSel() {
                this.d_selObjs.clear();
                this.fireTableRowsUpdated(0, this.d_objCache.size() - 1);
            }

            public void load(Collection<? extends T> sel) {
                this.d_selObjs.clear();
                for (T obj : sel) {
                    int ix = this.d_objCache.indexOf(obj);
                    this.d_selObjs.add(ix);
                }
                this.fireTableRowsUpdated(0, this.d_objCache.size() - 1);
            }

            public List<T> save() {
                ArrayList<T> result = new ArrayList<T>(this.d_selObjs.size());
                for (Integer ix : this.d_selObjs) {
                    if (ix == -1) continue;
                    result.add(this.d_objCache.get(ix));
                }
                return result;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return this.d_objCache.size();
            }

            @Override
            public String getColumnName(int column) {
                return "";
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 0;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return Boolean.class;
                    }
                    case 1: {
                        return String.class;
                    }
                }
                return null;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return this.d_selObjs.contains(rowIndex) ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 1: {
                        return ControlDesc.getName(this.d_objCache.get(rowIndex));
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (aValue == null) {
                    return;
                }
                switch (columnIndex) {
                    case 0: {
                        if (((Boolean)aValue).booleanValue()) {
                            this.d_selObjs.add(rowIndex);
                            break;
                        }
                        this.d_selObjs.remove(rowIndex);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                this.fireTableChanged(new TableModelEvent(this, rowIndex));
            }
        }

        public static interface Callback<T> {
            public void select(List<T> var1);
        }
    }

    public static class ListHelperWindow
    extends PopupWindow {
        private static final long serialVersionUID = 4745659433631625480L;
        private Callback d_callback;
        private JList optionsList;
        private int[] itemVals;
        private int initialSel;

        public ListHelperWindow() {
        }

        public ListHelperWindow(Frame parent) {
            super(parent);
        }

        public ListHelperWindow(Window parent) {
            super(parent);
        }

        public void init(Point loc, boolean showSearchHelper, int initialSel, int[] itemVals, final String[] itemNames, Callback callback) {
            assert (itemVals.length == itemNames.length);
            this.d_callback = callback;
            this.itemVals = itemVals;
            this.initialSel = initialSel;
            this.optionsList = new JList<String>(itemNames);
            JScrollPane sp = new JScrollPane(this.optionsList);
            this.optionsList.setSelectionMode(0);
            int iniix = -1;
            for (int m = 0; m < itemVals.length; ++m) {
                if (initialSel != itemVals[m]) continue;
                iniix = m;
                break;
            }
            this.optionsList.setSelectedIndex(iniix);
            this.optionsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() == 1) {
                        this.commitSelection();
                    }
                }
            });
            this.optionsList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                        this.commitSelection();
                    }
                }
            });
            this.getContentPane().add((Component)sp, "Center");
            if (showSearchHelper && itemVals.length > 8) {
                final Comparator comparator = (o1, o2) -> o1.compareToIgnoreCase((String)o2);
                final guiTextField findFld = new guiTextField();
                findFld.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyReleased(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            this.commitSelection();
                        } else {
                            String toFind = findFld.getText();
                            int ix = Arrays.binarySearch(itemNames, toFind, comparator);
                            if (ix < 0) {
                                ix = -ix - 1;
                            }
                            if (ix >= itemNames.length) {
                                ix = itemNames.length - 1;
                            }
                            optionsList.setSelectedIndex(ix);
                            Rectangle rect = optionsList.getCellBounds(ix, ix);
                            rect.height = ((ListHelperWindow)this).optionsList.getVisibleRect().height;
                            optionsList.scrollRectToVisible(rect);
                        }
                    }
                });
                guiPanel findPnl = new guiPanel(new BorderLayout());
                findPnl.add(findFld);
                findPnl.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
                this.add((Component)findPnl, "North");
            }
            this.requestFocus();
            this.pack();
            this.setLocation(loc);
            this.setVisible(true);
        }

        private void commitSelection() {
            this.commit();
            this.setVisible(false);
        }

        @Override
        public void commit() {
            int selix = this.optionsList.getSelectedIndex();
            int result = selix >= 0 ? this.itemVals[selix] : this.initialSel;
            this.d_callback.select(result);
        }

        public static interface Callback {
            public void select(int var1);
        }
    }

    public static class ValueFieldHelperWindow<T>
    extends PopupWindow {
        private static final long serialVersionUID = -1443765057610622078L;
        private ValueField<T> d_fld;
        private Callback<T> d_callback;

        public ValueFieldHelperWindow() {
        }

        public ValueFieldHelperWindow(Frame parent) {
            super(parent);
        }

        public ValueFieldHelperWindow(Window parent) {
            super(parent);
        }

        @Override
        public void commit() {
            this.d_callback.select(this.d_fld.getValue());
        }

        @Override
        public boolean validateData(boolean warn, boolean modify) {
            return this.d_fld.validateData(warn, modify);
        }

        public void init(Point loc, ValueField<T> fld, Callback<T> callback) {
            this.d_fld = fld;
            this.d_callback = callback;
            fld.setColumns(12);
            Consumer<EventObject> commit = e -> {
                callback.select(fld.getValue());
                this.setVisible(false);
            };
            Consumer<EventObject> cancel = e -> this.setVisible(false);
            fld.addValueListener(ValueField.VAL_COMMIT, e -> commit.accept(e));
            fld.setDefaultCommand(commit);
            fld.addValueListener(ValueField.VAL_CANCEL, e -> cancel.accept(e));
            this.getContentPane().add(fld, "Center");
            this.pack();
            this.setLocation(loc);
            this.setVisible(true);
        }

        public static interface Callback<T> {
            public void select(T var1);
        }
    }

    public static abstract class PopupWindow
    extends ResizableWindow
    implements Validateable {
        private static final long serialVersionUID = 8961210174042159198L;
        private MouseAdapter d_parentMouseListener;

        public PopupWindow() {
            this.init();
        }

        public PopupWindow(Frame parent) {
            super((Window)parent);
            this.init();
        }

        public PopupWindow(Window parent) {
            super(parent);
            this.init();
        }

        protected ControlPnl findPanel() {
            Container parent = this.getParent();
            return parent != null ? this.findPanel(parent) : null;
        }

        private ControlPnl findPanel(Container parent) {
            for (Component child : parent.getComponents()) {
                ControlPnl panel;
                if (child instanceof ControlPnl) {
                    return (ControlPnl)child;
                }
                if (!(child instanceof Container) || (panel = this.findPanel((Container)child)) == null) continue;
                return panel;
            }
            return null;
        }

        public abstract void commit();

        public boolean validateData() {
            return this.validateData(true, true);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            return true;
        }

        private List<Component> getParentComponents() {
            Container parentWindow = this.getParent();
            if (parentWindow != null) {
                ArrayList<Component> comps = new ArrayList<Component>();
                comps.add(parentWindow);
                this.getComponents(parentWindow, comps);
                return comps;
            }
            return Collections.emptyList();
        }

        private void getComponents(Container parent, List<Component> children) {
            for (Component child : parent.getComponents()) {
                children.add(child);
                if (!(child instanceof Container)) continue;
                this.getComponents((Container)child, children);
            }
        }

        private void init() {
            this.d_parentMouseListener = new ParentMouseListener();
            ActionListener closeAction = e -> this.setVisible(false);
            this.getRootPane().registerKeyboardAction(closeAction, KeyStroke.getKeyStroke(27, 0), 1);
        }

        @Override
        public void setVisible(boolean b) {
            ControlPnl pnl = this.findPanel();
            if (b) {
                for (Component comp : this.getParentComponents()) {
                    comp.addMouseListener(this.d_parentMouseListener);
                }
                if (pnl != null) {
                    pnl.setCurrentPopup(this);
                }
            }
            super.setVisible(b);
            if (!b) {
                if (pnl != null) {
                    pnl.setCurrentPopup(null);
                }
                for (Component comp : this.getParentComponents()) {
                    comp.removeMouseListener(this.d_parentMouseListener);
                }
                this.dispose();
            }
        }

        private class ParentMouseListener
        extends MouseAdapter {
            private ParentMouseListener() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getComponent() instanceof guiDialog.OkBtn || e.getComponent() instanceof guiDialog.ApplyBtn) {
                    return;
                }
                SwingUtilities.invokeLater(() -> PopupWindow.this.setVisible(false));
            }
        }
    }
}

