/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.controls;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.INamed;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.controls.DeadbandCtrl;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.LatchCtrl;
import pyrosim.domain.controls.LogicOps.ADblCompareOp;
import pyrosim.domain.controls.LogicOps.AIntCompareOp;
import pyrosim.domain.controls.LogicOps.ALogicOp;
import pyrosim.domain.controls.LogicOps.AndOp;
import pyrosim.domain.controls.LogicOps.DblGreaterThanOp;
import pyrosim.domain.controls.LogicOps.IntEqualOp;
import pyrosim.domain.controls.LogicOps.IntGreaterThanOp;
import pyrosim.domain.controls.LogicOps.IntLessThanOp;
import pyrosim.domain.controls.LogicOps.NotOp;
import pyrosim.domain.controls.LogicOps.OrOp;
import pyrosim.domain.controls.MathOps.CountOp;
import pyrosim.domain.controls.TimeDelayCtrl;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreezable;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IIntegerOutPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.gui.controls.ICtrlDescStringFormatter;
import thunderheadeng.gui.Utils;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;

public class ControlDesc {
    public static final int ACTION_ACTIVATE = 0;
    public static final int ACTION_DEACTIVATE = 1;
    public static final int INPUT_TIME = 0;
    public static final int INPUT_DEVICE = 1;
    public static final int INPUT_DEADBAND = 2;
    public static final int INPUT_MANUAL = 3;
    public static final int INPUT_CUSTOM = 4;
    public static final int INPUT_MATHEMATIC = 5;
    public static final int LOGIC_OR = 0;
    public static final int LOGIC_AND = 1;
    public static final int LOGIC_GE = 2;
    public static final int LOGIC_LE = 3;
    public static final int LOGIC_EQ = 4;
    public static final String TBEGIN = Intl.intl("TBEGIN");
    public static final String HREF_SINKS = "SINKS";
    public static final String HREF_LOGIC = "LOGIC";
    public static final String HREF_DETSOURCES = "DETSOURCES";
    public static final String HREF_ACTIVATE = "ACTIVATE";
    public static final String HREF_N = "N";
    public static final String HREF_T = "T";
    public static final String HREF_DBLOWERV = "DBLOWERV";
    public static final String HREF_DBUPPERV = "DBUPPERV";
    public static final String HREF_DBLOWERL = "DBLOWERL";
    public static final String HREF_DBUPPERL = "DBUPPERL";
    public static final String HREF_MSRSOURCE = "MSRSOURCES";
    public static final String HREF_DELAY = "DELAY";
    public static final String HREF_CUSTOMINPUT = "CUSTOMINPUT";
    private final boolean d_editable;
    private final boolean d_displaySinks;
    public int d_action;
    public int d_input;
    public Collection<String> d_dstObjNames = null;
    public Collection<? extends ISignalSink> d_dstObjs = Collections.emptyList();
    public List<? extends ILogicOutPin> d_srcDetectors = Collections.emptyList();
    public int d_logicType = 0;
    public int d_n = 1;
    public boolean d_sourceActivates = true;
    public UnitDouble d_delay = new UnitDouble(0.0, SI.SECOND);
    public UnitDouble d_t = null;
    public IDoubleOutPin d_srcMeasurer = null;
    public boolean d_dbUpper = true;
    public UnitDouble[] d_dbRange = new UnitDouble[]{new UnitDouble(23.0, SI.CELSIUS), new UnitDouble(27.0, SI.CELSIUS)};
    public int d_dbRangeType = 1;
    public String d_customCtrlName = null;

    public ControlDesc(boolean editable, boolean displaySinks) {
        this.d_editable = editable;
        this.d_displaySinks = displaySinks;
    }

    private void changed() {
    }

    public static String getName(Object obj) {
        if (obj instanceof IOutPin) {
            return ControlDesc.getName((IOutPin)obj);
        }
        if (obj instanceof INamed) {
            return ((INamed)obj).getName();
        }
        return obj.toString();
    }

    public static String getName(IOutPin pin) {
        if (pin.getAttachedSource() == null || !(pin.getAttachedSource() instanceof INamed)) {
            return pin.getName();
        }
        ISignalSource src = pin.getAttachedSource();
        String baseName = ((INamed)((Object)src)).getName();
        int alike = ControlDesc.countAlikePins(src, pin);
        if (alike <= 1) {
            return baseName;
        }
        return baseName + "->" + pin.getName();
    }

    private static int countAlikePins(ISignalSource src, IOutPin pin) {
        int alikePins = 0;
        Class testClazz = pin instanceof ILogicOutPin ? ILogicOutPin.class : (pin instanceof IIntegerOutPin ? IIntegerOutPin.class : IDoubleOutPin.class);
        for (IOutPin iOutPin : src.getOutputPins()) {
            if (!testClazz.isInstance(iOutPin)) continue;
            ++alikePins;
        }
        return alikePins;
    }

    public void setData(int action, int input) {
        this.d_action = action;
        this.d_input = input;
    }

    public void setCustomCtrlName(String name) {
        this.d_customCtrlName = name;
        this.changed();
    }

    public void setDelay(UnitDouble val) {
        this.d_delay = val;
        this.changed();
    }

    public void setDBBound(UnitDouble val, boolean lower) {
        if (lower) {
            this.d_dbRange[0] = val;
        } else {
            this.d_dbRange[1] = val;
        }
        this.changed();
    }

    public void setDBLogic(boolean activate, boolean lower) {
        this.d_dbUpper = lower ? !activate : activate;
        this.changed();
    }

    public void setLogicType(int val) {
        this.d_logicType = val;
        this.changed();
    }

    public void setN(int val) {
        this.d_n = val;
        this.changed();
    }

    public void setT(UnitDouble val) {
        this.d_t = val;
        this.changed();
    }

    public void setSourceMeasurer(IDoubleOutPin measurerPin) {
        this.d_srcMeasurer = measurerPin;
        if (measurerPin != null) {
            this.d_dbRangeType = measurerPin.getUnitType();
            Unit unit = PyroSim.getApp().getUnitSystem().getUnit(this.d_dbRangeType);
            this.d_dbRange[0] = this.d_dbRange[0].reinterpret(unit);
            this.d_dbRange[1] = this.d_dbRange[1].reinterpret(unit);
        }
        this.changed();
    }

    public void setSourceActivates(boolean activates) {
        this.d_sourceActivates = activates;
        this.changed();
    }

    public void setSources(List<? extends ILogicOutPin> sources) {
        this.d_srcDetectors = sources;
        this.changed();
    }

    public void setSinks(Collection<? extends ISignalSink> sinks) {
        this.d_dstObjNames = null;
        this.d_dstObjs = sinks;
        this.changed();
    }

    public void setSinkNames(Collection<String> names) {
        this.d_dstObjNames = names;
        this.d_dstObjs = Collections.emptyList();
        this.changed();
    }

    private <T> String getListStr(Collection<? extends T> objs) {
        if (objs.isEmpty()) {
            return Intl.intl("&lt;nothing&gt;");
        }
        String str = "&lt;";
        int maxNumObjs = 2;
        int m = 0;
        int maxM = Math.min(2, objs.size());
        for (T obj : objs) {
            if (m != 0) {
                str = str + ", ";
            }
            str = str + ControlDesc.getName(obj);
            if (++m < maxM) continue;
            break;
        }
        if (objs.size() > 2) {
            str = str + ", ...";
        }
        str = str + "&gt;";
        return str;
    }

    private String getCustomInputStr() {
        if (this.d_customCtrlName == null) {
            return Intl.intl("&lt;nothing&gt;");
        }
        return this.d_customCtrlName;
    }

    private String getSinksStr() {
        if (!this.d_displaySinks) {
            return null;
        }
        Collection<Object> objs = this.d_dstObjNames != null ? this.d_dstObjNames : this.d_dstObjs;
        return this.getListStr(objs);
    }

    private String getInputDetectorsStr() {
        return this.getListStr(this.d_srcDetectors);
    }

    private String getInputMeasurerStr() {
        if (this.d_srcMeasurer == null) {
            return Intl.intl("&lt;nothing&gt;");
        }
        return ControlDesc.getName(this.d_srcMeasurer);
    }

    private String format(String htmlMsg, Object ... args) {
        String ix;
        StringBuffer buf = new StringBuffer(htmlMsg.length());
        Pattern pattern = Pattern.compile("\\<\\%([0-9]+)\\>");
        Matcher matcher = pattern.matcher(htmlMsg);
        while (matcher.find()) {
            ix = matcher.group(1);
            int i = Integer.parseInt(ix);
            if (this.d_editable) {
                matcher.appendReplacement(buf, "<a href=\"%" + i + "\\$s\">%" + (i + 1) + "\\$s</a>");
                continue;
            }
            matcher.appendReplacement(buf, "%" + (i + 1) + "\\$s");
        }
        matcher.appendTail(buf);
        htmlMsg = buf.toString();
        buf.setLength(0);
        pattern = Pattern.compile("\\<\\%([0-9]+)([^\\>.]+)\\>");
        matcher = pattern.matcher(htmlMsg);
        while (matcher.find()) {
            ix = matcher.group(1);
            String str = matcher.group(2);
            int i = Integer.parseInt(ix);
            if (this.d_editable) {
                matcher.appendReplacement(buf, "<a href=\"%" + i + "\\$s\">" + str + "</a>");
                continue;
            }
            matcher.appendReplacement(buf, str);
        }
        matcher.appendTail(buf);
        htmlMsg = buf.toString();
        return String.format(htmlMsg, args);
    }

    public String formatMessage(SinkType sinkType) {
        ICtrlDescStringFormatter.Strings strings = sinkType.strings;
        String str = "";
        if (this.d_input != 3) {
            if (this.d_input == 1) {
                String sinksStr = this.getSinksStr();
                String inputStr = this.getInputDetectorsStr();
                if (this.d_srcDetectors.size() <= 1) {
                    if (this.d_action == 0 && this.d_sourceActivates) {
                        str = strings.formatActivateWhenActivate(this.d_editable, sinksStr, inputStr);
                    } else if (this.d_action == 0 && !this.d_sourceActivates) {
                        str = strings.formatActivateWhenDeactivate(this.d_editable, sinksStr, inputStr);
                    } else if (this.d_action == 1 && this.d_sourceActivates) {
                        str = strings.formatDeactivateWhenActivate(this.d_editable, sinksStr, inputStr);
                    } else if (this.d_action == 1 && !this.d_sourceActivates) {
                        str = strings.formatDeactivateWhenDeactivate(this.d_editable, sinksStr, inputStr);
                    }
                } else if (this.d_action == 0 && this.d_logicType == 0 && this.d_sourceActivates) {
                    str = strings.formatActivateWhenAnyActivate(this.d_editable, sinksStr, inputStr);
                } else if (this.d_action == 0 && this.d_logicType == 0 && !this.d_sourceActivates) {
                    str = strings.formatActivateWhenAnyDeactivate(this.d_editable, sinksStr, inputStr);
                } else if (this.d_action == 0 && this.d_logicType == 1 && this.d_sourceActivates) {
                    str = strings.formatActivateWhenAllActivate(this.d_editable, sinksStr, inputStr);
                } else if (this.d_action == 0 && this.d_logicType == 1 && !this.d_sourceActivates) {
                    str = strings.formatActivateWhenAllDeactivate(this.d_editable, sinksStr, inputStr);
                } else if (this.d_action == 0 && this.d_logicType == 3 && this.d_sourceActivates) {
                    str = strings.formatActivateWhenNoMoreThanActivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 0 && this.d_logicType == 3 && !this.d_sourceActivates) {
                    str = strings.formatActivateWhenNoMoreThanDeactivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 0 && this.d_logicType == 2 && this.d_sourceActivates) {
                    str = strings.formatActivateWhenAtLeastActivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 0 && this.d_logicType == 2 && !this.d_sourceActivates) {
                    str = strings.formatActivateWhenAtLeastDeactivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 0 && this.d_logicType == 4 && this.d_sourceActivates) {
                    str = strings.formatActivateWhenExactlyActivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 0 && this.d_logicType == 4 && !this.d_sourceActivates) {
                    str = strings.formatActivateWhenExactlyDeactivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 0 && this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenAnyActivate(this.d_editable, sinksStr, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 0 && !this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenAnyDeactivate(this.d_editable, sinksStr, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 1 && this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenAllActivate(this.d_editable, sinksStr, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 1 && !this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenAllDeactivate(this.d_editable, sinksStr, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 3 && this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenNoMoreThanActivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 3 && !this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenNoMoreThanDeactivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 2 && this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenAtLeastActivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 2 && !this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenAtLeastDeactivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 4 && this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenExactlyActivate(this.d_editable, sinksStr, this.d_n, inputStr);
                } else if (this.d_action == 1 && this.d_logicType == 4 && !this.d_sourceActivates) {
                    str = strings.formatDeactivateWhenExactlyDeactivate(this.d_editable, sinksStr, this.d_n, inputStr);
                }
                if (this.d_editable || this.d_delay.getValueNoUnit() > 0.0) {
                    String str2 = "<br>";
                    if (this.d_action == 1) {
                        str2 = str2 + strings.formatDelayDeactivation(this.d_editable, this.d_delay);
                    } else if (this.d_action == 0) {
                        str2 = str2 + strings.formatDelayActivation(this.d_editable, this.d_delay);
                    }
                    str = str + str2;
                }
            } else if (this.d_input == 0) {
                String sinksStr = this.getSinksStr();
                if (this.d_action == 0) {
                    str = strings.formatActivateAtTime(this.d_editable, sinksStr, this.d_t);
                } else if (this.d_action == 1) {
                    str = strings.formatDeactivateAtTime(this.d_editable, sinksStr, this.d_t);
                }
            } else if (this.d_input == 4) {
                String sinksStr = this.getSinksStr();
                str = this.d_editable ? strings.formatControlOnSequence(this.d_editable, sinksStr) : strings.formatControlOnTimedEvents(this.d_editable, sinksStr);
            } else if (this.d_input == 2) {
                String sinksStr = this.getSinksStr();
                String srcStr = this.getInputMeasurerStr();
                str = this.d_dbUpper ? strings.formatTurnOffWhenBelowOnWhenAbove(this.d_editable, sinksStr, srcStr, this.d_dbRange[0], this.d_dbRange[1]) : strings.formatTurnOnWhenBelowOffWhenAbove(this.d_editable, sinksStr, srcStr, this.d_dbRange[0], this.d_dbRange[1]);
            }
        } else if (this.d_editable) {
            String sinksStr = this.getSinksStr();
            String srcStr = this.getCustomInputStr();
            str = this.d_dstObjNames != null && this.d_dstObjNames.size() <= 1 || this.d_dstObjs.size() <= 1 ? strings.formatExistsWhenTrue(this.d_editable, sinksStr, srcStr) : strings.formatExistWhenTrue(this.d_editable, sinksStr, srcStr);
        } else {
            str = strings.formatCustomActivation();
        }
        return str;
    }

    private String formatT() {
        return this.d_t == null ? TBEGIN : Global.format(this.d_t);
    }

    public boolean validateData(Component parent, SinkType sinkType, boolean showWarn, boolean modify) {
        parent = Utils.findParentWindow(parent);
        if (this.d_input == 0) {
            if (this.d_action == 1 && this.d_t == null) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(parent, String.format(Intl.intl("%1$s may only be entered if the action type is %2$s."), TBEGIN, sinkType.strings.activate), Intl.intl("Invalid Entry"), 0);
                }
                return false;
            }
        } else if (this.d_input == 1) {
            if (this.d_srcDetectors.isEmpty()) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(parent, Intl.intl("You must select at least one source detector."), Intl.intl("No Source Detectors Selected"), 0);
                }
                return false;
            }
        } else if (this.d_input == 2) {
            if (this.d_srcMeasurer == null) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(parent, Intl.intl("You must select a source device."), Intl.intl("No Source Device Selected"), 0);
                }
                return false;
            }
            if (this.d_dbRange[0].compareTo(this.d_dbRange[1]) >= 0) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(parent, Intl.intl("The lower bound of the deadband must be less than the upper bound."), Intl.intl("Invalid Deadband Range"), 0);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public IOutPin save() {
        if (this.d_action == 0 && this.d_input == 0 && this.d_t == null) {
            return null;
        }
        IOutPin srcPin = null;
        if (this.d_input == 0) {
            if (this.d_action == 0 || this.d_action == 1) {
                Timer timer = new Timer(this.d_t, this.d_action == 1);
                srcPin = timer.getOutputPins().get(0);
            }
        } else if (this.d_input == 1) {
            if (this.d_action == 0 || this.d_action == 1) {
                boolean invert;
                boolean bl = invert = !this.d_sourceActivates;
                if (this.d_srcDetectors.size() > 1) {
                    int lt = this.d_logicType;
                    if (lt == 1 || lt == 0) {
                        ALogicOp op = lt == 1 ? new AndOp() : new OrOp();
                        for (IOutPin iOutPin : this.d_srcDetectors) {
                            void var6_15;
                            if (invert) {
                                NotOp notOp = new NotOp();
                                notOp.getInputPin().connect(iOutPin);
                                IOutPin iOutPin2 = notOp.getOutputPins().get(0);
                            }
                            op.getInputPin().connect((IOutPin)var6_15);
                        }
                        srcPin = op.getOutputPins().get(0);
                    } else {
                        AIntCompareOp op = null;
                        if (lt == 2) {
                            op = new IntGreaterThanOp(this.d_n - 1);
                        } else if (lt == 3) {
                            op = new IntLessThanOp(this.d_n + 1);
                        } else if (lt == 4) {
                            op = new IntEqualOp(this.d_n);
                        }
                        if (op != null) {
                            CountOp sop = new CountOp();
                            for (IOutPin iOutPin : this.d_srcDetectors) {
                                void var7_20;
                                if (invert) {
                                    NotOp not = new NotOp();
                                    not.getInputPin().connect(iOutPin);
                                    IOutPin iOutPin3 = not.getOutputPins().get(0);
                                }
                                sop.getInputPin().connect((IOutPin)var7_20);
                            }
                            op.getInputPin().connect(sop.getOutputPins().get(0));
                            srcPin = op.getOutputPins().get(0);
                        }
                    }
                } else if (this.d_srcDetectors.size() == 1) {
                    srcPin = this.d_srcDetectors.get(0);
                    if (invert) {
                        NotOp not = new NotOp();
                        not.getInputPin().connect(srcPin);
                        srcPin = not.getOutputPins().get(0);
                    }
                }
                if (srcPin != null) {
                    if (this.d_srcDetectors.size() != 1 || this.d_delay.getValueNoUnit() > 0.0 || this.d_action == 1) {
                        LatchCtrl latch = new LatchCtrl();
                        latch.getInputPin().connect(srcPin);
                        srcPin = latch.getOutputPins().get(0);
                    }
                    if (this.d_delay.getValueNoUnit() > 0.0) {
                        TimeDelayCtrl delay = new TimeDelayCtrl(this.d_delay);
                        delay.getInputPin().connect(srcPin);
                        srcPin = delay.getOutputPins().get(0);
                    }
                    if (this.d_action == 1) {
                        NotOp not = new NotOp();
                        not.getInputPin().connect(srcPin);
                        srcPin = not.getOutputPins().get(0);
                    }
                }
            }
        } else if (this.d_input == 2 && this.d_srcMeasurer != null) {
            int tripDir = this.d_dbUpper ? 1 : 0;
            DeadbandCtrl ctrl = new DeadbandCtrl(tripDir, this.d_dbRange[0], this.d_dbRange[1]);
            ctrl.getInputPin().connect(this.d_srcMeasurer);
            srcPin = ctrl.getOutputPins().get(0);
        }
        return srcPin;
    }

    public void load(IInPin inPin) {
        if (inPin.getConnections().isEmpty()) {
            this.d_action = 0;
            this.d_input = 0;
            this.setT(null);
            return;
        }
        boolean custom = true;
        DupAccumulation accum = this.accumulateDuplicates(inPin.getConnections());
        int accumType = accum.getAccumType();
        if (accumType == 3) {
            if (accum.d_nextInputs.size() == 1) {
                ISignalSource src = ((IOutPin)accum.d_nextInputs.iterator().next()).getAttachedSource();
                if (src instanceof ADblCompareOp) {
                    ISignalSource cmpIn;
                    ADblCompareOp cmpOp = (ADblCompareOp)src;
                    if (cmpOp.getInputPin().getConnectedSources().size() == 1 && (cmpIn = cmpOp.getInputPin().getConnectedSources().iterator().next()) instanceof Clock) {
                        int action;
                        this.d_action = action = cmpOp instanceof DblGreaterThanOp ? 0 : 1;
                        this.d_input = 0;
                        this.setT(cmpOp.getN());
                        custom = false;
                    }
                } else if (src instanceof Timer) {
                    Timer timer = (Timer)src;
                    int action = TripFlags.initiallyOn(timer.getAlarmInfo().tripFlags) ? 1 : 0;
                    UnitDouble t = timer.getAlarmInfo().setpoint;
                    this.d_action = action;
                    this.d_input = 0;
                    this.setT(t);
                    custom = false;
                } else if (src instanceof CustomCtrl) {
                    this.d_input = 4;
                    custom = false;
                } else if (src instanceof DeadbandCtrl) {
                    DeadbandCtrl deadbandCtrl = (DeadbandCtrl)src;
                    if (deadbandCtrl.getInputPin().getConnections().size() == 1) {
                        IOutPin dbsrc = deadbandCtrl.getInputPin().getConnections().iterator().next();
                        this.d_input = 2;
                        this.setDBBound(deadbandCtrl.getLowerBound(), true);
                        this.setDBBound(deadbandCtrl.getUpperBound(), false);
                        if (deadbandCtrl.getTripDirection() == 0) {
                            this.setDBLogic(true, true);
                        } else if (deadbandCtrl.getTripDirection() == 1) {
                            this.setDBLogic(true, false);
                        }
                        this.setSourceMeasurer((IDoubleOutPin)dbsrc);
                        custom = false;
                    }
                } else if (src instanceof IDevice && src instanceof ISignalSource && !(src instanceof Timer) || src instanceof ControlBridge) {
                    ILogicOutPin opin = (ILogicOutPin)accum.d_nextInputs.iterator().next();
                    this.d_action = 0;
                    this.d_input = 1;
                    this.setSources(Collections.singletonList(opin));
                    custom = false;
                }
            }
        } else {
            boolean latch;
            int action = 0;
            if (accumType == 1) {
                if (accum.d_invertCount % 2 != 0) {
                    action = 1;
                }
                accum = this.accumulateDuplicates(accum.d_nextInputs);
                accumType = accum.getAccumType();
            }
            this.d_action = action;
            UnitDouble delay = new UnitDouble(0.0, SI.SECOND);
            if (accumType == 2) {
                delay = accum.d_delay;
                accum = this.accumulateDuplicates(accum.d_nextInputs);
                accumType = accum.getAccumType();
            }
            this.setDelay(delay);
            this.d_input = 1;
            boolean bl = latch = accumType == 0;
            if (latch) {
                accumType = (accum = this.accumulateDuplicates(accum.d_nextInputs)).getAccumType();
                if (accumType == 1 && accum.d_invertCount % 2 != 0) {
                    ISignalSource src;
                    if (accum.d_nextInputs.size() == 1 && (src = ((IOutPin)accum.d_nextInputs.iterator().next()).getAttachedSource()) instanceof IDevice && !(src instanceof Timer)) {
                        this.setSourceActivates(false);
                        this.setSources(Arrays.asList((ILogicOutPin)accum.d_nextInputs.iterator().next()));
                        custom = false;
                    }
                } else if (accum.d_nextInputs.size() > 0) {
                    ISignalSource src = ((IOutPin)accum.d_nextInputs.iterator().next()).getAttachedSource();
                    if (src instanceof ControlBridge || src instanceof IDevice && !(src instanceof Timer)) {
                        this.setSourceActivates(true);
                        this.setSources(Arrays.asList((ILogicOutPin)accum.d_nextInputs.iterator().next()));
                        custom = false;
                    } else if (src instanceof ALogicOp || src instanceof AIntCompareOp) {
                        Set<IOutPin> logicInputs = ((IControl)src).getInputPin().getConnections();
                        if (src instanceof AIntCompareOp) {
                            logicInputs = ((AIntCompareOp)src).getInputPin().getConnections();
                            logicInputs = logicInputs.size() == 1 && logicInputs.iterator().next().getAttachedSource() instanceof CountOp ? ((CountOp)logicInputs.iterator().next().getAttachedSource()).getInputPin().getConnections() : Collections.emptySet();
                        }
                        if (logicInputs.size() > 0) {
                            ArrayList<ILogicOutPin> inputs = new ArrayList<ILogicOutPin>();
                            int invalidCount = 0;
                            int invertCount = 0;
                            for (IOutPin input : logicInputs) {
                                DupAccumulation accum2 = this.accumulateDuplicates(Collections.singletonList(input));
                                int at2 = accum2.getAccumType();
                                if (at2 == 1 && accum2.d_invertCount % 2 != 0) {
                                    ++invertCount;
                                } else if (at2 != 3) {
                                    ++invalidCount;
                                }
                                if (!accum2.d_nextInputs.isEmpty()) {
                                    IOutPin pin = (IOutPin)accum2.d_nextInputs.iterator().next();
                                    if (pin.getAttachedSource() instanceof IDevice && !(pin.getAttachedSource() instanceof Timer) || pin.getAttachedSource() instanceof ControlBridge) {
                                        inputs.add((ILogicOutPin)accum2.d_nextInputs.iterator().next());
                                        continue;
                                    }
                                    ++invalidCount;
                                    continue;
                                }
                                ++invalidCount;
                            }
                            if (invalidCount == 0 && (invertCount == 0 || invertCount == logicInputs.size())) {
                                this.setSourceActivates(invertCount == 0);
                                this.setSources(inputs);
                                int logicType = -1;
                                int n = -1;
                                if (src instanceof AndOp) {
                                    logicType = 1;
                                } else if (src instanceof OrOp) {
                                    logicType = 0;
                                } else if (src instanceof IntGreaterThanOp) {
                                    logicType = 2;
                                    n = ((AIntCompareOp)src).getN() + 1;
                                } else if (src instanceof IntLessThanOp) {
                                    logicType = 3;
                                    n = ((AIntCompareOp)src).getN() - 1;
                                } else if (src instanceof IntEqualOp) {
                                    logicType = 4;
                                    n = ((AIntCompareOp)src).getN();
                                }
                                if (logicType != -1) {
                                    this.setLogicType(logicType);
                                    if (n != -1) {
                                        this.setN(n);
                                    }
                                    custom = false;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (custom) {
            this.d_input = 3;
        }
    }

    private DupAccumulation accumulateDuplicates(Collection<? extends IOutPin> inputs) {
        DupAccumulation accum = new DupAccumulation(inputs);
        this.accumulateDuplicates(accum);
        return accum;
    }

    private void accumulateDuplicates(DupAccumulation accum) {
        if (accum.d_nextInputs.size() != 1) {
            return;
        }
        ISignalSource src = ((IOutPin)accum.d_nextInputs.iterator().next()).getAttachedSource();
        if (src instanceof LatchCtrl) {
            if (accum.getAccumType() != 3 && accum.getAccumType() != 0) {
                return;
            }
            accum.d_latch = true;
            accum.d_nextInputs = ((IControl)src).getInputPin().getConnections();
            this.accumulateDuplicates(accum);
        } else if (src instanceof NotOp) {
            if (accum.getAccumType() != 3 && accum.getAccumType() != 1) {
                return;
            }
            ++accum.d_invertCount;
            accum.d_nextInputs = ((IControl)src).getInputPin().getConnections();
            this.accumulateDuplicates(accum);
        } else if (src instanceof TimeDelayCtrl) {
            if (accum.getAccumType() != 3 && accum.getAccumType() != 2) {
                return;
            }
            accum.d_delay = accum.d_delay.add(((TimeDelayCtrl)src).getTimeDelay());
            accum.d_nextInputs = ((IControl)src).getInputPin().getConnections();
            this.accumulateDuplicates(accum);
        }
    }

    public static SinkType getSinkType(Collection<?> objs) {
        return !objs.isEmpty() && objs.stream().allMatch(s -> s instanceof IFreezable) ? SinkType.FREEZE : SinkType.ACTIVATE;
    }

    private static class DupAccumulation {
        private static final int ACCUM_LATCH = 0;
        private static final int ACCUM_INVERT = 1;
        private static final int ACCUM_TDELAY = 2;
        private static final int ACCUM_NONE = 3;
        private boolean d_latch = false;
        private int d_invertCount = 0;
        private UnitDouble d_delay = new UnitDouble(0.0, SI.SECOND);
        private Collection<? extends IOutPin> d_nextInputs;

        public DupAccumulation(Collection<? extends IOutPin> nextInputs) {
            this.d_nextInputs = nextInputs;
        }

        public int getAccumType() {
            if (this.d_latch) {
                return 0;
            }
            if (this.d_invertCount > 0) {
                return 1;
            }
            if (this.d_delay.getValueNoUnit() > 0.0) {
                return 2;
            }
            return 3;
        }
    }

    public static enum SinkType {
        ACTIVATE(new ICtrlDescStringFormatter.ActivateStrings()),
        FREEZE(new ICtrlDescStringFormatter.FreezeStrings());

        public final ICtrlDescStringFormatter.Strings strings;

        private SinkType(ICtrlDescStringFormatter.Strings strings) {
            this.strings = strings;
        }
    }
}

